﻿class Ball extends Sphere {
	var vx:Number = 0;
	var timer:Number;
	var frame:Number=0;
	var name:String;
	var undrop:BallPot;
	var parent:String;
	var xOffset:Number;
	var yOffset:Number;
	var scale:Number = 100;
	var isPot:Boolean = false;
	static var active:Boolean = true;
	function Ball() {
		vx = 0;
		vy = 0;
	}
	function set xVelocity(v:Number):Void {
		vx = v;
	}
	function get xVelocity():Number {
		return vx;
	}
	var vy:Number = 0;
	function set yVelocity(v:Number):Void {
		vy = v;
	}
	function get yVelocity():Number {
		return vy;
	}
	var lx:Number = 0;
	var ly:Number = 0;
	var __pot:BallPot;
	function set pot(p:BallPot):Void {
		if(p==__pot) {
			return;
		}
		if(p != null) {
			__pot.removeBall(this);
			__pot = p;
			p.addBall(this);
		}
		else {
			__pot.removeBall(this);
			__pot = p;
		}
		wakeup();
	}
	function get pot():BallPot {
		return __pot;
	}
	//var dragging:Boolean = false;
	/*
						static var collide0_snd:Sound;
						static var collide1_snd:Sound;
						static var collide2_snd:Sound;
						static var collide3_snd:Sound;
						*/
	var debug:Boolean = false;
	var _baseRadius:Number = 1;
	function init(x:Number, y:Number, r:Number, p:BallPot) {
		//trace(this + ".init("+x+","+y+","+r+","+p);
		name = _name;
		parent = p._name;
		xcentre = x;
		ycentre = y;
		_baseRadius=radius = r;
		vx = 0;
		vy = 0;
		pot = p;
	}
	function scaleAdjust() {
		if(__pot != null) {
			scale = 0.8*scale+0.2*pot._xscale;
			_xscale = scale;
			_yscale = scale;
			__radius = _baseRadius*(scale/100);
		}
	}
	function frameAnimation():Void {
		if(__pot == null || __pot.guys==null)
			return;
		if(!active && (frame++ % Constants.kSettleFrames==0) && pot.guys[0]==this) {
			if(pot.settled())
				return;
		}
		scaleAdjust();
		if (getTimer()-timer>Constants.kActiveTime) {
			active = false;
		}
		vx *= Constants.kDamp;
		vy *= Constants.kDamp;
		// gravity
		var gx = 0;
		var gy = 0;
		var dx = __pot.xcentre-(xcentre+vx);
		var dy = __pot.ycentre-(ycentre+vy);
		var dist = dx*dx+dy*dy;
		//if (dist<4*pot.radius*pot.radius) {
			vx += Constants.kGravInPot*dx;
			vy += Constants.kGravInPot*dy;
		//} else {
		//	vx += 6*Constants.kGravWeight*dx/dist;
		//	vy += 6*Constants.kGravWeight*dy/dist;
		//}
		// Object collisions
		var fx = 0;
		var fy = 0;
		//trace(__pot + "["+__pot.guys.length+"]" + vx + ","+vy);
		for (var i = __pot.guys.length-1; i>=0; --i) {
			var bb = __pot.guys[i];
			if (bb != this /*&& hitTest(bb)*/) {
				var dx = (xcentre+vx)-bb.xcentre;
				var dy = (ycentre+vy)-bb.ycentre;
				var dist = Math.sqrt(dx*dx+dy*dy);
				var dmax = (1+pot.guys.length/80)*(radius+bb.radius)-dist;
				if (dmax>0) {
					var mag1 = dmax*Constants.kCollisionDamp*bb.radius/((dist+0.1)*radius);
					var v2 = vx*vx+vy*vy;
					fx += dx*mag1;
					fy += dy*mag1;
				}
			}
		}
		vx += fx;
		vy += fy;
		vx *= 0.7;
		vy *= 0.7;
		xcentre += vx;
		ycentre += vy;
	}
	function moveWithParent() {
		xcentre = __pot.xcentre+xOffset;
		ycentre = __pot.ycentre+yOffset;
	}
	function sleep() {
		if (__pot != null) {
			xOffset = xcentre-__pot.xcentre;
			yOffset = ycentre-__pot.ycentre;
			onEnterFrame = moveWithParent;
		} else {
			onEnterFrame = undefined;
		}
	}
	function wakeup() {
		timer = getTimer();
		if(onEnterFrame == frameAnimation)
			return;
		onEnterFrame = frameAnimation;
	}
	function remove() {
		this.removeMovieClip();
	}
	function sendToTrash() {
		pot=_level0[parent];
		//#TODO Remove dependency on level0 in next line!
		var trash = _level0["gridPot"];
		trash._balls.push(this);
		for(var j=0; j < trash._dropped.length;j++) {
			if(trash._dropped[j]==this) {
				trash._dropped.splice(j,1);
				break;
			}
		}
		//trace("trash="+trash+" _balls="+trash._balls.length+" _dropped="+trash._dropped.length);
		wakeup();
	}
}
