﻿
class History extends MovieClip {
	
	//This counts the number of balls in the history.
	var tally:Number = 0;
	
	//The width of the spheres.
	var widthSphere:Number = 15;
	
	//Spacing between spheres.
	var spaceSphere:Number = 2;
	
	//Used for wizzing balls around.
	var intervalID:Number = null;
	
	//Constructor.
	function History() {
		
	}
	
	//Add a new ball.
	function newBall(tag:Number,colour:String):Void {
		
		//Update tally;
		tally++;
		
		//Create a new ball.
		var b = Ball(attachMovie("Ball","ball"+tag,this.getNextHighestDepth(),{
			_x : pos(tally)[0],
			_y : pos(tally)[1],
			tag : tag,
			colour : colour,
			_xscale : 50,
			_yscale : 50,
			nullify : true
		}));
		b.changeColour();
		wizz(b);
	}
	
	function removeBall(tag:Number):Void {
		this["ball"+tag].removeMovieClip();
		tally--;
	}
	
	
	
	//Need a function that calculates the final x and y co-ordinate of the mth ball.
	function pos(m:Number):Array {
		var p:Number = Math.floor((m-0.1)/15);
		var q:Number = (m-1)%15+1;
		return [p*(widthSphere+spaceSphere),q*(widthSphere+spaceSphere)];
	}
	
	
	
	//This function takes a newly introduced movieclip and whizzes it from right to left to its final destination (X,Y).
	function wizz(mc:MovieClip):Void {
		
		var X:Number = mc._x;
		//var Y:Number = mc._y;
		
		mc._x += 200;
		//trace(intervalID);
		if (intervalID == null)	intervalID = setInterval(this, "translate", 5,mc,X);
		else mc._x -= 200;
	}
	
	//Shifts MovieClip left.
	function translate(mc:MovieClip,X:Number) {
		mc._x -= 4;
		
		updateAfterEvent();
	
		if (mc._x < X-10
			) {
			clearInterval(intervalID);
			intervalID = null;
			mc._x = X;
		}
	}
	
	
}