/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Vector;

class Parser {
    public String text;
    public int text_index;
    char current_char;
    int last_text_index;
    char last_char;
    static String single_quote_chars = "'\u00b4`'";
    static String breaking_chars = " \r\n\t\\";
    static String white_characters = " \t\r\n\f";
    static String comment_end = "*)";
    static String[] standard_parts = new String[]{"Capital", "Script", "Gothic", "Not", "DoubleStruck", "Doubled", "Double", "Filled", "Left", "Right", ""};
    static String[] standard_short_parts = new String[]{"c", "s", "g", "n", "t", "v", "w", "f", "l", "r"};
    static String coded_char_names = "0AA225AB257AC259AD228AE230AG224AH226Ak63272Ale8501AliasD63332AliasI63336Alig63328Alp945Alt63441Andy63273And8743Angl8736Angs8491AR229As8944AT227AutoL62376AutoO62382AutoP62372AutoR62377AutoS62381Ba8726Bec8757Beta946Bet8502Br774Bu8226CAc263Cap8994cAA193cAB256cAC258cAD196cAE198cAG192cAH194cAl913cAR197cAT195cB914cCA262cCC199cCH268cCh935cDe916cDif63307cDig988cEA201cEB274cEC276cED203cEG200cEH202cEp917cEta919cEth208cG915cIA205cIC300cID207cIG204cIH206cIo921cKa922cKo990cLa923cLS321cM924cNT209cNu925cOA211cODoubleA336cODoubleD214cOG210cOH212cOme937cOmi927cOS216cOT213cPh934cPi928cPs936cR929cSa992cSH352cSi931cSt986cTa932cThe920cTho222cUA218cUDoubleA368cUDoubleD220cUG217cUH219cUp933cX926cY221cZ918CC231Ced807CenterD183CenterE8943Cent162CH269Ch967CircleD8857CircleM8854CircleP8853CircleT8855Cloc8754CloseCurlyD8221CloseCurlyQ8217Clov8984Clu9827Col8758Com63338Cong8801Conti62385Conto8750Contr63331Copr8720Copy169Cou8755Cr62624CupC8781Cup8995CurlyCapitalU978CurlyE603CurlyK1008CurlyPh981CurlyPi982CurlyR1009CurlyT977Curr164Dag8224Dal8504Das8211Deg176Dele63440Delt948Del8711Des8945Diame62468Diamond62753DiamondS9826Dif63308Dig63249Div247DotE8784DotlessI305DotlessJ63232Dott63313wC8751wDa8225vG63306wDot776wDow8659vP63305wlA8656wlr8660wlT62467wLongLeftA62720wLongLeftR62722wLongRightA62721wP8243wrA8658wrT8872tA63206tB63207tC63208tcA63396tcB63397tcC63398tcD63399tcE63400tcF63401tcG63402tcH63403tcI63404tcJ63405tcK63406tcL63407tcM63408tcN63409tcO63410tcP63411tcQ63412tcR63413tcS63414tcT63415tcU63416tcV63417tcW63418tcX63419tcY63420tcZ63421tD63209tE63210tF63211tG63212tH63213tI63214tJ63215tK63216tL63217tM63218tN63219tO63220tP63221tQ63222tR63223tS63224tT63225tU63226tV63227tW63228tX63229tY63230tZ63231wUpA8657wUpD8661wV8741DownArrowB62724DownArrowU62726DownArrow8595DownB785DownE161DownLeftR62731DownLeftT62734DownLeftVectorB62732DownLeftVector8637DownQ191DownRightT62735DownRightVectorB62733DownRightVector8641DownTeeA8615DownTee8868EA233EB275EC277ED235EG232EH234Ele8712Ell8230EmptyC9675EmptyDi9671EmptyDo9661EmptyR9647EmptySe8709EmptySmallC9702EmptySmallS62759EmptySq9635EmptyU9651EmptyV62768En63444Ep949EqualT8770Equal62513Equi8652Er63335Es63337Eta951Eth240Exi8707Exp63309Fe63274Fi63233fC9679fDi9670fDo9660fR9646fSmallC63312fSmallS62760fS9634fU9650fV62761Fin962Fiv9733Fla9837FlL63234Flo402Fo8704Fr63265Ga947Gi8503gA63180gB63181gC63182gcA63370gcB63371gcC63372gcD63373gcE63374gcF63375gcG63376gcH63377gcI63378gcJ63379gcK63380gcL63381gcM63382gcN63383gcO63384gcP63385gcQ63386gcR63387gcS63388gcT63389gcU63390gcV63391gcW63392gcX63393gcY63394gcZ63395gD63183gE63184gF63185gG63186gH63187gI63188gJ63189gK63190gL63191gM63192gN63193gO63194gP63195gQ63196gR63197gS63198gT63199gU63200gV63201gW63202gX63203gY63204gZ63205GrayC63315GrayS63314GreaterEqualL8923GreaterEqual8805GreaterF8807GreaterG8811GreaterL8823GreaterS62502GreaterT8819Hac780Hap9786HB8463He9825Ho62977HumpD8782HumpE8783Hy173IA237IC301ID239IG236IH238ImaginaryI63310ImaginaryJ63311Imp62755Ind62371Inf8734Integ8747Inter8898InvisibleC63333InvisiblePo62388InvisiblePr62387InvisibleS62304Io953Ka954Ker63318Key63443Ko63250La955lAn9001lArrowB8676lArrowR8646lArrow8592lB62979lC8968lwBracketi62981lwBracket12314lDownT62745lDownVectorB62743lDownVector8643lF8970lG171lM63339lrA8596lrV62725lS63329lTeeA8612lTeeV62729lTee8867lTriangleB62480lTriangleE8884lTriangle8882lUpD62741lUpT62744lUpVectorB62742lUpVector8639lVectorB62727lVector8636LessEqualG8922LessEqual8804LessF8806LessG8822LessL8810LessS62496LessT8818Li63267LongD8212LongLeftA62748LongLeftR62750LongR62749LowerL8601LowerR8600LS322Ma63319Mea8737Med62308Mh8487Mic181Min8723Mo63446Mu956Na9838NegativeM62339NegativeThic62340NegativeThin62338NegativeV62336NestedG62501NestedL62497Neu63266NoB62370Non160nCo8802nCu8813nw8742nEl8713nEqualT62464nEqual8800nEx8708nGreaterE8817nGreaterF8809nGreaterG62503nGreaterL8825nGreaterS62505nGreaterT8821nGreater8815nHumpD62466nHumpE62465nlTriangleB62482nlTriangleE8940nlTriangle8938nLessE8816nLessF8808nLessG8824nLessL62498nLessS62500nLessT8820nLess8814nNestedG62504nNestedL62499nPrecedesE8928nPrecedesS62507nPrecedesT8936nPrecedes8832nRe8716nrTriangleB62483nrTriangleE8941nrTriangle8939nSquareSubsetE8930nSquareSubset62510nSquareSupersetE8931nSquareSuperset62511nSubsetE8840nSubset8836nSucceedsE8929nSucceedsS62509nSucceedsT8937nSucceeds8833nSupersetE8841nSuperset8837nTildeE8772nTildeF8775nTildeT8777nTilde8769nV8740NT241Nul62368Num63268Nu957OA243ODoubleA337ODoubleD246OG242OH244Ome969Omi959OpenCurlyD8220OpenCurlyQ8216Opt63442Or8744OS248OT245OverBrace62994OverBrack62996OverP62992Para182Part8706Ph966Pi960Pla9633Plu177PrecedesE8828PrecedesS62506PrecedesT8830Precedes8826Pri8242Prod8719Proportiona8733Proportion8759Ps968Reg174ReturnI8629ReturnK63334ReverseD8245ReverseEl8715ReverseEq8651ReverseP8244ReverseU62747Rh961rAngleB9002rAngle8735rArrowB8677rArrowL8644rArrow8594rB62980rC8969rwBracketi62982rwBracket12315rDownT62740rDownVectorB62738rDownVector8642rF8971rG187rM63340rS63330rTeeA8614rTeeV62730rTee8866rTriangleB62481rTriangleE8885rTriangle8883rUpD62736rUpT62739rUpVectorB62737rUpVector8638rVectorB62728rVector8640RoundI62756RoundS62386RuleD62751Rule62754Sad9785Sam63251sA63154sB63155sC63156scA63344scB63345scC63346scD63347scE63348scF63349scG63350scH63351scI63352scJ63353scK63354scL63355scM63356scN63357scO63358scP63359scQ63360scR63361scS63362scT63363scU63364scV63365scW63366scX63367scY63368scZ63369sDotlessI63280sDotlessJ63281sD63157sE63158sF63159sG63160sH63161sI63162sJ63163sK63164sL63165sM63166sN63167sO63168sP63169sQ63170sR63171sS63172sT63173sU63174sV63175sW63176sX63177sY63178sZ63179Sec167Sel9632SH353Sha9839Shi63445ShortD62763ShortL62758ShortR62757ShortU62762Sig963Six63317Sk8259Sm8728SpaceI9251SpaceK63423Spa9824Sp8738Sqr8730SquareI8851SquareSubsetE8849SquareSubset8847SquareSupersetE8850SquareSuperset8848SquareU8852Square62752Sta8902Ste163Sti63248SubsetE8838Subset8834SucceedsE8829SucceedsS62508SucceedsT8831Succeeds8827Such8717Sum8721SupersetE8839Superset8835SZ223Tab63422Tau964Ther8756Thet952Thick62309Thin62307Tho254TildeE8771TildeF8773TildeT8776Tilde8764Tim215Tra63270Tri8411UA250UDoubleA369UDoubleD252UG249UH251UnderBrace62995UnderBrack62997UnderP62993UnionP8846Union8899Unk65533UpArrowB62723UpArrowD8645UpArrow8593UpD8597UpE62746UpperL8598UpperR8599Ups965UpTeeA8613UpTee8869Vee8897VerticalB8739VerticalE8942VerticalL62978VerticalS62514VerticalT8768Very62305Vi63271War63269Wat63316Wed8896Wei8472Wo63264Xi958YA253YD255Ye165Ze950   ";
    double scanned_real;
    boolean is_scanned_real;
    public static int TOKEN_COMMA = 0;
    public static int TOKEN_LEFT_PARENTHESIS = 1;
    public static int TOKEN_RIGHT_PARENTHESIS = 2;
    public static int TOKEN_LEFT_BRACKET = 3;
    public static int TOKEN_RIGHT_BRACKET = 4;
    public static int TOKEN_LEFT_BRACE = 5;
    public static int TOKEN_RIGHT_BRACE = 6;
    public static int TOKEN_IDENTIFIER = 7;
    public static int TOKEN_NUMBER = 8;
    public static int TOKEN_RIGHT_ARROW = 9;
    public static int TOKEN_STRING = 10;
    public static int TOKEN_NONE = 11;
    public static int TOKEN_UNIDENTIFIED = 12;
    static String token_symbols = ",()[]{}a1>_?";
    static String structure_characters = ",()[]{}";
    static String number_start = "+-.0123456789";
    static String digit_characters = "0123456789";
    static String octal_digits = "01234567";
    static String hexadecimal_digits = "0123456789abcdefABCDEF";
    int scanned_token_type;
    double scanned_number;
    String scanned_identifier;
    String scanned_string;
    static int max_length_identifier = 100;
    char[] scanned_identifier_chars = new char[max_length_identifier];
    public static int CONSTRUCT_NONE = 0;
    public static int CONSTRUCT_FUNCTION = 1;
    public static int CONSTRUCT_SYMBOL = 2;
    public static int CONSTRUCT_LIST = 3;
    public static int CONSTRUCT_RULE = 4;
    public static int CONSTRUCT_UNIDENTIFIED = 5;
    static String name_ShowAnimation = "ShowAnimation";
    static String name_AnimationDisplayTime = "AnimationDisplayTime";
    static String name_AnimationDirection = "AnimationDirection";
    static String name_Forward = "Forward";
    static String name_Backward = "Backward";
    static String name_ForwardBackward = "ForwardBackward";
    static String name_Graphics3D = "Graphics3D";
    static String name_Scaled = "Scaled";
    static String name_Cuboid = "Cuboid";
    static String name_Line = "Line";
    static String name_Point = "Point";
    static String name_Polygon = "Polygon";
    static String name_Text = "Text";
    static String name_StyleForm = "StyleForm";
    static String name_Questionmark = "?";
    static String name_TextStyle = "TextStyle";
    static String name_FontWeight = "FontWeight";
    static String name_Bold = "Bold";
    static String name_FontSize = "FontSize";
    static String name_FontSlant = "FontSlant";
    static String name_Italic = "Italic";
    static String name_FontFamily = "FontFamily";
    static String name_FontColor = "FontColor";
    static String name_URL = "URL";
    static String name_AbsolutePointSize = "AbsolutePointSize";
    static String name_AbsoluteThickness = "AbsoluteThickness";
    static String name_CMYKColor = "CMYKColor";
    static String name_EdgeForm = "EdgeForm";
    static String name_FaceForm = "FaceForm";
    static String name_GrayLevel = "GrayLevel";
    static String name_Hue = "Hue";
    static String name_PointSize = "PointSize";
    static String name_RGBColor = "RGBColor";
    static String name_SurfaceColor = "SurfaceColor";
    static String name_Thickness = "Thickness";
    static String name_AmbientLight = "AmbientLight";
    static String name_Axes = "Axes";
    static String name_AxesLabel = "AxesLabel";
    static String name_AxesEdge = "AxesEdge";
    static String name_AxesStyle = "AxesStyle";
    static String name_PlotLabel = "PlotLabel";
    static String name_Background = "Background";
    static String name_Boxed = "Boxed";
    static String name_BoxRatios = "BoxRatios";
    static String name_BoxStyle = "BoxStyle";
    static String name_DefaultColor = "DefaultColor";
    static String name_Lighting = "Lighting";
    static String name_LightSources = "LightSources";
    static String name_PlotRange = "PlotRange";
    static String name_Ticks = "Ticks";
    static String name_ViewPoint = "ViewPoint";
    static String name_ViewVertical = "ViewVertical";
    static String name_True = "True";
    static String name_False = "False";
    static String name_Automatic = "Automatic";
    static String name_All = "All";
    static String name_None = "None";
    boolean scanning_EdgeForm;
    boolean scanning_FaceForm;
    boolean scanning_FaceForm_back;
    boolean scanning_SurfaceColor;
    boolean scanning_SurfaceColor_specular;
    boolean scanning_AxesStyles;
    double scanned_AnimationDisplayTime = 0.05;
    int scanned_AnimationDirection = 1;
    Vector scanned_frames;
    boolean scanning_animation_option = false;
    Graphics3D graphics;
    boolean is_scanned_AmbientLight;
    boolean is_scanned_Axes;
    boolean is_scanned_AxesLabel;
    boolean is_scanned_AxesStyle;
    boolean is_scanned_AxesEdge;
    boolean is_scanned_Ticks;
    boolean is_scanned_PlotLabel;
    boolean is_scanned_Background;
    boolean is_scanned_DefaultColor;
    boolean is_scanned_BoxStyle;
    boolean is_scanned_Boxed;
    boolean is_scanned_Lighting;
    boolean is_scanned_BoxRatios;
    boolean is_scanned_PlotRange;
    boolean is_scanned_LightSources;
    boolean is_scanned_ViewPoint;
    boolean is_scanned_ViewVertical;
    boolean is_scanned_TextStyle;
    boolean scanned_nothing;
    boolean scanned_unidentified;
    int recursion_depth = 0;
    Primitive3D[] scanned_AxesStyles = new Primitive3D[]{null, null, null};
    static int max_count_scanned_numbers = 4;
    double[] scanned_numbers = new double[max_count_scanned_numbers];
    int count_scanned_numbers;
    int max_count_scanned_points;
    int count_scanned_points;
    double[][] scanned_points;
    double[][] scanned_scaled_offsets;
    Color scanned_color;
    String scanned_font_url;
    String scanned_font_family;
    int scanned_font_weight;
    int scanned_font_slant;
    int scanned_font_size;
    Color scanned_font_color;
    Color scanned_font_background;

    public Parser(String text) {
        this.text = text;
    }

    Color copied_color(Color color) {
        if (color == null) {
            return null;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    /*
     * Unable to fully structure code
     */
    char next_char() {
        processed = false;
        this.last_char = this.current_char;
        this.last_text_index = this.text_index++;
        if (this.text_index >= 0 && this.text_index < this.text.length()) ** GOTO lbl91
        this.current_char = (char)12;
        return this.current_char;
lbl-1000:
        // 1 sources

        {
            this.current_char = this.text.charAt(this.text_index);
            if (this.current_char == '\\' && this.text_index + 1 < this.text.length()) {
                ++this.text_index;
                this.current_char = this.text.charAt(this.text_index);
                if (this.current_char == '[') {
                    special_char_index = ++this.text_index;
                    while (this.text_index < this.text.length() && (Character.isLetterOrDigit(this.text.charAt(this.text_index)) || Parser.breaking_chars.indexOf(this.text.charAt(this.text_index)) >= 0)) {
                        ++this.text_index;
                    }
                    if (this.text_index >= this.text.length() || this.text.charAt(this.text_index) != ']') {
                        this.text_index = this.last_text_index + 1;
                        this.current_char = (char)92;
                        processed = true;
                        continue;
                    }
                    char_name = this.text.substring(special_char_index, this.text_index);
                    length = -1;
                    offset = 0;
                    block2: while (length != char_name.length()) {
                        length = char_name.length();
                        index = 0;
                        while ((part_length = Parser.standard_parts[index].length()) > 0) {
                            if (char_name.regionMatches(offset, Parser.standard_parts[index], 0, part_length)) {
                                char_name = String.valueOf(char_name.substring(0, offset)) + Parser.standard_short_parts[index] + char_name.substring(offset + part_length);
                                ++offset;
                                continue block2;
                            }
                            ++index;
                        }
                    }
                    uni_code = -1;
                    if (char_name.equals("n")) {
                        uni_code = 172;
                    } else if (char_name.length() >= 2) {
                        offset = 0;
                        pattern = char_name.substring(0, 2);
                        while (offset >= 0) {
                            if ((offset = Parser.coded_char_names.indexOf(pattern, offset + 1)) < 0 || !Character.isDigit(Parser.coded_char_names.charAt(offset - 1))) continue;
                            digit_index = offset + 2;
                            while (!Character.isDigit(Parser.coded_char_names.charAt(digit_index))) {
                                ++digit_index;
                            }
                            end_digit_index = digit_index + 1;
                            while (Character.isDigit(Parser.coded_char_names.charAt(end_digit_index))) {
                                ++end_digit_index;
                            }
                            if (!char_name.regionMatches(0, Parser.coded_char_names, offset, digit_index - offset)) continue;
                            offset = -1;
                            uni_code = Integer.parseInt(Parser.coded_char_names.substring(digit_index, end_digit_index));
                        }
                    }
                    if (uni_code >= 0) {
                        ascii_codes = new byte[]{(byte)(uni_code % 256)};
                        this.current_char = new String(ascii_codes, uni_code / 256).charAt(0);
                    } else {
                        this.current_char = (char)191;
                    }
                    processed = true;
                    continue;
                }
                if (Parser.white_characters.indexOf(this.current_char) >= 0) {
                    ++this.text_index;
                    while (this.text_index < this.text.length() && Parser.white_characters.indexOf(this.text.charAt(this.text_index)) >= 0) {
                        ++this.text_index;
                    }
                    if (this.text_index >= this.text.length()) {
                        this.text_index = this.text.length() - 1;
                        this.current_char = (char)32;
                        processed = true;
                        continue;
                    }
                    processed = false;
                    continue;
                }
                this.current_char = (char)92;
                --this.text_index;
                processed = true;
                continue;
            }
            if (Parser.single_quote_chars.indexOf(this.current_char) >= 0 && this.text_index + 1 < this.text.length() && Parser.single_quote_chars.indexOf(this.text.charAt(this.text_index + 1)) >= 0) {
                this.current_char = (char)34;
                ++this.text_index;
                processed = true;
                continue;
            }
            if (this.current_char == '(' && this.text_index + 1 < this.text.length() && this.text.charAt(this.text_index + 1) == '*') {
                this.text_index = this.text.indexOf(Parser.comment_end, this.text_index + 1);
                this.text_index = this.text_index == -1 ? this.text.length() - 1 : ++this.text_index;
                this.current_char = (char)32;
                processed = true;
                continue;
            }
            processed = true;
lbl91:
            // 9 sources

            ** while (!processed)
        }
lbl92:
        // 1 sources

        return this.current_char;
    }

    void unget_char() {
        this.current_char = this.last_char;
        this.text_index = this.last_text_index;
    }

    char first_non_white_char() {
        while (this.text_index < this.text.length() && white_characters.indexOf(this.current_char) >= 0) {
            this.next_char();
        }
        return this.current_char;
    }

    void scan_real() {
        int sign = 1;
        long integer_part = 0L;
        long fraction_part = 0L;
        int count_fraction_digits = 0;
        this.is_scanned_real = false;
        if (this.current_char == '-') {
            sign = -1;
            this.next_char();
        } else if (this.current_char == '+') {
            this.next_char();
        }
        int index = digit_characters.indexOf(this.current_char);
        if (index >= 0) {
            this.is_scanned_real = true;
        }
        while (index >= 0) {
            integer_part = 10L * integer_part + (long)index;
            index = digit_characters.indexOf(this.next_char());
        }
        if (this.current_char == '.') {
            index = digit_characters.indexOf(this.next_char());
            if (index >= 0) {
                this.is_scanned_real = true;
            }
            while (index >= 0) {
                fraction_part = 10L * fraction_part + (long)index;
                ++count_fraction_digits;
                index = digit_characters.indexOf(this.next_char());
            }
        }
        if (this.is_scanned_real) {
            this.scanned_real = count_fraction_digits == 0 ? (double)sign * (double)integer_part : (double)sign * ((double)integer_part + Math.pow(0.1, count_fraction_digits) * (double)fraction_part);
        }
    }

    void scan_token() {
        if (this.text_index < 0) {
            this.text_index = -1;
            this.next_char();
        }
        this.first_non_white_char();
        while (this.text_index < this.text.length()) {
            if (number_start.indexOf(this.current_char) >= 0) {
                double mantissa = 0.0;
                double exponent = 0.0;
                double sign = 1.0;
                boolean in_parenthesis = false;
                if (this.current_char == '-') {
                    sign = -1.0;
                    this.next_char();
                    if (this.current_char == '>') {
                        this.scanned_token_type = TOKEN_RIGHT_ARROW;
                        this.next_char();
                        return;
                    }
                    if (this.current_char == '(') {
                        in_parenthesis = true;
                        this.next_char();
                    }
                }
                this.scan_real();
                if (this.is_scanned_real) {
                    mantissa = this.scanned_real;
                    if (this.current_char == '`') {
                        this.next_char();
                        if (this.current_char == '`') {
                            this.next_char();
                        }
                        this.scan_real();
                    }
                    boolean should_have_exponent = false;
                    boolean has_exponent = false;
                    if (this.current_char == '*') {
                        should_have_exponent = true;
                        if (this.next_char() == '1') {
                            if (this.next_char() == '0' && this.next_char() == '^') {
                                has_exponent = true;
                            }
                        } else if (this.current_char == '^') {
                            has_exponent = true;
                        }
                        if (has_exponent) {
                            this.next_char();
                            this.scan_real();
                            if (this.is_scanned_real) {
                                exponent = this.scanned_real;
                            } else {
                                has_exponent = false;
                            }
                        }
                    }
                    if (!in_parenthesis || this.current_char == ')') {
                        if (in_parenthesis) {
                            this.next_char();
                        }
                        if (has_exponent || !should_have_exponent) {
                            this.scanned_number = sign * mantissa * Math.pow(10.0, exponent);
                            this.scanned_token_type = TOKEN_NUMBER;
                            return;
                        }
                    }
                }
            } else {
                if (Character.isLetterOrDigit(this.current_char) || this.current_char == '$') {
                    this.scanned_identifier_chars[0] = this.current_char;
                    int index = 1;
                    while (Character.isLetterOrDigit(this.next_char()) || this.current_char == '$') {
                        if (index >= max_length_identifier) continue;
                        this.scanned_identifier_chars[index] = this.current_char;
                        ++index;
                    }
                    this.scanned_identifier = new String(this.scanned_identifier_chars, 0, index);
                    this.scanned_token_type = TOKEN_IDENTIFIER;
                    return;
                }
                if (structure_characters.indexOf(this.current_char) >= 0) {
                    this.scanned_token_type = structure_characters.indexOf(this.current_char);
                    this.next_char();
                    return;
                }
                if (this.current_char == ':') {
                    if (this.next_char() == '>') {
                        this.scanned_token_type = TOKEN_RIGHT_ARROW;
                        this.next_char();
                        return;
                    }
                } else if (this.current_char == '\"') {
                    StringBuffer buffer = new StringBuffer(60);
                    this.next_char();
                    while (this.text_index < this.text.length() && this.current_char != '\"') {
                        if (this.current_char == '\\') {
                            this.next_char();
                            if (this.current_char == 'n') {
                                buffer.append('\n');
                            } else if (this.current_char == 'b') {
                                buffer.append('\b');
                            } else if (this.current_char == 't') {
                                buffer.append('\t');
                            } else if (this.current_char == 'r') {
                                buffer.append('\r');
                            } else if (this.current_char == 'f') {
                                buffer.append('\f');
                            } else if (single_quote_chars.indexOf(this.current_char) >= 0 || this.current_char == '\"' || this.current_char == '\\') {
                                buffer.append(this.current_char);
                                this.current_char = (char)92;
                            } else if (octal_digits.indexOf(this.current_char) >= 0 || this.current_char == '.' || this.current_char == ':') {
                                int count_digits = 3;
                                int uni_code = 0;
                                if (this.current_char == '.') {
                                    count_digits = 2;
                                    this.next_char();
                                }
                                if (this.current_char == ':') {
                                    count_digits = 4;
                                    this.next_char();
                                }
                                int digit_index = 0;
                                while (digit_index < count_digits) {
                                    int index = hexadecimal_digits.indexOf(this.current_char);
                                    if (index < 0) break;
                                    if (index >= 16) {
                                        index -= 6;
                                    }
                                    uni_code = count_digits == 3 ? uni_code * 8 + index : uni_code * 16 + index;
                                    if (digit_index + 1 < count_digits) {
                                        this.next_char();
                                    }
                                    ++digit_index;
                                }
                                byte[] ascii_codes = new byte[]{(byte)(uni_code % 256)};
                                buffer.append(new String(ascii_codes, uni_code / 256));
                                if (digit_index < count_digits) {
                                    buffer.append(this.current_char);
                                }
                            } else {
                                buffer.append('\\');
                                buffer.append(this.current_char);
                            }
                        } else if (this.current_char != '\n' && this.current_char != '\r' && this.current_char != '\t' && this.current_char != '\f') {
                            buffer.append(this.current_char);
                        }
                        this.next_char();
                    }
                    if (this.text_index < this.text.length()) {
                        this.scanned_token_type = TOKEN_STRING;
                        this.scanned_string = new String(buffer);
                        this.next_char();
                        return;
                    }
                }
            }
            this.scan_salt();
        }
        this.scanned_token_type = TOKEN_NONE;
    }

    void scan_salt() {
        int bracket_level = 0;
        while (this.text_index < this.text.length()) {
            if (this.current_char == '\"') {
                this.next_char();
                while (this.text_index < this.text.length() && this.current_char != '\"') {
                    if (this.current_char == '\\') {
                        this.next_char();
                    }
                    this.next_char();
                }
            } else if (structure_characters.indexOf(this.current_char) >= 0) {
                if (this.current_char == '(' || this.current_char == '{' || this.current_char == '[') {
                    ++bracket_level;
                } else if (this.current_char == ')' || this.current_char == '}' || this.current_char == ']' ? --bracket_level < 0 : this.current_char == ',' && bracket_level == 0) break;
            }
            this.next_char();
        }
    }

    void scan_right_bracket() {
        this.scan_salt();
        while (this.text_index < this.text.length() && this.current_char == ',') {
            this.next_char();
            this.scan_salt();
        }
        this.scan_token();
        if (TOKEN_RIGHT_BRACKET != this.scanned_token_type && TOKEN_RIGHT_PARENTHESIS != this.scanned_token_type && TOKEN_RIGHT_BRACE != this.scanned_token_type) {
            this.scanned_token_type = TOKEN_NONE;
        }
    }

    public boolean scan_animation() {
        this.text_index = -1;
        this.scanned_AnimationDisplayTime = 0.05;
        this.scanned_AnimationDirection = 1;
        this.scanned_frames = new Vector();
        this.scanning_animation_option = false;
        this.scan_token();
        if (TOKEN_IDENTIFIER != this.scanned_token_type) {
            return false;
        }
        if (this.scanned_identifier.equals(name_Graphics3D)) {
            if (!this.scan_Graphics3D()) {
                return false;
            }
            this.scanned_frames.addElement(this.graphics);
            return true;
        }
        if (this.scanned_identifier.equals(name_ShowAnimation)) {
            this.scan_token();
            if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (TOKEN_IDENTIFIER == this.scanned_token_type && this.scanned_identifier.equals(name_Graphics3D)) {
                if (!this.scan_Graphics3D()) {
                    return false;
                }
                this.scanned_frames.addElement(this.graphics);
            } else if (TOKEN_LEFT_BRACE == this.scanned_token_type) {
                this.scanned_token_type = TOKEN_COMMA;
                while (TOKEN_COMMA == this.scanned_token_type) {
                    this.scan_token();
                    if (!this.scan_Graphics3D()) {
                        return false;
                    }
                    this.scanned_frames.addElement(this.graphics);
                    this.scan_token();
                }
                if (TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                    return false;
                }
            } else {
                return false;
            }
            this.scan_token();
            this.scanning_animation_option = true;
            this.init_scan_Graphics3D();
            while (TOKEN_COMMA == this.scanned_token_type) {
                if (!this.scan_option()) {
                    return false;
                }
                this.scan_token();
            }
            if (TOKEN_RIGHT_BRACKET != this.scanned_token_type) {
                return false;
            }
            int frame_index = 0;
            while (frame_index < this.scanned_frames.size()) {
                Graphics3D frame = (Graphics3D)this.scanned_frames.elementAt(frame_index);
                if (this.is_scanned_AmbientLight) {
                    frame.option_AmbientLight = this.graphics.option_AmbientLight;
                }
                if (this.is_scanned_Axes) {
                    frame.option_Axes = this.graphics.option_Axes;
                }
                if (this.is_scanned_AxesLabel) {
                    frame.option_AxesLabel = this.graphics.option_AxesLabel;
                }
                if (this.is_scanned_AxesStyle) {
                    frame.option_AxesStyle = this.graphics.option_AxesStyle;
                }
                if (this.is_scanned_AxesEdge) {
                    frame.option_AxesEdge = this.graphics.option_AxesEdge;
                }
                if (this.is_scanned_Ticks) {
                    frame.option_Ticks = this.graphics.option_Ticks;
                }
                if (this.is_scanned_PlotLabel) {
                    frame.option_PlotLabel = this.graphics.option_PlotLabel;
                }
                if (this.is_scanned_Background) {
                    frame.option_Background = this.graphics.option_Background;
                }
                if (this.is_scanned_DefaultColor) {
                    frame.option_DefaultColor = this.graphics.option_DefaultColor;
                }
                if (this.is_scanned_BoxStyle) {
                    frame.option_BoxStyle = this.graphics.option_BoxStyle;
                }
                if (this.is_scanned_Boxed) {
                    frame.option_Boxed = this.graphics.option_Boxed;
                }
                if (this.is_scanned_Lighting) {
                    frame.option_Lighting = this.graphics.option_Lighting;
                }
                if (this.is_scanned_BoxRatios) {
                    frame.option_BoxRatios = this.graphics.option_BoxRatios;
                }
                if (this.is_scanned_PlotRange) {
                    frame.option_PlotRange = this.graphics.option_PlotRange;
                }
                if (this.is_scanned_LightSources) {
                    frame.option_LightSources_vectors = this.graphics.option_LightSources_vectors;
                    frame.option_LightSources_colors = this.graphics.option_LightSources_colors;
                }
                if (this.is_scanned_ViewPoint) {
                    frame.option_ViewPoint = this.graphics.option_ViewPoint;
                }
                if (this.is_scanned_ViewVertical) {
                    frame.option_ViewVertical = this.graphics.option_ViewVertical;
                }
                if (this.is_scanned_TextStyle) {
                    frame.option_TextStyle_font_url = this.graphics.option_TextStyle_font_url;
                    frame.option_TextStyle_font_family = this.graphics.option_TextStyle_font_family;
                    frame.option_TextStyle_font_weight = this.graphics.option_TextStyle_font_weight;
                    frame.option_TextStyle_font_slant = this.graphics.option_TextStyle_font_slant;
                    frame.option_TextStyle_font_size = this.graphics.option_TextStyle_font_size;
                    frame.option_TextStyle_font_color = this.graphics.option_TextStyle_font_color;
                    frame.option_TextStyle_font_background = this.graphics.option_TextStyle_font_background;
                }
                ++frame_index;
            }
            return true;
        }
        return false;
    }

    public void init_scan_Graphics3D() {
        this.graphics = new Graphics3D();
        this.scanning_EdgeForm = false;
        this.scanning_FaceForm = false;
        this.scanning_SurfaceColor = false;
        this.is_scanned_AmbientLight = false;
        this.is_scanned_Axes = false;
        this.is_scanned_AxesLabel = false;
        this.is_scanned_AxesStyle = false;
        this.is_scanned_AxesEdge = false;
        this.is_scanned_Ticks = false;
        this.is_scanned_PlotLabel = false;
        this.is_scanned_Background = false;
        this.is_scanned_DefaultColor = false;
        this.is_scanned_BoxStyle = false;
        this.is_scanned_Boxed = false;
        this.is_scanned_Lighting = false;
        this.is_scanned_BoxRatios = false;
        this.is_scanned_PlotRange = false;
        this.is_scanned_LightSources = false;
        this.is_scanned_ViewPoint = false;
        this.is_scanned_ViewVertical = false;
        this.is_scanned_TextStyle = false;
    }

    public boolean scan_Graphics3D() {
        this.init_scan_Graphics3D();
        Primitive3D default_primitive = new Primitive3D();
        if (TOKEN_IDENTIFIER != this.scanned_token_type || !this.scanned_identifier.equals(name_Graphics3D)) {
            return false;
        }
        this.scan_token();
        if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
            return false;
        }
        if (!this.scan_primitive(default_primitive)) {
            return false;
        }
        this.scan_token();
        while (TOKEN_COMMA == this.scanned_token_type) {
            if (!this.scan_option()) {
                return false;
            }
            this.scan_token();
        }
        return TOKEN_RIGHT_BRACKET == this.scanned_token_type;
    }

    boolean scan_primitive(Primitive3D default_primitive) {
        this.scanned_nothing = false;
        this.scanned_unidentified = false;
        this.scan_token();
        if (TOKEN_LEFT_BRACE == this.scanned_token_type) {
            if (!this.scanning_EdgeForm && !this.scanning_FaceForm || this.scanning_AxesStyles && this.recursion_depth == 1) {
                default_primitive = new Primitive3D(default_primitive);
            }
            ++this.recursion_depth;
            while (this.scan_primitive(default_primitive)) {
                this.scan_token();
                if (TOKEN_COMMA != this.scanned_token_type) break;
            }
            --this.recursion_depth;
            if (TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                return false;
            }
            if (this.scanning_AxesStyles && this.recursion_depth == 1) {
                this.scanned_AxesStyles[0] = this.scanned_AxesStyles[1];
                this.scanned_AxesStyles[1] = this.scanned_AxesStyles[2];
                this.scanned_AxesStyles[2] = default_primitive;
            }
            return true;
        }
        if (TOKEN_IDENTIFIER != this.scanned_token_type) {
            this.scanned_nothing = true;
            return false;
        }
        if (!this.scanning_EdgeForm && !this.scanning_FaceForm && !this.scanning_SurfaceColor && this.scanned_identifier.equals(name_EdgeForm)) {
            this.scan_token();
            if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                return false;
            }
            this.scanning_EdgeForm = true;
            default_primitive.is_outlined = false;
            if (this.scan_primitive(default_primitive)) {
                this.scanning_EdgeForm = false;
                this.scan_token();
                return TOKEN_RIGHT_BRACKET == this.scanned_token_type;
            }
            if (this.scanned_nothing && TOKEN_RIGHT_BRACKET == this.scanned_token_type) {
                this.scanning_EdgeForm = false;
                return true;
            }
        } else {
            if (!this.scanning_EdgeForm && !this.scanning_FaceForm && !this.scanning_SurfaceColor && this.scanned_identifier.equals(name_FaceForm)) {
                this.scan_token();
                if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                this.scanning_FaceForm = true;
                this.scanning_FaceForm_back = false;
                if (!this.scan_primitive(default_primitive)) {
                    this.scanning_FaceForm = false;
                    return false;
                }
                this.scan_token();
                if (TOKEN_COMMA == this.scanned_token_type) {
                    this.scanning_FaceForm_back = true;
                    if (!this.scan_primitive(default_primitive)) {
                        this.scanning_FaceForm = false;
                        this.scanning_FaceForm_back = false;
                        return false;
                    }
                    this.scanning_FaceForm_back = false;
                    this.scan_token();
                }
                this.scanning_FaceForm = false;
                return TOKEN_RIGHT_BRACKET == this.scanned_token_type;
            }
            if (!this.scanning_EdgeForm && !this.scanning_SurfaceColor && this.scanned_identifier.equals(name_SurfaceColor)) {
                this.scan_token();
                if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                this.scanning_SurfaceColor = true;
                this.scanning_SurfaceColor_specular = false;
                if (!this.scan_primitive(default_primitive)) {
                    this.scanning_SurfaceColor = false;
                    return false;
                }
                this.scan_token();
                if (TOKEN_COMMA == this.scanned_token_type) {
                    this.scanning_SurfaceColor_specular = true;
                    if (!this.scan_primitive(default_primitive)) {
                        this.scanning_SurfaceColor = false;
                        this.scanning_SurfaceColor_specular = false;
                        return false;
                    }
                    this.scanning_SurfaceColor = false;
                    this.scanning_SurfaceColor_specular = false;
                    this.scan_token();
                    if (TOKEN_COMMA == this.scanned_token_type) {
                        this.scan_token();
                        if (TOKEN_NUMBER != this.scanned_token_type) {
                            return false;
                        }
                        if (!this.scanning_FaceForm_back) {
                            default_primitive.front_specular_exponent = this.scanned_number;
                        }
                        default_primitive.back_specular_exponent = this.scanned_number;
                        this.scan_token();
                    }
                }
                this.scanning_SurfaceColor = false;
                return TOKEN_RIGHT_BRACKET == this.scanned_token_type;
            }
        }
        if (!this.scan_color()) {
            return false;
        }
        if (this.scanned_color != null) {
            if (this.scanning_SurfaceColor && !this.scanning_SurfaceColor_specular) {
                if (!this.scanning_FaceForm_back) {
                    default_primitive.front_diffuse_color = this.scanned_color;
                }
                default_primitive.back_diffuse_color = this.scanned_color;
            } else if (this.scanning_SurfaceColor && this.scanning_SurfaceColor_specular) {
                if (!this.scanning_FaceForm_back) {
                    default_primitive.front_specular_color = this.scanned_color;
                }
                default_primitive.back_specular_color = this.scanned_color;
            } else if (this.scanning_FaceForm) {
                if (!this.scanning_FaceForm_back) {
                    default_primitive.front_face_color = this.scanned_color;
                }
                default_primitive.back_face_color = this.scanned_color;
            } else if (this.scanning_EdgeForm) {
                default_primitive.edge_color = this.scanned_color;
                default_primitive.is_outlined = true;
            } else {
                default_primitive.standard_color = this.scanned_color;
                default_primitive.front_face_color = this.scanned_color;
                default_primitive.back_face_color = this.scanned_color;
            }
            return true;
        }
        if (!(this.scanning_SurfaceColor || this.scanning_EdgeForm || this.scanning_FaceForm)) {
            if (this.scanned_identifier.equals(name_PointSize)) {
                if (!this.scan_numbers(false, false) || this.count_scanned_numbers != 1) {
                    return false;
                }
                default_primitive.original_point_size = this.scanned_numbers[0];
                default_primitive.is_absolute_point_size = false;
                return true;
            }
            if (this.scanned_identifier.equals(name_AbsolutePointSize)) {
                if (!this.scan_numbers(false, false) || this.count_scanned_numbers != 1) {
                    return false;
                }
                default_primitive.original_point_size = this.scanned_numbers[0];
                default_primitive.is_absolute_point_size = true;
                return true;
            }
        }
        if (!this.scanning_SurfaceColor && !this.scanning_FaceForm) {
            if (this.scanned_identifier.equals(name_Thickness)) {
                if (!this.scan_numbers(false, false) || this.count_scanned_numbers != 1) {
                    return false;
                }
                if (this.scanning_EdgeForm) {
                    default_primitive.is_outlined = true;
                    default_primitive.original_edge_thickness = this.scanned_numbers[0];
                    default_primitive.is_absolute_edge_thickness = false;
                } else {
                    default_primitive.original_thickness = this.scanned_numbers[0];
                    default_primitive.is_absolute_thickness = false;
                }
                return true;
            }
            if (this.scanned_identifier.equals(name_AbsoluteThickness)) {
                if (!this.scan_numbers(false, false) || this.count_scanned_numbers != 1) {
                    return false;
                }
                if (this.scanning_EdgeForm) {
                    default_primitive.is_outlined = true;
                    default_primitive.original_edge_thickness = this.scanned_numbers[0];
                    default_primitive.is_absolute_edge_thickness = true;
                } else {
                    default_primitive.original_thickness = this.scanned_numbers[0];
                    default_primitive.is_absolute_thickness = true;
                }
                return true;
            }
        }
        if (!(this.scanning_EdgeForm || this.scanning_FaceForm || this.scanning_SurfaceColor)) {
            if (this.scanned_identifier.equals(name_Point)) {
                this.scan_token();
                if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_points() || this.count_scanned_points != 1) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_RIGHT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                Primitive3D primitive = new Primitive3D(default_primitive);
                primitive.count_points = 1;
                primitive.original_points = this.scanned_points;
                primitive.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive.is_filled = false;
                primitive.is_outlined = false;
                this.graphics.addPrimitive(primitive);
                return true;
            }
            if (this.scanned_identifier.equals(name_Line)) {
                this.scan_token();
                if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_points()) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_RIGHT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                Primitive3D primitive = new Primitive3D(default_primitive);
                primitive.count_points = this.count_scanned_points;
                primitive.original_points = this.scanned_points;
                primitive.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive.is_filled = false;
                primitive.is_outlined = false;
                this.graphics.addPrimitive(primitive);
                return true;
            }
            if (this.scanned_identifier.equals(name_Polygon)) {
                this.scan_token();
                if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_points()) {
                    return false;
                }
                this.scan_right_bracket();
                if (TOKEN_RIGHT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                Primitive3D primitive = new Primitive3D(default_primitive);
                primitive.count_points = this.count_scanned_points;
                primitive.original_points = this.scanned_points;
                primitive.original_scaled_offsets = this.scanned_scaled_offsets;
                primitive.is_filled = true;
                this.graphics.addPrimitive(primitive);
                return true;
            }
            if (this.scanned_identifier.equals(name_Cuboid)) {
                double[] max_scaled_offset;
                double[] max_point;
                int[][] nArrayArray = new int[6][];
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[2] = 3;
                nArray[3] = 2;
                nArrayArray[0] = nArray;
                int[] nArray2 = new int[4];
                nArray2[1] = 4;
                nArray2[2] = 5;
                nArray2[3] = 1;
                nArrayArray[1] = nArray2;
                int[] nArray3 = new int[4];
                nArray3[1] = 2;
                nArray3[2] = 6;
                nArray3[3] = 4;
                nArrayArray[2] = nArray3;
                nArrayArray[3] = new int[]{7, 6, 4, 5};
                nArrayArray[4] = new int[]{7, 3, 2, 6};
                nArrayArray[5] = new int[]{7, 5, 1, 3};
                int[][] cuboid_codes = nArrayArray;
                this.scan_token();
                if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_points() || this.count_scanned_points != 1) {
                    return false;
                }
                double[] min_point = this.scanned_points[0];
                double[] min_scaled_offset = this.scanned_scaled_offsets[0];
                this.scan_token();
                if (TOKEN_RIGHT_BRACKET == this.scanned_token_type) {
                    if (min_point != null) {
                        max_point = new double[]{min_point[0] + 1.0, min_point[1] + 1.0, min_point[2] + 1.0};
                        max_scaled_offset = min_scaled_offset;
                    } else {
                        max_point = null;
                        max_scaled_offset = null;
                    }
                } else if (TOKEN_COMMA == this.scanned_token_type) {
                    if (!this.scan_points() || this.count_scanned_points != 1) {
                        return false;
                    }
                    this.scan_token();
                    if (TOKEN_RIGHT_BRACKET != this.scanned_token_type) {
                        return false;
                    }
                    max_point = this.scanned_points[0];
                    max_scaled_offset = this.scanned_scaled_offsets[0];
                } else {
                    return false;
                }
                if (min_point != null && max_point != null || min_point == null && max_point == null && max_scaled_offset != null) {
                    int face_index = 0;
                    while (face_index < 6) {
                        Primitive3D primitive = new Primitive3D(default_primitive);
                        primitive.count_points = 4;
                        primitive.original_points = new double[4][3];
                        primitive.original_scaled_offsets = new double[4][3];
                        primitive.is_filled = true;
                        int corner_index = 0;
                        while (corner_index < 4) {
                            int axes_index = 0;
                            while (axes_index < 3) {
                                if ((cuboid_codes[face_index][corner_index] & 1 << axes_index) != 0) {
                                    if (max_point != null) {
                                        primitive.original_points[corner_index][axes_index] = max_point[axes_index];
                                    } else {
                                        primitive.original_points[corner_index] = null;
                                    }
                                    primitive.original_scaled_offsets[corner_index][axes_index] = max_scaled_offset[axes_index];
                                } else {
                                    if (min_point != null) {
                                        primitive.original_points[corner_index][axes_index] = min_point[axes_index];
                                    } else {
                                        primitive.original_points[corner_index] = null;
                                    }
                                    primitive.original_scaled_offsets[corner_index][axes_index] = min_scaled_offset[axes_index];
                                }
                                ++axes_index;
                            }
                            ++corner_index;
                        }
                        this.graphics.addPrimitive(primitive);
                        ++face_index;
                    }
                }
                return true;
            }
            if (this.scanned_identifier.equals(name_Text)) {
                Primitive3D primitive = new Primitive3D(default_primitive);
                this.scan_token();
                if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (!this.scan_text(primitive, true)) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_COMMA != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_points() || this.count_scanned_points != 1) {
                    return false;
                }
                primitive.count_points = 1;
                primitive.original_points = this.scanned_points;
                primitive.original_scaled_offsets = this.scanned_scaled_offsets;
                this.scan_token();
                double x_offset = 0.0;
                double y_offset = 0.0;
                if (TOKEN_COMMA == this.scanned_token_type) {
                    if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 2) {
                        return false;
                    }
                    x_offset = this.scanned_numbers[0];
                    y_offset = this.scanned_numbers[1];
                    this.scan_right_bracket();
                }
                if (TOKEN_RIGHT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                primitive.original_point_size = x_offset;
                primitive.original_thickness = y_offset;
                this.graphics.addPrimitive(primitive);
                return true;
            }
        }
        this.scan_salt();
        if (this.current_char == ',' || this.current_char == '}' || this.current_char == ']') {
            this.scanned_unidentified = true;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean scan_numbers(boolean chop, boolean brace) {
        index = 0;
        this.scan_token();
        if ((brace || Parser.TOKEN_LEFT_BRACKET == this.scanned_token_type) && (!brace || Parser.TOKEN_LEFT_BRACE == this.scanned_token_type)) ** GOTO lbl17
        return false;
lbl-1000:
        // 1 sources

        {
            this.scan_token();
            if (Parser.TOKEN_NUMBER != this.scanned_token_type) break;
            this.scanned_numbers[index] = this.scanned_number;
            if (chop) {
                if (this.scanned_number > 0.9999) {
                    this.scanned_numbers[index] = 0.9999;
                } else if (this.scanned_number < 1.0E-4) {
                    this.scanned_numbers[index] = 1.0E-4;
                }
            }
            ++index;
            this.scan_token();
            if (Parser.TOKEN_COMMA != this.scanned_token_type) break;
lbl17:
            // 2 sources

            ** while (index < Parser.max_count_scanned_numbers)
        }
lbl18:
        // 3 sources

        this.count_scanned_numbers = index;
        if ((!brace && Parser.TOKEN_RIGHT_BRACKET != this.scanned_token_type || brace && Parser.TOKEN_RIGHT_BRACE != this.scanned_token_type) && index >= Parser.max_count_scanned_numbers) {
            this.scan_right_bracket();
        }
        return (brace != false || Parser.TOKEN_RIGHT_BRACKET == this.scanned_token_type) && (brace == false || Parser.TOKEN_RIGHT_BRACE == this.scanned_token_type);
    }

    boolean scan_points() {
        boolean is_list = false;
        boolean scanned_brace = false;
        int point_index = 0;
        double[] point = new double[3];
        double[] scaled_offset = new double[3];
        this.max_count_scanned_points = 2;
        this.scanned_points = new double[this.max_count_scanned_points][3];
        this.scanned_scaled_offsets = new double[this.max_count_scanned_points][3];
        while (point_index == 0 || is_list && TOKEN_COMMA == this.scanned_token_type) {
            this.scan_token();
            if (TOKEN_LEFT_BRACE == this.scanned_token_type) {
                this.scan_token();
                if (point_index == 0) {
                    if (TOKEN_LEFT_BRACE == this.scanned_token_type) {
                        is_list = true;
                        this.scan_token();
                    } else if (TOKEN_NUMBER != this.scanned_token_type) {
                        is_list = true;
                    }
                }
            }
            if (TOKEN_NUMBER == this.scanned_token_type) {
                int index = 0;
                while (index < 3 && TOKEN_NUMBER == this.scanned_token_type) {
                    point[index] = this.scanned_number;
                    this.scan_token();
                    if (TOKEN_COMMA != this.scanned_token_type) break;
                    this.scan_token();
                    ++index;
                }
                if (index < 2 || TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                    return false;
                }
                this.add_point(point, scaled_offset, point_index);
            } else if (TOKEN_IDENTIFIER == this.scanned_token_type && this.scanned_identifier.equals(name_Scaled)) {
                this.scan_token();
                if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 3) {
                    return false;
                }
                scaled_offset[0] = this.scanned_numbers[0];
                scaled_offset[1] = this.scanned_numbers[1];
                scaled_offset[2] = this.scanned_numbers[2];
                this.scan_token();
                if (TOKEN_COMMA == this.scanned_token_type) {
                    if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 3) {
                        return false;
                    }
                    point[0] = this.scanned_numbers[0];
                    point[1] = this.scanned_numbers[1];
                    point[2] = this.scanned_numbers[2];
                    this.scan_token();
                    if (TOKEN_RIGHT_BRACKET != this.scanned_token_type) {
                        return false;
                    }
                    this.add_point(point, scaled_offset, point_index);
                } else {
                    if (TOKEN_RIGHT_BRACKET != this.scanned_token_type) {
                        return false;
                    }
                    this.add_point(null, scaled_offset, point_index);
                }
            } else {
                return false;
            }
            if (is_list) {
                this.scan_token();
            }
            ++point_index;
        }
        if (TOKEN_RIGHT_BRACE != this.scanned_token_type && TOKEN_RIGHT_BRACKET != this.scanned_token_type) {
            return false;
        }
        this.count_scanned_points = point_index;
        return true;
    }

    void add_point(double[] point, double[] scaled_offset, int index) {
        int axes_index;
        if (index >= this.max_count_scanned_points) {
            int new_max_count_points = 2 * this.max_count_scanned_points;
            double[][] new_points = new double[new_max_count_points][3];
            double[][] new_scaled_offsets = new double[new_max_count_points][3];
            int point_index = 0;
            while (point_index < this.max_count_scanned_points) {
                axes_index = 0;
                while (axes_index < 3) {
                    new_scaled_offsets[point_index][axes_index] = this.scanned_scaled_offsets[point_index][axes_index];
                    ++axes_index;
                }
                if (this.scanned_points[point_index] != null) {
                    axes_index = 0;
                    while (axes_index < 3) {
                        new_points[point_index][axes_index] = this.scanned_points[point_index][axes_index];
                        ++axes_index;
                    }
                } else {
                    new_points[point_index] = this.scanned_points[point_index];
                }
                ++point_index;
            }
            this.scanned_points = new_points;
            this.scanned_scaled_offsets = new_scaled_offsets;
            this.max_count_scanned_points = new_max_count_points;
        }
        axes_index = 0;
        while (axes_index < 3) {
            this.scanned_scaled_offsets[index][axes_index] = scaled_offset[axes_index];
            ++axes_index;
        }
        if (point != null) {
            axes_index = 0;
            while (axes_index < 3) {
                this.scanned_points[index][axes_index] = point[axes_index];
                ++axes_index;
            }
        } else {
            this.scanned_points[index] = point;
        }
    }

    boolean scan_color() {
        this.scanned_color = null;
        if (this.scanned_identifier.equals(name_RGBColor)) {
            if (!this.scan_numbers(true, false) || this.count_scanned_numbers != 3) {
                return false;
            }
            this.scanned_color = new Color((float)this.scanned_numbers[0], (float)this.scanned_numbers[1], (float)this.scanned_numbers[2]);
        } else if (this.scanned_identifier.equals(name_Hue)) {
            if (!this.scan_numbers(false, false)) {
                return false;
            }
            if (this.count_scanned_numbers == 1) {
                this.scanned_numbers[1] = 1.0;
                this.count_scanned_numbers = 2;
            }
            if (this.count_scanned_numbers == 2) {
                this.scanned_numbers[2] = 1.0;
                this.count_scanned_numbers = 3;
            }
            if (this.count_scanned_numbers != 3) {
                return false;
            }
            this.scanned_numbers[0] = this.scanned_numbers[0] - Math.floor(this.scanned_numbers[0]);
            int index = 0;
            while (index < 3) {
                if (this.scanned_numbers[index] > 0.9999) {
                    this.scanned_numbers[index] = 0.9999;
                }
                if (this.scanned_numbers[index] < 1.0E-4) {
                    this.scanned_numbers[index] = 1.0E-4;
                }
                ++index;
            }
            this.scanned_color = Color.getHSBColor((float)this.scanned_numbers[0], (float)this.scanned_numbers[1], (float)this.scanned_numbers[2]);
        } else if (this.scanned_identifier.equals(name_GrayLevel)) {
            if (!this.scan_numbers(true, false) || this.count_scanned_numbers != 1) {
                return false;
            }
            this.scanned_color = new Color((float)this.scanned_numbers[0], (float)this.scanned_numbers[0], (float)this.scanned_numbers[0]);
        } else if (this.scanned_identifier.equals(name_CMYKColor)) {
            if (!this.scan_numbers(true, false) || this.count_scanned_numbers != 4) {
                return false;
            }
            this.scanned_color = new Color((float)Math.max(0.0, 1.0 - this.scanned_numbers[0] - this.scanned_numbers[3]), (float)Math.max(0.0, 1.0 - this.scanned_numbers[1] - this.scanned_numbers[3]), (float)Math.max(0.0, 1.0 - this.scanned_numbers[2] - this.scanned_numbers[3]));
        }
        return true;
    }

    public boolean scan_text(Primitive3D primitive, boolean salt_follows) {
        primitive.text = name_Questionmark;
        primitive.front_face_color = null;
        primitive.back_face_color = null;
        primitive.is_filled = false;
        if (TOKEN_NUMBER == this.scanned_token_type) {
            primitive.text = String.valueOf(this.scanned_number);
        } else if (TOKEN_STRING == this.scanned_token_type) {
            primitive.text = this.scanned_string;
        } else if (TOKEN_IDENTIFIER == this.scanned_token_type) {
            if (!this.scanned_identifier.equals(name_StyleForm)) {
                primitive.text = this.scanned_identifier;
            } else {
                this.scan_token();
                if (TOKEN_LEFT_BRACKET != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_NUMBER == this.scanned_token_type) {
                    primitive.text = String.valueOf(this.scanned_number);
                } else if (TOKEN_STRING == this.scanned_token_type) {
                    primitive.text = this.scanned_string;
                } else if (TOKEN_IDENTIFIER == this.scanned_token_type) {
                    primitive.text = this.scanned_identifier;
                }
                this.scan_salt();
                this.scan_token();
                if (TOKEN_RIGHT_BRACKET == this.scanned_token_type) {
                    primitive.font_url = null;
                    primitive.font = null;
                    primitive.font_weight = -1;
                    primitive.font_slant = -1;
                    primitive.font_size = -1;
                    primitive.front_face_color = null;
                    primitive.back_face_color = null;
                } else {
                    if (TOKEN_COMMA != this.scanned_token_type) {
                        return false;
                    }
                    if (!this.scan_font_options() || TOKEN_RIGHT_BRACKET != this.scanned_token_type) {
                        return false;
                    }
                    primitive.font_url = this.scanned_font_url;
                    primitive.font = this.scanned_font_family;
                    primitive.font_weight = this.scanned_font_weight;
                    primitive.font_slant = this.scanned_font_slant;
                    primitive.font_size = this.scanned_font_size;
                    primitive.front_face_color = this.scanned_font_color;
                    primitive.back_face_color = this.scanned_font_background;
                }
            }
        }
        if (salt_follows) {
            this.scan_salt();
        }
        return true;
    }

    boolean scan_font_options() {
        this.scanned_font_url = null;
        this.scanned_font_family = null;
        this.scanned_font_weight = -1;
        this.scanned_font_slant = -1;
        this.scanned_font_size = -1;
        this.scanned_font_color = null;
        this.scanned_font_background = null;
        this.scan_token();
        while (TOKEN_IDENTIFIER == this.scanned_token_type) {
            if (this.scanned_identifier.equals(name_URL)) {
                this.scan_token();
                if (TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_STRING != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_url = this.scanned_string;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontFamily)) {
                this.scan_token();
                if (TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_STRING != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_family = this.scanned_string;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontWeight)) {
                this.scan_token();
                if (TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_STRING != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_weight = this.scanned_string.equals(name_Bold) ? 1 : 0;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontSlant)) {
                this.scan_token();
                if (TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_STRING != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_slant = this.scanned_string.equals(name_Italic) ? 2 : 0;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontSize)) {
                this.scan_token();
                if (TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_NUMBER != this.scanned_token_type) {
                    return false;
                }
                this.scanned_font_size = (int)this.scanned_number;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_FontColor)) {
                this.scan_token();
                if (TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_IDENTIFIER != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_color()) {
                    return false;
                }
                this.scanned_font_color = this.scanned_color;
                this.scan_token();
            } else if (this.scanned_identifier.equals(name_Background)) {
                this.scan_token();
                if (TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
                if (TOKEN_IDENTIFIER != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_color()) {
                    return false;
                }
                this.scanned_font_background = this.scanned_color;
                this.scan_token();
            } else {
                this.scan_salt();
                this.scan_token();
            }
            if (TOKEN_COMMA != this.scanned_token_type) break;
            this.scan_token();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    boolean scan_option() {
        block152: {
            block154: {
                block153: {
                    this.scanned_nothing = false;
                    this.scanning_FaceForm_back = false;
                    this.scan_token();
                    if (Parser.TOKEN_LEFT_BRACE == this.scanned_token_type) {
                        while (this.scan_option()) {
                            this.scan_token();
                            if (Parser.TOKEN_COMMA != this.scanned_token_type) break;
                        }
                        return Parser.TOKEN_RIGHT_BRACE == this.scanned_token_type;
                    }
                    if (Parser.TOKEN_IDENTIFIER != this.scanned_token_type) {
                        this.scanned_nothing = true;
                        return false;
                    }
                    if (!this.is_scanned_AmbientLight && this.scanned_identifier.equals(Parser.name_AmbientLight)) {
                        this.is_scanned_AmbientLight = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        primitive = new Primitive3D();
                        this.scanning_FaceForm = true;
                        if (!this.scan_primitive(primitive)) {
                            this.scanning_FaceForm = false;
                            return false;
                        }
                        this.graphics.option_AmbientLight = primitive.front_face_color;
                        this.scanning_FaceForm = false;
                        return true;
                    }
                    if (!this.is_scanned_Axes && this.scanned_identifier.equals(Parser.name_Axes)) {
                        this.is_scanned_Axes = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        this.scan_token();
                        if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type) {
                            if (this.scanned_identifier.equals(Parser.name_True)) {
                                this.graphics.option_Axes[0] = true;
                                this.graphics.option_Axes[1] = true;
                                this.graphics.option_Axes[2] = true;
                            }
                            return true;
                        }
                        if (Parser.TOKEN_LEFT_BRACE == this.scanned_token_type) {
                            index = 0;
                            this.scanned_token_type = Parser.TOKEN_COMMA;
                            while (index < 3 && Parser.TOKEN_COMMA == this.scanned_token_type) {
                                this.scan_token();
                                if (Parser.TOKEN_IDENTIFIER != this.scanned_token_type) continue;
                                if (this.scanned_identifier.equals(Parser.name_True)) {
                                    this.graphics.option_Axes[index] = true;
                                }
                                ++index;
                                this.scan_token();
                            }
                            if (Parser.TOKEN_RIGHT_BRACE == this.scanned_token_type) {
                                return true;
                            }
                        }
                        return false;
                    }
                    if (!this.is_scanned_AxesLabel && this.scanned_identifier.equals(Parser.name_AxesLabel)) {
                        this.is_scanned_AxesLabel = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        this.scan_token();
                        index = 2;
                        is_list = false;
                        if (Parser.TOKEN_LEFT_BRACE == this.scanned_token_type) {
                            index = 0;
                            is_list = true;
                            this.scan_token();
                        } else if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type && this.scanned_identifier.equals(Parser.name_None)) {
                            return true;
                        }
                        do {
                            if (index > 0 && is_list) {
                                this.scan_token();
                            }
                            if (index > 2) {
                                return false;
                            }
                            if (Parser.TOKEN_IDENTIFIER != this.scanned_token_type || !this.scanned_identifier.equals(Parser.name_None)) {
                                this.graphics.option_AxesLabel[index] = primitive = new Primitive3D();
                                if (!this.scan_text(primitive, false)) {
                                    return false;
                                }
                            }
                            if (!is_list) continue;
                            ++index;
                            this.scan_token();
                        } while (is_list && Parser.TOKEN_COMMA == this.scanned_token_type);
                        return is_list == false || Parser.TOKEN_RIGHT_BRACE == this.scanned_token_type;
                    }
                    if (!this.is_scanned_AxesStyle && this.scanned_identifier.equals(Parser.name_AxesStyle)) {
                        this.is_scanned_AxesStyle = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        primitive = new Primitive3D();
                        this.scanning_EdgeForm = true;
                        this.scanning_AxesStyles = true;
                        this.scanned_AxesStyles[0] = null;
                        this.scanned_AxesStyles[1] = null;
                        this.scanned_AxesStyles[2] = null;
                        if (!this.scan_primitive(primitive)) {
                            this.scanning_EdgeForm = false;
                            this.scanning_AxesStyles = false;
                            return false;
                        }
                        this.scanning_EdgeForm = false;
                        this.scanning_AxesStyles = false;
                        if (this.scanned_AxesStyles[2] == null) {
                            this.scanned_AxesStyles[0] = primitive;
                            this.scanned_AxesStyles[1] = primitive;
                            this.scanned_AxesStyles[2] = primitive;
                        }
                        index = 0;
                        while (index < 3) {
                            primitive = this.scanned_AxesStyles[index];
                            if (primitive != null) {
                                primitive.original_thickness = primitive.original_edge_thickness;
                                primitive.is_absolute_thickness = primitive.is_absolute_edge_thickness;
                                primitive.standard_color = primitive.edge_color;
                            }
                            this.graphics.option_AxesStyle[index] = primitive;
                            ++index;
                        }
                        return true;
                    }
                    if (!this.is_scanned_AxesEdge && this.scanned_identifier.equals(Parser.name_AxesEdge)) {
                        this.is_scanned_AxesEdge = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        this.scan_token();
                        if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type) {
                            if (!this.scanned_identifier.equals(Parser.name_Automatic)) {
                                this.graphics.option_AxesEdge[0] = -2;
                                this.graphics.option_AxesEdge[1] = -2;
                                this.graphics.option_AxesEdge[2] = -2;
                            }
                            return true;
                        }
                        if (Parser.TOKEN_LEFT_BRACE != this.scanned_token_type) {
                            return false;
                        }
                        index = 0;
                        do {
                            this.scan_token();
                            if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type) {
                                if (!this.scanned_identifier.equals(Parser.name_Automatic)) {
                                    this.graphics.option_AxesEdge[index] = -2;
                                }
                            } else if (Parser.TOKEN_LEFT_BRACE == this.scanned_token_type) {
                                this.scan_token();
                                if (Parser.TOKEN_NUMBER != this.scanned_token_type) {
                                    return false;
                                }
                                edge_code = 0;
                                if (this.scanned_number > 0.0) {
                                    edge_code = 1;
                                }
                                this.scan_token();
                                if (Parser.TOKEN_COMMA != this.scanned_token_type) {
                                    return false;
                                }
                                this.scan_token();
                                if (Parser.TOKEN_NUMBER != this.scanned_token_type) {
                                    return false;
                                }
                                if (this.scanned_number > 0.0) {
                                    edge_code += 2;
                                }
                                this.scan_token();
                                if (Parser.TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                                    return false;
                                }
                                this.graphics.option_AxesEdge[index] = edge_code;
                            } else {
                                return false;
                            }
                            this.scan_token();
                        } while (++index < 3 && Parser.TOKEN_COMMA == this.scanned_token_type);
                        return Parser.TOKEN_RIGHT_BRACE == this.scanned_token_type;
                    }
                    if (!this.is_scanned_Ticks && this.scanned_identifier.equals(Parser.name_Ticks)) {
                        this.is_scanned_Ticks = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        this.scan_token();
                        if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type) {
                            if (this.scanned_identifier.equals(Parser.name_None)) {
                                this.graphics.option_Ticks = new Vector[3];
                                return true;
                            }
                            if (this.scanned_identifier.equals(Parser.name_Automatic)) {
                                this.graphics.option_Ticks = new Vector[3];
                                index = 0;
                                while (index < 3) {
                                    this.graphics.option_Ticks[index] = new Vector<E>();
                                    ++index;
                                }
                                return true;
                            }
                            return false;
                        }
                        if (Parser.TOKEN_LEFT_BRACE == this.scanned_token_type) {
                            this.graphics.option_Ticks = new Vector[3];
                            index = 0;
                            while (index < 3) {
                                this.graphics.option_Ticks[index] = null;
                                ++index;
                            }
                            axis_index = 0;
                            this.scanned_token_type = Parser.TOKEN_COMMA;
                            while (Parser.TOKEN_COMMA == this.scanned_token_type) {
                                this.scan_token();
                                if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type) {
                                    if (this.scanned_identifier.equals(Parser.name_Automatic)) {
                                        this.graphics.option_Ticks[axis_index] = new Vector<E>();
                                    } else if (!this.scanned_identifier.equals(Parser.name_None)) {
                                        return false;
                                    }
                                } else {
                                    if (Parser.TOKEN_LEFT_BRACE != this.scanned_token_type) {
                                        return false;
                                    }
                                    this.graphics.option_Ticks[axis_index] = new Vector<E>();
                                    this.scanned_token_type = Parser.TOKEN_COMMA;
                                    while (Parser.TOKEN_COMMA == this.scanned_token_type) {
                                        primitive = new Primitive3D();
                                        primitive.front_specular_exponent = 0.01;
                                        primitive.back_specular_exponent = 0.0;
                                        this.scan_token();
                                        if (Parser.TOKEN_NUMBER == this.scanned_token_type) {
                                            primitive.original_point_size = this.scanned_number;
                                            primitive.text = Double.toString(this.scanned_number);
                                        } else if (Parser.TOKEN_LEFT_BRACE == this.scanned_token_type) {
                                            this.scan_token();
                                            if (Parser.TOKEN_NUMBER != this.scanned_token_type) {
                                                return false;
                                            }
                                            tick_mark_position = this.scanned_number;
                                            this.scan_token();
                                            if (Parser.TOKEN_COMMA == this.scanned_token_type) {
                                                this.scan_token();
                                                if (!this.scan_text(primitive, false)) {
                                                    return false;
                                                }
                                                this.scan_token();
                                                if (Parser.TOKEN_COMMA == this.scanned_token_type) {
                                                    this.scan_token();
                                                    if (Parser.TOKEN_NUMBER == this.scanned_token_type) {
                                                        primitive.front_specular_exponent = this.scanned_number / 2.0;
                                                        primitive.back_specular_exponent = this.scanned_number / 2.0;
                                                    } else if (Parser.TOKEN_LEFT_BRACE == this.scanned_token_type) {
                                                        this.scan_token();
                                                        if (Parser.TOKEN_NUMBER != this.scanned_token_type) {
                                                            return false;
                                                        }
                                                        primitive.front_specular_exponent = this.scanned_number;
                                                        this.scan_token();
                                                        if (Parser.TOKEN_COMMA != this.scanned_token_type) {
                                                            return false;
                                                        }
                                                        this.scan_token();
                                                        if (Parser.TOKEN_NUMBER != this.scanned_token_type) {
                                                            return false;
                                                        }
                                                        primitive.back_specular_exponent = this.scanned_number;
                                                        this.scan_token();
                                                        if (Parser.TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                                                            return false;
                                                        }
                                                    } else {
                                                        return false;
                                                    }
                                                    this.scan_token();
                                                    if (Parser.TOKEN_COMMA == this.scanned_token_type) {
                                                        this.scanning_EdgeForm = true;
                                                        if (!this.scan_primitive(primitive)) {
                                                            this.scanning_EdgeForm = false;
                                                            return false;
                                                        }
                                                        primitive.original_thickness = primitive.original_edge_thickness;
                                                        primitive.is_absolute_thickness = primitive.is_absolute_edge_thickness;
                                                        primitive.standard_color = primitive.edge_color;
                                                        this.scanning_EdgeForm = false;
                                                        this.scan_token();
                                                    }
                                                }
                                            } else {
                                                primitive.text = Double.toString(tick_mark_position);
                                            }
                                            primitive.original_point_size = tick_mark_position;
                                            if (Parser.TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                        if (this.graphics.ticks_max_in_length[axis_index] < primitive.front_specular_exponent) {
                                            this.graphics.ticks_max_in_length[axis_index] = primitive.front_specular_exponent;
                                        }
                                        if (this.graphics.ticks_max_out_length[axis_index] < primitive.back_specular_exponent) {
                                            this.graphics.ticks_max_out_length[axis_index] = primitive.back_specular_exponent;
                                        }
                                        this.graphics.option_Ticks[axis_index].addElement(primitive);
                                        this.scan_token();
                                    }
                                    if (Parser.TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                                        return false;
                                    }
                                }
                                ++axis_index;
                                this.scan_token();
                            }
                            return Parser.TOKEN_RIGHT_BRACE == this.scanned_token_type;
                        }
                        return false;
                    }
                    if (!this.is_scanned_PlotLabel && this.scanned_identifier.equals(Parser.name_PlotLabel)) {
                        this.is_scanned_PlotLabel = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        this.scan_token();
                        if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type && this.scanned_identifier.equals(Parser.name_None)) {
                            return true;
                        }
                        this.graphics.option_PlotLabel = primitive = new Primitive3D();
                        return this.scan_text(primitive, false) != false;
                    }
                    if (!this.is_scanned_Background && this.scanned_identifier.equals(Parser.name_Background)) {
                        this.is_scanned_Background = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        primitive = new Primitive3D();
                        this.scanning_FaceForm = true;
                        if (!this.scan_primitive(primitive)) {
                            this.scanning_FaceForm = false;
                            return false;
                        }
                        this.graphics.option_Background = primitive.front_face_color;
                        this.scanning_FaceForm = false;
                        return true;
                    }
                    if (!this.is_scanned_DefaultColor && this.scanned_identifier.equals(Parser.name_DefaultColor)) {
                        this.is_scanned_DefaultColor = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        primitive = new Primitive3D();
                        this.scanning_FaceForm = true;
                        if (!this.scan_primitive(primitive)) {
                            this.scanning_FaceForm = false;
                            return false;
                        }
                        this.graphics.option_DefaultColor = primitive.front_face_color;
                        this.scanning_FaceForm = false;
                        return true;
                    }
                    if (!this.is_scanned_BoxStyle && this.scanned_identifier.equals(Parser.name_BoxStyle)) {
                        this.is_scanned_BoxStyle = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        primitive = new Primitive3D();
                        this.scanning_EdgeForm = true;
                        if (!this.scan_primitive(primitive)) {
                            this.scanning_EdgeForm = false;
                            return false;
                        }
                        primitive.original_thickness = primitive.original_edge_thickness;
                        primitive.is_absolute_thickness = primitive.is_absolute_edge_thickness;
                        primitive.standard_color = primitive.edge_color;
                        this.graphics.option_BoxStyle = primitive;
                        this.scanning_EdgeForm = false;
                        return true;
                    }
                    if (!this.is_scanned_Boxed && this.scanned_identifier.equals(Parser.name_Boxed)) {
                        this.is_scanned_Boxed = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        this.scan_token();
                        if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type) {
                            if (this.scanned_identifier.equals(Parser.name_False)) {
                                this.graphics.option_Boxed = false;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (!this.is_scanned_Lighting && this.scanned_identifier.equals(Parser.name_Lighting)) {
                        this.is_scanned_Lighting = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        this.scan_token();
                        if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type) {
                            if (this.scanned_identifier.equals(Parser.name_False)) {
                                this.graphics.option_Lighting = false;
                            }
                            return true;
                        }
                        return false;
                    }
                    if (!this.is_scanned_BoxRatios && this.scanned_identifier.equals(Parser.name_BoxRatios)) {
                        this.is_scanned_BoxRatios = true;
                        this.scan_token();
                        if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                            return false;
                        }
                        if (this.scan_numbers(false, true) && this.count_scanned_numbers == 3) {
                            this.graphics.option_BoxRatios = new double[3];
                            this.graphics.option_BoxRatios[0] = this.scanned_numbers[0];
                            this.graphics.option_BoxRatios[1] = this.scanned_numbers[1];
                            this.graphics.option_BoxRatios[2] = this.scanned_numbers[2];
                            return true;
                        }
                        this.scan_salt();
                        return true;
                    }
                    if (this.is_scanned_PlotRange || !this.scanned_identifier.equals(Parser.name_PlotRange)) break block152;
                    this.is_scanned_PlotRange = true;
                    this.scan_token();
                    if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                        return false;
                    }
                    this.scan_token();
                    if (Parser.TOKEN_LEFT_BRACE != this.scanned_token_type) {
                        this.scan_salt();
                        return true;
                    }
                    new_option_PlotRange = new double[][]{{-Infinity, Infinity}, {-Infinity, Infinity}, {-Infinity, Infinity}};
                    axes_index = 0;
                    is_only_z = false;
                    this.scan_token();
                    if (Parser.TOKEN_NUMBER != this.scanned_token_type) break block153;
                    axes_index = 2;
                    is_only_z = true;
                    ** GOTO lbl405
                }
                if (Parser.TOKEN_LEFT_BRACE != this.scanned_token_type) break block154;
                this.scan_token();
                ** GOTO lbl405
            }
            if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type) ** GOTO lbl405
            return false;
lbl-1000:
            // 1 sources

            {
                if (Parser.TOKEN_IDENTIFIER != this.scanned_token_type) {
                    index = 0;
                    while (index < 2) {
                        if (Parser.TOKEN_NUMBER != this.scanned_token_type) {
                            return false;
                        }
                        new_option_PlotRange[axes_index][index] = this.scanned_number;
                        this.scan_token();
                        if (index == 0) {
                            this.scan_token();
                        }
                        ++index;
                    }
                    if (Parser.TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                        return false;
                    }
                }
                if (!is_only_z) {
                    this.scan_token();
                    if (axes_index < 2) {
                        this.scan_token();
                        if (Parser.TOKEN_LEFT_BRACE == this.scanned_token_type) {
                            this.scan_token();
                        }
                    }
                }
                ++axes_index;
lbl405:
                // 4 sources

                ** while (axes_index < 3)
            }
lbl406:
            // 1 sources

            if (Parser.TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                return false;
            }
            this.graphics.option_PlotRange = new_option_PlotRange;
            return true;
        }
        if (!this.is_scanned_LightSources && this.scanned_identifier.equals(Parser.name_LightSources)) {
            this.is_scanned_LightSources = true;
            this.scan_token();
            if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (Parser.TOKEN_LEFT_BRACE != this.scanned_token_type) {
                this.scan_salt();
                return true;
            }
            this.graphics.option_LightSources_vectors = new Vector<E>();
            this.graphics.option_LightSources_colors = new Vector<E>();
            this.scanned_token_type = Parser.TOKEN_COMMA;
            while (Parser.TOKEN_COMMA == this.scanned_token_type) {
                new_light_vector = new double[3];
                this.scan_token();
                if (Parser.TOKEN_LEFT_BRACE != this.scanned_token_type) {
                    return false;
                }
                if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 3) {
                    return false;
                }
                vector_length = Math.sqrt(this.scanned_numbers[0] * this.scanned_numbers[0] + this.scanned_numbers[1] * this.scanned_numbers[1] + this.scanned_numbers[2] * this.scanned_numbers[2]);
                new_light_vector[0] = this.scanned_numbers[0] / vector_length;
                new_light_vector[1] = this.scanned_numbers[1] / vector_length;
                new_light_vector[2] = this.scanned_numbers[2] / vector_length;
                this.scan_token();
                if (Parser.TOKEN_COMMA != this.scanned_token_type) {
                    return false;
                }
                primitive = new Primitive3D();
                this.scanning_FaceForm = true;
                if (!this.scan_primitive(primitive) || primitive.front_face_color == null) {
                    this.scanning_FaceForm = false;
                    return false;
                }
                this.scanning_FaceForm = false;
                this.graphics.option_LightSources_vectors.addElement(new_light_vector);
                this.graphics.option_LightSources_colors.addElement(primitive.front_face_color);
                this.scan_token();
                if (Parser.TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                    return false;
                }
                this.scan_token();
            }
            return Parser.TOKEN_RIGHT_BRACE == this.scanned_token_type;
        }
        if (!this.is_scanned_ViewPoint && this.scanned_identifier.equals(Parser.name_ViewPoint)) {
            this.is_scanned_ViewPoint = true;
            this.scan_token();
            if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                return false;
            }
            if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 3) {
                return false;
            }
            this.graphics.option_ViewPoint = new double[3];
            this.graphics.option_ViewPoint[0] = this.scanned_numbers[0];
            this.graphics.option_ViewPoint[1] = this.scanned_numbers[1];
            this.graphics.option_ViewPoint[2] = this.scanned_numbers[2];
            return true;
        }
        if (!this.is_scanned_ViewVertical && this.scanned_identifier.equals(Parser.name_ViewVertical)) {
            this.is_scanned_ViewVertical = true;
            this.scan_token();
            if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                return false;
            }
            if (!this.scan_numbers(false, true) || this.count_scanned_numbers != 3) {
                return false;
            }
            this.graphics.option_ViewVertical = new double[3];
            this.graphics.option_ViewVertical[0] = this.scanned_numbers[0];
            this.graphics.option_ViewVertical[1] = this.scanned_numbers[1];
            this.graphics.option_ViewVertical[2] = this.scanned_numbers[2];
            return true;
        }
        if (!this.is_scanned_TextStyle && this.scanned_identifier.equals(Parser.name_TextStyle)) {
            this.is_scanned_TextStyle = true;
            this.scan_token();
            if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (Parser.TOKEN_IDENTIFIER == this.scanned_token_type) {
                return true;
            }
            if (Parser.TOKEN_LEFT_BRACE != this.scanned_token_type) {
                return false;
            }
            if (!this.scan_font_options() || Parser.TOKEN_RIGHT_BRACE != this.scanned_token_type) {
                return false;
            }
            this.graphics.option_TextStyle_font_url = this.scanned_font_url;
            this.graphics.option_TextStyle_font_family = this.scanned_font_family;
            this.graphics.option_TextStyle_font_weight = this.scanned_font_weight;
            this.graphics.option_TextStyle_font_slant = this.scanned_font_slant;
            this.graphics.option_TextStyle_font_size = this.scanned_font_size;
            this.graphics.option_TextStyle_font_color = this.scanned_font_color;
            this.graphics.option_TextStyle_font_background = this.scanned_font_background;
            return true;
        }
        if (this.scanning_animation_option && this.scanned_identifier.equals(Parser.name_AnimationDisplayTime)) {
            this.scan_token();
            if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (Parser.TOKEN_NUMBER != this.scanned_token_type) {
                return false;
            }
            this.scanned_AnimationDisplayTime = this.scanned_number;
            return true;
        }
        if (this.scanning_animation_option && this.scanned_identifier.equals(Parser.name_AnimationDirection)) {
            this.scan_token();
            if (Parser.TOKEN_RIGHT_ARROW != this.scanned_token_type) {
                return false;
            }
            this.scan_token();
            if (Parser.TOKEN_IDENTIFIER != this.scanned_token_type) {
                return false;
            }
            if (this.scanned_identifier.equals(Parser.name_Forward)) {
                this.scanned_AnimationDirection = 1;
            } else if (this.scanned_identifier.equals(Parser.name_Backward)) {
                this.scanned_AnimationDirection = -1;
            } else if (this.scanned_identifier.equals(Parser.name_ForwardBackward)) {
                this.scanned_AnimationDirection = 0;
            }
            return true;
        }
        this.scan_salt();
        return this.current_char == ',' || this.current_char == '}' || this.current_char == ']';
    }
}

