/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

class Graphics3D {
    static int count_accuracy_bits = 9;
    static int max_coordinate = 4096;
    public Color point_edge_color;
    public int full_pixel_width;
    public int full_pixel_height;
    public int pixel_width;
    public int pixel_height;
    public boolean is_stereo;
    public double stereo_distance;
    public int stereo_offset;
    public int pixel_stereo_offset;
    public double length_view_point;
    public double initial_length_view_point;
    public double magnification;
    public double initial_magnification;
    public int width;
    public int height;
    public int eye_distance;
    public Quaternion rotation;
    public Quaternion initial_rotation;
    public double[] original_sizes;
    public double[] original_center;
    public int old_pixel_width;
    public int old_pixel_height;
    public int old_width;
    public int old_height;
    public boolean old_is_stereo;
    public double old_stereo_distance;
    public int old_eye_distance;
    public Quaternion old_rotation;
    public Color option_AmbientLight;
    public boolean[] option_Axes = new boolean[3];
    public Primitive3D[] option_AxesStyle = new Primitive3D[3];
    public Primitive3D[] option_AxesLabel = new Primitive3D[3];
    public Primitive3D option_PlotLabel = null;
    public int[] option_AxesEdge = new int[]{-1, -1, -1};
    public Vector[] option_Ticks;
    public double[] ticks_max_in_length = new double[3];
    public double[] ticks_max_out_length = new double[3];
    public Color option_Background;
    public boolean option_Boxed = true;
    public double[] option_BoxRatios;
    public Primitive3D option_BoxStyle;
    public Color option_DefaultColor;
    public boolean option_Lighting = true;
    public Vector option_LightSources_vectors;
    public Vector option_LightSources_colors;
    public double[][] option_PlotRange;
    public double[] option_ViewPoint = new double[]{1.3, -2.4, 2.0};
    public double[] option_ViewVertical;
    public String option_TextStyle_font_url;
    public String option_TextStyle_font_family;
    public int option_TextStyle_font_weight;
    public int option_TextStyle_font_slant;
    public int option_TextStyle_font_size;
    public Color option_TextStyle_font_color;
    public Color option_TextStyle_font_background;
    int max_count_points;
    int count_points;
    int[] xs;
    int[] ys;
    int[] zs;
    int[] point_flags;
    public int[] left_pixel_xs;
    public int[] right_pixel_xs;
    public int[] pixel_ys;
    int[] point_scale;
    int[] temp_xs;
    int[] temp_ys;
    int[] temp_line_xs;
    int[] temp_line_ys;
    int visible_faces;
    int count_primitives;
    int min_primitive_index;
    int max_primitive_index;
    Vector primitives;
    int max_primitive_count_points;
    double[] max_original_coordinates;
    double[] min_original_coordinates;
    int count_ordered_primitives;
    int[] order;
    int[] rotated_center_zs;

    public void setGlobalParameters(int full_pixel_width, int full_pixel_height, Color background, Color new_point_edge_color) {
        this.point_edge_color = new_point_edge_color;
        if (this.option_Background == null) {
            this.option_Background = background;
        }
        this.full_pixel_width = full_pixel_width;
        this.full_pixel_height = full_pixel_height;
    }

    public Graphics3D() {
        double[] dArray = new double[3];
        dArray[2] = 1.0;
        this.option_ViewVertical = dArray;
        this.option_TextStyle_font_weight = -1;
        this.option_TextStyle_font_slant = -1;
        this.option_TextStyle_font_size = -1;
        this.point_edge_color = null;
        this.option_Background = null;
        this.full_pixel_width = 0;
        this.full_pixel_height = 0;
        this.pixel_width = 0;
        this.pixel_height = 0;
        this.is_stereo = false;
        this.stereo_distance = 0.0;
        this.primitives = new Vector();
        this.count_primitives = 0;
        this.min_primitive_index = 0;
        this.max_primitive_index = 0;
        this.visible_faces = 3;
        this.rotation = new Quaternion(1.0, 0.0, 0.0, 0.0);
        this.width = 1000;
        this.height = 1000;
        this.eye_distance = 8000;
        this.length_view_point = 3.38378;
        this.initial_length_view_point = 3.38378;
        this.magnification = 1.0;
        this.initial_magnification = 1.0;
        this.original_sizes = new double[3];
        this.original_center = new double[3];
        this.old_rotation = new Quaternion(0.0, 0.0, 0.0, 0.0);
        double[][] dArrayArray = new double[4][];
        double[] dArray2 = new double[3];
        dArray2[0] = 0.707107;
        dArray2[2] = 0.707107;
        dArrayArray[0] = dArray2;
        dArrayArray[1] = new double[]{0.57735, 0.57735, 0.57735};
        double[] dArray3 = new double[3];
        dArray3[1] = 0.707107;
        dArray3[2] = 0.707107;
        dArrayArray[2] = dArray3;
        dArrayArray[3] = new double[]{-0.408248, -0.408248, -0.816497};
        double[][] vectors = dArrayArray;
        this.option_LightSources_vectors = new Vector();
        this.option_LightSources_vectors.addElement(vectors[0]);
        this.option_LightSources_vectors.addElement(vectors[1]);
        this.option_LightSources_vectors.addElement(vectors[2]);
        this.option_LightSources_vectors.addElement(vectors[3]);
        this.option_LightSources_colors = new Vector();
        this.option_LightSources_colors.addElement(new Color(1.0f, 0.0f, 0.0f));
        this.option_LightSources_colors.addElement(new Color(0.0f, 1.0f, 0.0f));
        this.option_LightSources_colors.addElement(new Color(0.0f, 0.0f, 1.0f));
        this.option_LightSources_colors.addElement(new Color(1.0f, 1.0f, 1.0f));
    }

    public Quaternion getQuaternion() {
        return this.rotation;
    }

    public void setQuaternion(Quaternion q) {
        this.rotation = q;
    }

    public void multiplyQuaternion(Quaternion q) {
        this.rotation = q.product(this.rotation);
        this.rotation.normalize();
    }

    public void projectPoints(boolean force_new_calculation) {
        int denominator;
        int rotated_z;
        int rotated_y;
        int rotated_x;
        int index;
        if (!force_new_calculation && this.old_rotation.equals(this.rotation) && this.old_eye_distance == this.eye_distance && this.old_pixel_width == this.pixel_width && this.old_pixel_height == this.pixel_height && this.old_width == this.width && this.old_height == this.height && this.old_is_stereo == this.is_stereo && this.old_stereo_distance == this.stereo_distance) {
            return;
        }
        this.old_rotation.s = this.rotation.s;
        this.old_rotation.x = this.rotation.x;
        this.old_rotation.y = this.rotation.y;
        this.old_rotation.z = this.rotation.z;
        this.old_eye_distance = this.eye_distance;
        this.old_pixel_width = this.pixel_width;
        this.old_pixel_height = this.pixel_height;
        this.old_width = this.width;
        this.old_height = this.height;
        this.old_is_stereo = this.is_stereo;
        this.old_stereo_distance = this.stereo_distance;
        double sx = this.rotation.s * this.rotation.x;
        double sy = this.rotation.s * this.rotation.y;
        double sz = this.rotation.s * this.rotation.z;
        double xx = this.rotation.x * this.rotation.x;
        double xy = this.rotation.x * this.rotation.y;
        double xz = this.rotation.x * this.rotation.z;
        double yy = this.rotation.y * this.rotation.y;
        double yz = this.rotation.y * this.rotation.z;
        double zz = this.rotation.z * this.rotation.z;
        double xy_factor = (double)(2 << count_accuracy_bits) * (double)this.pixel_height;
        double z_factor = (double)(2 << count_accuracy_bits) * (double)this.height / (double)this.eye_distance;
        int matrix11 = (int)(xy_factor * (0.5 - yy - zz));
        int matrix12 = (int)(xy_factor * (xy - sz));
        int matrix13 = (int)(xy_factor * (xz + sy));
        int matrix21 = (int)(xy_factor * (xy + sz));
        int matrix22 = (int)(xy_factor * (0.5 - xx - zz));
        int matrix23 = (int)(xy_factor * (yz - sx));
        int matrix31 = (int)(z_factor * (xz - sy));
        int matrix32 = (int)(z_factor * (yz + sx));
        int matrix33 = (int)(z_factor * (0.5 - xx - yy));
        int scaled_eye_distance = (int)((double)this.eye_distance * z_factor / 2.0);
        int half_pixel_width = this.pixel_width / 2;
        int half_pixel_height = this.pixel_height / 2;
        if (!this.is_stereo) {
            this.pixel_stereo_offset = 0;
            index = 0;
            while (index < this.count_points) {
                rotated_x = matrix11 * this.xs[index] + matrix12 * this.ys[index] + matrix13 * this.zs[index];
                rotated_y = matrix21 * this.xs[index] + matrix22 * this.ys[index] + matrix23 * this.zs[index];
                rotated_z = matrix31 * this.xs[index] + matrix32 * this.ys[index] + matrix33 * this.zs[index];
                denominator = scaled_eye_distance - rotated_z;
                if (denominator <= 0) {
                    this.point_scale[index] = 0;
                } else {
                    this.left_pixel_xs[index] = half_pixel_width + rotated_x / denominator;
                    this.pixel_ys[index] = half_pixel_height - rotated_y / denominator;
                    this.point_scale[index] = denominator;
                }
                ++index;
            }
        } else {
            int scaled_stereo_offset = (int)((double)this.stereo_offset * xy_factor);
            this.pixel_stereo_offset = scaled_stereo_offset / scaled_eye_distance;
            int left_pixel_offset = half_pixel_width - this.pixel_stereo_offset;
            int right_pixel_offset = half_pixel_width + this.pixel_stereo_offset;
            index = 0;
            while (index < this.count_points) {
                rotated_x = matrix11 * this.xs[index] + matrix12 * this.ys[index] + matrix13 * this.zs[index];
                rotated_y = matrix21 * this.xs[index] + matrix22 * this.ys[index] + matrix23 * this.zs[index];
                rotated_z = matrix31 * this.xs[index] + matrix32 * this.ys[index] + matrix33 * this.zs[index];
                denominator = scaled_eye_distance - rotated_z;
                if (denominator <= 0) {
                    this.point_scale[index] = 0;
                } else {
                    this.left_pixel_xs[index] = left_pixel_offset + (rotated_x + scaled_stereo_offset) / denominator;
                    this.right_pixel_xs[index] = right_pixel_offset + (rotated_x - scaled_stereo_offset) / denominator;
                    this.pixel_ys[index] = half_pixel_height - rotated_y / denominator;
                    this.point_scale[index] = denominator;
                }
                ++index;
            }
        }
        if (this.count_points == 0) {
            return;
        }
        int primitive_index = 0;
        while (primitive_index < this.count_primitives) {
            int temp;
            Primitive3D primitive = (Primitive3D)this.primitives.elementAt(primitive_index);
            int count_primitive_points = primitive.count_points;
            if (count_primitive_points >= 3) {
                if (count_primitive_points == 3) {
                    temp = this.point_scale[primitive.first_point] + this.point_scale[primitive.second_point] + this.point_scale[primitive.fourth_point];
                    this.rotated_center_zs[primitive_index] = temp + temp;
                } else {
                    temp = this.point_scale[primitive.first_point] + this.point_scale[primitive.third_point];
                    this.rotated_center_zs[primitive_index] = temp + temp + this.point_scale[primitive.second_point] + this.point_scale[primitive.fourth_point];
                }
            } else if (count_primitive_points == 2) {
                temp = this.point_scale[primitive.first_point] + this.point_scale[primitive.third_point];
                this.rotated_center_zs[primitive_index] = temp + temp + temp;
            } else {
                this.rotated_center_zs[primitive_index] = count_primitive_points == 1 ? 6 * this.point_scale[primitive.points[0]] : 1;
            }
            ++primitive_index;
        }
        int order_index = 0;
        while (order_index < this.count_ordered_primitives) {
            primitive_index = this.order[order_index];
            int rotated_center_z = this.rotated_center_zs[primitive_index];
            int sorted_index = order_index - 1;
            while (sorted_index >= 0 && this.rotated_center_zs[this.order[sorted_index]] < rotated_center_z) {
                this.order[sorted_index + 1] = this.order[sorted_index];
                --sorted_index;
            }
            this.order[sorted_index + 1] = primitive_index;
            ++order_index;
        }
    }

    public void addPrimitive(Primitive3D primitive) {
        if (primitive == null || primitive.count_points <= 0 && primitive.text == null || this.count_primitives != this.primitives.size()) {
            return;
        }
        this.primitives.addElement(primitive);
        int point_index = 0;
        while (point_index < primitive.count_points) {
            if (primitive.original_points[point_index] != null) {
                double coor;
                int axis_index;
                if (this.max_original_coordinates != null) {
                    axis_index = 0;
                    while (axis_index < 3) {
                        coor = primitive.original_points[point_index][axis_index];
                        if (coor > this.max_original_coordinates[axis_index]) {
                            this.max_original_coordinates[axis_index] = coor;
                        }
                        if (coor < this.min_original_coordinates[axis_index]) {
                            this.min_original_coordinates[axis_index] = coor;
                        }
                        ++axis_index;
                    }
                } else {
                    this.max_original_coordinates = new double[3];
                    this.min_original_coordinates = new double[3];
                    axis_index = 0;
                    while (axis_index < 3) {
                        this.max_original_coordinates[axis_index] = coor = primitive.original_points[point_index][axis_index];
                        this.min_original_coordinates[axis_index] = coor;
                        ++axis_index;
                    }
                }
            }
            ++point_index;
        }
        if (primitive.count_points > this.max_primitive_count_points) {
            this.max_primitive_count_points = primitive.count_points;
        }
        this.max_count_points += primitive.count_points;
        ++this.count_primitives;
        this.max_primitive_index = this.count_primitives - 1;
    }

    public boolean xor(boolean a, boolean b) {
        return a && !b || !a && b;
    }

    public void preparePrimitives(Graphics g) {
        int point_index;
        double max_box_ratio;
        int axis_index;
        if (this.max_original_coordinates == null) {
            this.max_original_coordinates = new double[3];
            this.min_original_coordinates = new double[3];
            axis_index = 0;
            while (axis_index < 3) {
                this.max_original_coordinates[axis_index] = 0.0;
                this.min_original_coordinates[axis_index] = 0.0;
                ++axis_index;
            }
        }
        if (this.option_Background == null) {
            this.option_Background = Color.white;
        }
        if (this.option_DefaultColor == null) {
            this.option_DefaultColor = new Color(this.option_Background.getRed() >= 128 ? 0 : 255, this.option_Background.getGreen() >= 128 ? 0 : 255, this.option_Background.getBlue() >= 128 ? 0 : 255);
        }
        if (this.option_AmbientLight == null) {
            this.option_AmbientLight = Color.black;
        }
        axis_index = 0;
        while (axis_index < 3) {
            if (this.option_PlotRange != null && this.option_PlotRange[axis_index][0] != Double.NEGATIVE_INFINITY && this.option_PlotRange[axis_index][1] != Double.POSITIVE_INFINITY) {
                if (this.option_PlotRange[axis_index][1] < this.option_PlotRange[axis_index][0]) {
                    double swap_double = this.option_PlotRange[axis_index][0];
                    this.option_PlotRange[axis_index][0] = this.option_PlotRange[axis_index][1];
                    this.option_PlotRange[axis_index][1] = swap_double;
                }
                this.original_sizes[axis_index] = this.option_PlotRange[axis_index][1] - this.option_PlotRange[axis_index][0];
                this.original_center[axis_index] = (this.option_PlotRange[axis_index][1] + this.option_PlotRange[axis_index][0]) * 0.5;
            } else {
                this.original_sizes[axis_index] = this.max_original_coordinates[axis_index] - this.min_original_coordinates[axis_index];
                this.original_sizes[axis_index] = this.max_original_coordinates[axis_index] == this.min_original_coordinates[axis_index] ? 2.1 : this.original_sizes[axis_index] * 1.05;
                this.original_center[axis_index] = (this.max_original_coordinates[axis_index] + this.min_original_coordinates[axis_index]) * 0.5;
            }
            ++axis_index;
        }
        if (this.option_BoxRatios == null) {
            this.option_BoxRatios = new double[3];
            axis_index = 0;
            while (axis_index < 3) {
                this.option_BoxRatios[axis_index] = this.original_sizes[axis_index];
                ++axis_index;
            }
        }
        if (this.option_BoxRatios[1] > (max_box_ratio = this.option_BoxRatios[0])) {
            max_box_ratio = this.option_BoxRatios[1];
        }
        if (this.option_BoxRatios[2] > max_box_ratio) {
            max_box_ratio = this.option_BoxRatios[2];
        }
        double[] scalings = new double[3];
        double[] scaled_scalings = new double[3];
        axis_index = 0;
        while (axis_index < 3) {
            this.option_BoxRatios[axis_index] = this.option_BoxRatios[axis_index] / max_box_ratio;
            scalings[axis_index] = this.option_BoxRatios[axis_index] / this.original_sizes[axis_index] * (double)max_coordinate;
            scaled_scalings[axis_index] = this.option_BoxRatios[axis_index] * (double)max_coordinate;
            ++axis_index;
        }
        double diagonal_length = Math.sqrt(this.option_BoxRatios[0] * this.option_BoxRatios[0] + this.option_BoxRatios[1] * this.option_BoxRatios[1] + this.option_BoxRatios[2] * this.option_BoxRatios[2]);
        if (this.option_Ticks == null) {
            this.option_Ticks = new Vector[3];
            int index = 0;
            while (index < 3) {
                this.option_Ticks[index] = new Vector();
                ++index;
            }
        }
        if (this.option_Boxed) {
            if (this.option_BoxStyle == null) {
                this.option_BoxStyle = new Primitive3D();
            }
            if (this.option_BoxStyle.standard_color == null) {
                this.option_BoxStyle.standard_color = this.option_DefaultColor;
            }
        }
        double[][] two_nothings = new double[][]{null, null};
        boolean has_label = false;
        boolean has_ticks = false;
        axis_index = 0;
        while (axis_index < 3) {
            boolean was_axis = false;
            int line_index = 0;
            while (line_index < 4) {
                boolean is_axis = false;
                int line_code = line_index;
                if (axis_index == 1) {
                    if (line_code == 1) {
                        line_code = 2;
                    } else if (line_code == 2) {
                        line_code = 1;
                    }
                }
                if (this.option_Axes[axis_index] && !was_axis) {
                    if (this.option_AxesEdge[axis_index] >= 0) {
                        if (line_code == this.option_AxesEdge[axis_index]) {
                            is_axis = true;
                        }
                    } else if (this.option_AxesEdge[axis_index] == -1) {
                        if (line_index == 3) {
                            is_axis = true;
                        } else if (this.xor((line_index & 1) == 1, this.option_ViewPoint[(axis_index + 1) % 3] >= 0.0) && this.xor((line_index & 2) == 2, this.option_ViewPoint[(axis_index + 2) % 3] <= 0.0) && Math.abs(this.option_ViewPoint[(axis_index + 1) % 3]) <= Math.abs(this.option_ViewPoint[(axis_index + 2) % 3])) {
                            is_axis = true;
                        } else if (this.xor((line_index & 1) == 1, this.option_ViewPoint[(axis_index + 1) % 3] <= 0.0) && this.xor((line_index & 2) == 2, this.option_ViewPoint[(axis_index + 2) % 3] >= 0.0) && Math.abs(this.option_ViewPoint[(axis_index + 1) % 3]) >= Math.abs(this.option_ViewPoint[(axis_index + 2) % 3])) {
                            is_axis = true;
                        }
                    }
                }
                if (is_axis || this.option_Boxed) {
                    Primitive3D primitive;
                    double[][] scaled_offsets = new double[2][3];
                    if (is_axis) {
                        double factor;
                        was_axis = true;
                        if (this.option_Ticks != null && this.option_Ticks[axis_index] != null) {
                            has_ticks = true;
                            if (this.option_Ticks[axis_index].isEmpty()) {
                                this.ticks_max_in_length[axis_index] = 0.01;
                                this.ticks_max_out_length[axis_index] = 0.0;
                                double[] steps = new double[]{0.25, 0.2, 0.1, 0.05, 0.025, 0.02, 0.01};
                                factor = Math.pow(10.0, Math.ceil(Math.log(this.original_sizes[axis_index]) / Math.log(10.0)));
                                int index = 1;
                                while (index < 7 && this.original_sizes[axis_index] / factor / steps[index] <= 5.0) {
                                    ++index;
                                }
                                double step = steps[--index] * factor;
                                double original_start = this.original_center[axis_index] - this.original_sizes[axis_index] / 2.0;
                                double original_end = this.original_center[axis_index] + this.original_sizes[axis_index] / 2.0;
                                double mark_position = Math.ceil(original_start / step) * step;
                                int tick_index = 0;
                                while (tick_index < 10 && mark_position <= original_end) {
                                    if (Math.abs(mark_position) < Math.abs(step / 100.0)) {
                                        mark_position = 0.0;
                                    }
                                    Primitive3D tick_primitive = new Primitive3D();
                                    tick_primitive.front_specular_exponent = 0.01;
                                    tick_primitive.back_specular_exponent = 0.0;
                                    tick_primitive.original_point_size = mark_position;
                                    tick_primitive.text = Float.toString((float)mark_position);
                                    this.option_Ticks[axis_index].addElement(tick_primitive);
                                    mark_position += step;
                                    ++tick_index;
                                }
                            }
                            int tick_index = 0;
                            while (tick_index < this.option_Ticks[axis_index].size()) {
                                Primitive3D text_primitive = new Primitive3D((Primitive3D)this.option_Ticks[axis_index].elementAt(tick_index));
                                Primitive3D line_primitive = (Primitive3D)this.option_Ticks[axis_index].elementAt(tick_index);
                                double mark_position = line_primitive.original_point_size;
                                double in_length = line_primitive.front_specular_exponent;
                                double out_length = line_primitive.back_specular_exponent;
                                line_primitive.text = null;
                                line_primitive.count_points = 2;
                                line_primitive.original_points = new double[2][3];
                                line_primitive.original_points[0][axis_index] = mark_position;
                                line_primitive.original_points[1][axis_index] = mark_position;
                                line_primitive.original_scaled_offsets = new double[2][3];
                                line_primitive.original_scaled_offsets[0][axis_index] = 0.0;
                                line_primitive.original_scaled_offsets[1][axis_index] = 0.0;
                                text_primitive.count_points = 1;
                                text_primitive.original_points = new double[1][3];
                                text_primitive.original_points[0][axis_index] = mark_position;
                                text_primitive.original_scaled_offsets = new double[1][3];
                                text_primitive.original_scaled_offsets[0][axis_index] = 0.0;
                                text_primitive.original_point_size = 0.0;
                                text_primitive.original_thickness = 0.0;
                                int index = 1;
                                while (index < 3) {
                                    double other_axis_minimum;
                                    int other_axis = (axis_index + index) % 3;
                                    double factor2 = 1.0;
                                    if ((line_index & index) == 0) {
                                        factor2 = -1.0;
                                    }
                                    line_primitive.original_points[0][other_axis] = other_axis_minimum = this.original_center[other_axis] - this.original_sizes[other_axis] / 2.0;
                                    line_primitive.original_points[1][other_axis] = other_axis_minimum;
                                    line_primitive.original_scaled_offsets[0][other_axis] = (factor2 + 1.0) / 2.0 - factor2 * in_length * diagonal_length / 1.4142136 / this.option_BoxRatios[other_axis];
                                    line_primitive.original_scaled_offsets[1][other_axis] = (factor2 + 1.0) / 2.0 + factor2 * out_length * diagonal_length / 1.4142136 / this.option_BoxRatios[other_axis];
                                    text_primitive.original_points[0][other_axis] = other_axis_minimum;
                                    text_primitive.original_scaled_offsets[0][other_axis] = (factor2 + 1.0) / 2.0 + factor2 * (0.05 + this.ticks_max_in_length[axis_index] + this.ticks_max_out_length[axis_index]) * diagonal_length / 1.4142136 / this.option_BoxRatios[other_axis];
                                    ++index;
                                }
                                this.addPrimitive(line_primitive);
                                this.addPrimitive(text_primitive);
                                ++tick_index;
                            }
                        }
                        if (this.option_AxesLabel[axis_index] != null) {
                            has_label = true;
                            primitive = this.option_AxesLabel[axis_index];
                            primitive.count_points = 1;
                            primitive.original_point_size = 0.0;
                            primitive.original_thickness = 0.0;
                            primitive.original_points = two_nothings;
                            primitive.original_scaled_offsets = new double[1][3];
                            primitive.original_scaled_offsets[0][axis_index] = 0.5;
                            int index = 1;
                            while (index < 3) {
                                factor = 1.0;
                                if ((line_index & index) == 0) {
                                    factor = -1.0;
                                }
                                int other_axis = (axis_index + index) % 3;
                                primitive.original_scaled_offsets[0][other_axis] = (factor + 1.0) / 2.0 + factor * (0.15 + this.ticks_max_in_length[axis_index] + this.ticks_max_out_length[axis_index]) * diagonal_length / 1.4142136 / this.option_BoxRatios[other_axis];
                                ++index;
                            }
                            this.addPrimitive(primitive);
                        }
                        primitive = this.option_AxesStyle[axis_index] != null ? new Primitive3D(this.option_AxesStyle[axis_index]) : new Primitive3D();
                        if (primitive.standard_color == null) {
                            primitive.standard_color = this.option_DefaultColor;
                        }
                    } else {
                        primitive = new Primitive3D(this.option_BoxStyle);
                    }
                    primitive.is_filled = false;
                    primitive.count_points = 2;
                    primitive.original_points = two_nothings;
                    primitive.original_scaled_offsets = scaled_offsets;
                    primitive.original_scaled_offsets[0][axis_index] = 0.0;
                    primitive.original_scaled_offsets[0][(axis_index + 1) % 3] = line_index & 1;
                    primitive.original_scaled_offsets[0][(axis_index + 2) % 3] = (line_index & 2) / 2;
                    primitive.original_scaled_offsets[1][axis_index] = 1.0;
                    primitive.original_scaled_offsets[1][(axis_index + 1) % 3] = line_index & 1;
                    primitive.original_scaled_offsets[1][(axis_index + 2) % 3] = (line_index & 2) / 2;
                    this.addPrimitive(primitive);
                }
                ++line_index;
            }
            ++axis_index;
        }
        if (this.option_PlotLabel != null) {
            Primitive3D primitive = this.option_PlotLabel;
            primitive.count_points = 0;
            primitive.original_point_size = 0.0;
            primitive.original_thickness = 1.0;
            primitive.original_points = null;
            primitive.original_scaled_offsets = null;
            this.addPrimitive(primitive);
        }
        int[] coordinates = new int[3];
        this.xs = new int[this.max_count_points];
        this.ys = new int[this.max_count_points];
        this.zs = new int[this.max_count_points];
        this.point_flags = new int[this.max_count_points];
        this.count_points = 0;
        int primitive_index = 0;
        while (primitive_index < this.count_primitives) {
            Primitive3D primitive = (Primitive3D)this.primitives.elementAt(primitive_index);
            if (primitive.points == null && primitive.count_points > 0) {
                primitive.points = new int[primitive.count_points + 1];
            }
            int last_old_point_index = -1;
            point_index = 0;
            int original_point_index = 0;
            while (original_point_index < primitive.count_points) {
                if (primitive.original_points[original_point_index] != null) {
                    axis_index = 0;
                    while (axis_index < 3) {
                        coordinates[axis_index] = (int)(scalings[axis_index] * (primitive.original_points[original_point_index][axis_index] - this.original_center[axis_index])) + (int)(scaled_scalings[axis_index] * primitive.original_scaled_offsets[original_point_index][axis_index]);
                        ++axis_index;
                    }
                } else {
                    axis_index = 0;
                    while (axis_index < 3) {
                        coordinates[axis_index] = (int)(scaled_scalings[axis_index] * (primitive.original_scaled_offsets[original_point_index][axis_index] - 0.5));
                        ++axis_index;
                    }
                }
                int old_point_index = 0;
                while (old_point_index < this.count_points && (coordinates[0] != this.xs[old_point_index] || coordinates[1] != this.ys[old_point_index] || coordinates[2] != this.zs[old_point_index])) {
                    ++old_point_index;
                }
                if (primitive.is_filled) {
                    this.point_flags[old_point_index] = this.point_flags[old_point_index] | 1;
                }
                if (old_point_index >= this.count_points) {
                    this.xs[old_point_index] = coordinates[0];
                    this.ys[old_point_index] = coordinates[1];
                    this.zs[old_point_index] = coordinates[2];
                    this.count_points = old_point_index + 1;
                }
                if (last_old_point_index != old_point_index) {
                    primitive.points[point_index] = old_point_index;
                    last_old_point_index = old_point_index;
                    ++point_index;
                }
                ++original_point_index;
            }
            if (primitive.is_filled && point_index >= 4 && primitive.points[0] == primitive.points[point_index - 1]) {
                --point_index;
            }
            if (primitive.count_points == 2) {
                if (point_index == 1) {
                    primitive.points[1] = primitive.points[0];
                }
            } else if (primitive.count_points >= 3) {
                if (point_index == 1) {
                    primitive.points[1] = primitive.points[0];
                    point_index = 2;
                }
                if (point_index == 2) {
                    primitive.points[2] = primitive.points[1];
                    point_index = 3;
                }
                primitive.count_points = point_index;
            }
            if (primitive.text == null) {
                primitive.point_diameter = !primitive.is_filled && primitive.count_points == 1 ? (primitive.is_absolute_point_size ? (int)primitive.original_point_size : (int)(primitive.original_point_size * (double)this.full_pixel_height * diagonal_length * (double)(max_coordinate << count_accuracy_bits))) : (primitive.is_filled ? (primitive.is_absolute_edge_thickness ? (int)primitive.original_edge_thickness : (int)(primitive.original_edge_thickness * (double)this.full_pixel_height * diagonal_length * (double)(max_coordinate << count_accuracy_bits))) : (primitive.is_absolute_thickness ? (int)primitive.original_thickness : (int)(primitive.original_thickness * (double)this.full_pixel_height * diagonal_length * (double)(max_coordinate << count_accuracy_bits))));
                if (primitive.count_points == 1) {
                    primitive.first_point = primitive.points[0];
                    primitive.second_point = primitive.points[0];
                    primitive.third_point = primitive.points[0];
                    primitive.fourth_point = primitive.points[0];
                } else if (primitive.count_points == 2) {
                    primitive.first_point = primitive.points[0];
                    primitive.second_point = primitive.points[0];
                    primitive.third_point = primitive.points[1];
                    primitive.fourth_point = primitive.points[1];
                } else if (primitive.count_points == 3) {
                    primitive.first_point = primitive.points[0];
                    primitive.second_point = primitive.points[1];
                    primitive.third_point = primitive.points[1];
                    primitive.fourth_point = primitive.points[2];
                } else if (primitive.count_points == 4) {
                    int min_edge_index = 0;
                    int min_edge_distance = 0;
                    int edge_distance = 0;
                    int edge_index = 0;
                    while (edge_index < 4) {
                        edge_distance = this.getPointDistance(primitive, edge_index);
                        if (edge_index == 0 || min_edge_distance > edge_distance) {
                            min_edge_index = edge_index;
                            min_edge_distance = edge_distance;
                        }
                        ++edge_index;
                    }
                    if (min_edge_index == 1 || min_edge_index == 2) {
                        primitive.first_point = primitive.points[0];
                        primitive.second_point = primitive.points[1];
                        primitive.third_point = primitive.points[2];
                        primitive.fourth_point = primitive.points[3];
                    } else {
                        primitive.first_point = primitive.points[2];
                        primitive.second_point = primitive.points[3];
                        primitive.third_point = primitive.points[0];
                        primitive.fourth_point = primitive.points[1];
                    }
                } else if (primitive.count_points > 4) {
                    int distance_sum = 0;
                    int edge_index = 0;
                    while (edge_index < primitive.count_points) {
                        distance_sum += this.getPointDistance(primitive, edge_index);
                        ++edge_index;
                    }
                    double distance = (double)distance_sum / 3.0;
                    int i = 1;
                    double i_times_distance = distance;
                    int second_point_index = 0;
                    distance_sum = 0;
                    primitive.first_point = primitive.points[0];
                    int edge_index2 = 0;
                    while (i < 3 && edge_index2 < primitive.count_points) {
                        int last_distance_sum = distance_sum;
                        if ((double)(distance_sum += this.getPointDistance(primitive, edge_index2)) > i_times_distance) {
                            point_index = (double)distance_sum - i_times_distance < i_times_distance - (double)last_distance_sum ? (edge_index2 + 1) % primitive.count_points : edge_index2;
                            if (i == 1) {
                                primitive.second_point = primitive.points[point_index];
                                second_point_index = point_index;
                            } else if (i == 2) {
                                primitive.third_point = primitive.points[(second_point_index + point_index) / 2];
                                primitive.fourth_point = primitive.points[point_index];
                            }
                            ++i;
                            i_times_distance += distance;
                        }
                        ++edge_index2;
                    }
                }
            }
            primitive.original_points = null;
            primitive.original_scaled_offsets = null;
            ++primitive_index;
        }
        if (this.option_ViewPoint != null && this.option_ViewVertical != null) {
            double rotation_angle;
            double[] rotation_axis = new double[3];
            double[] normalized_view_point = new double[3];
            double length_view_point = Math.sqrt(this.option_ViewPoint[0] * this.option_ViewPoint[0] + this.option_ViewPoint[1] * this.option_ViewPoint[1] + this.option_ViewPoint[2] * this.option_ViewPoint[2]);
            normalized_view_point[0] = this.option_ViewPoint[0] / length_view_point;
            normalized_view_point[1] = this.option_ViewPoint[1] / length_view_point;
            normalized_view_point[2] = this.option_ViewPoint[2] / length_view_point;
            rotation_axis[0] = normalized_view_point[1];
            rotation_axis[1] = -normalized_view_point[0];
            rotation_axis[2] = 0.0;
            double length_rotation_axis = Math.sqrt(rotation_axis[0] * rotation_axis[0] + rotation_axis[1] * rotation_axis[1] + rotation_axis[2] * rotation_axis[2]);
            if (length_rotation_axis > 1.0) {
                length_rotation_axis = 1.0;
            }
            if ((rotation_angle = Math.asin(length_rotation_axis)) < 1.0E-4) {
                this.rotation = this.option_ViewPoint[2] > 0.0 ? new Quaternion(0.0, 1.0, 0.0, 0.0, false) : new Quaternion(Math.PI, 1.0, 0.0, 0.0, false);
            } else {
                if (this.option_ViewPoint[2] < 0.0) {
                    rotation_angle = Math.PI - rotation_angle;
                }
                this.rotation = new Quaternion(rotation_angle, rotation_axis[0], rotation_axis[1], rotation_axis[2], true);
            }
            double[] rotated_view_vertical = new double[]{this.option_ViewVertical[0] * this.option_BoxRatios[0], this.option_ViewVertical[1] * this.option_BoxRatios[1], this.option_ViewVertical[2] * this.option_BoxRatios[2]};
            rotated_view_vertical = this.rotation.rotated(rotated_view_vertical);
            rotation_angle = Math.abs(rotated_view_vertical[0]) < 1.0E-7 ? (rotated_view_vertical[1] > 0.0 ? 0.0 : Math.PI) : Math.atan2(rotated_view_vertical[0], rotated_view_vertical[1]);
            this.rotation = new Quaternion(rotation_angle, 0.0, 0.0, 1.0, false).product(this.rotation);
            if (has_label || has_ticks) {
                this.setPerspective(length_view_point, 0.66, this.is_stereo, this.stereo_distance);
            } else {
                this.setPerspective(length_view_point, 1.0, this.is_stereo, this.stereo_distance);
            }
        } else if (has_label || has_ticks) {
            this.setPerspective(3.38378, 0.66, this.is_stereo, this.stereo_distance);
        } else {
            this.setPerspective(3.38378, 1.0, this.is_stereo, this.stereo_distance);
        }
        this.initial_magnification = this.magnification;
        this.initial_length_view_point = this.length_view_point;
        this.initial_rotation = this.rotation;
        primitive_index = 0;
        while (primitive_index < this.count_primitives) {
            Primitive3D primitive = (Primitive3D)this.primitives.elementAt(primitive_index);
            if (primitive.standard_color == null) {
                primitive.standard_color = this.option_DefaultColor;
            }
            if (primitive.text != null) {
                if (primitive.front_face_color == null) {
                    primitive.front_face_color = this.option_TextStyle_font_color != null ? this.option_TextStyle_font_color : primitive.standard_color;
                }
                if (primitive.back_face_color == null && this.option_TextStyle_font_background != null) {
                    primitive.back_face_color = this.option_TextStyle_font_background;
                }
                primitive.front_color = primitive.front_face_color;
                primitive.back_color = primitive.back_face_color;
            } else {
                if (primitive.edge_color == null) {
                    primitive.edge_color = this.option_DefaultColor;
                }
                if (primitive.front_face_color == null) {
                    primitive.front_face_color = this.option_DefaultColor;
                }
                if (primitive.back_face_color == null && primitive.text == null) {
                    primitive.back_face_color = this.option_DefaultColor;
                }
                if (!this.option_Lighting) {
                    primitive.front_color = primitive.front_face_color;
                    primitive.back_color = primitive.back_face_color;
                }
            }
            if (primitive.is_filled && this.option_Lighting && primitive.count_points > 2) {
                double[] normal_vector = new double[3];
                int[][] face_colors = new int[][]{{primitive.front_diffuse_color.getRed() * this.option_AmbientLight.getRed() / 255, primitive.front_diffuse_color.getGreen() * this.option_AmbientLight.getGreen() / 255, primitive.front_diffuse_color.getBlue() * this.option_AmbientLight.getBlue() / 255}, {primitive.back_diffuse_color.getRed() * this.option_AmbientLight.getRed() / 255, primitive.back_diffuse_color.getGreen() * this.option_AmbientLight.getGreen() / 255, primitive.back_diffuse_color.getBlue() * this.option_AmbientLight.getBlue() / 255}};
                int a_x = this.xs[primitive.second_point] - this.xs[primitive.first_point];
                int a_y = this.ys[primitive.second_point] - this.ys[primitive.first_point];
                int a_z = this.zs[primitive.second_point] - this.zs[primitive.first_point];
                int b_x = this.xs[primitive.fourth_point] - this.xs[primitive.second_point];
                int b_y = this.ys[primitive.fourth_point] - this.ys[primitive.second_point];
                int b_z = this.zs[primitive.fourth_point] - this.zs[primitive.second_point];
                normal_vector[0] = a_y * b_z - a_z * b_y;
                normal_vector[1] = a_z * b_x - a_x * b_z;
                normal_vector[2] = a_x * b_y - a_y * b_x;
                double vector_length = Math.sqrt(normal_vector[0] * normal_vector[0] + normal_vector[1] * normal_vector[1] + normal_vector[2] * normal_vector[2]);
                normal_vector[0] = normal_vector[0] / vector_length;
                normal_vector[1] = normal_vector[1] / vector_length;
                normal_vector[2] = normal_vector[2] / vector_length;
                normal_vector = this.rotation.rotated(normal_vector);
                int light_index = 0;
                while (light_index < this.option_LightSources_vectors.size()) {
                    Color diffuse_color;
                    int face_index;
                    double[] light_source_vector = (double[])this.option_LightSources_vectors.elementAt(light_index);
                    Color light_source_color = (Color)this.option_LightSources_colors.elementAt(light_index);
                    double dot_product = normal_vector[0] * light_source_vector[0] + normal_vector[1] * light_source_vector[1] + normal_vector[2] * light_source_vector[2];
                    if (dot_product > 0.0) {
                        face_index = 0;
                        diffuse_color = primitive.front_diffuse_color;
                    } else {
                        dot_product = -dot_product;
                        face_index = 1;
                        diffuse_color = primitive.back_diffuse_color;
                    }
                    if (diffuse_color != null) {
                        face_colors[face_index][0] = face_colors[face_index][0] + (int)((double)(diffuse_color.getRed() * light_source_color.getRed()) * (dot_product /= 255.0));
                        face_colors[face_index][1] = face_colors[face_index][1] + (int)((double)(diffuse_color.getGreen() * light_source_color.getGreen()) * dot_product);
                        face_colors[face_index][2] = face_colors[face_index][2] + (int)((double)(diffuse_color.getBlue() * light_source_color.getBlue()) * dot_product);
                    }
                    Color specular_color = null;
                    double specular_exponent = 1.0;
                    dot_product = normal_vector[0] * light_source_vector[0] + normal_vector[1] * light_source_vector[1] + normal_vector[2] * light_source_vector[2];
                    if (normal_vector[2] >= 0.0) {
                        if (dot_product > 0.0) {
                            face_index = 0;
                            specular_color = primitive.front_specular_color;
                            specular_exponent = primitive.front_specular_exponent;
                        }
                    } else if (dot_product < 0.0) {
                        face_index = 1;
                        specular_color = primitive.back_specular_color;
                        specular_exponent = primitive.back_specular_exponent;
                    }
                    if (specular_color != null) {
                        double[] reflected_view = new double[]{2.0 * normal_vector[0] * normal_vector[2], 2.0 * normal_vector[1] * normal_vector[2], 2.0 * normal_vector[2] * normal_vector[2] - 1.0};
                        dot_product = reflected_view[0] * light_source_vector[0] + reflected_view[1] * light_source_vector[1] + reflected_view[2] * light_source_vector[2];
                        if ((dot_product += 1.0) < 0.0) {
                            dot_product = 0.0;
                        }
                        dot_product = Math.pow(Math.abs(dot_product / 2.0), specular_exponent);
                        face_colors[face_index][0] = face_colors[face_index][0] + (int)((double)(specular_color.getRed() * light_source_color.getRed()) * (dot_product /= 255.0));
                        face_colors[face_index][1] = face_colors[face_index][1] + (int)((double)(specular_color.getGreen() * light_source_color.getGreen()) * dot_product);
                        face_colors[face_index][2] = face_colors[face_index][2] + (int)((double)(specular_color.getBlue() * light_source_color.getBlue()) * dot_product);
                    }
                    ++light_index;
                }
                int color_index = 0;
                while (color_index < 3) {
                    int face_index = 0;
                    while (face_index < 2) {
                        if (face_colors[face_index][color_index] < 0) {
                            face_colors[face_index][color_index] = 0;
                        }
                        if (face_colors[face_index][color_index] > 255) {
                            face_colors[face_index][color_index] = 255;
                        }
                        ++face_index;
                    }
                    ++color_index;
                }
                primitive.front_color = new Color(face_colors[0][0], face_colors[0][1], face_colors[0][2]);
                primitive.back_color = new Color(face_colors[1][0], face_colors[1][1], face_colors[1][2]);
            }
            ++primitive_index;
        }
        this.order = new int[this.count_primitives];
        int ordered_primitive_index = 0;
        primitive_index = 0;
        while (primitive_index < this.count_primitives) {
            boolean is_edge = false;
            Primitive3D primitive = (Primitive3D)this.primitives.elementAt(primitive_index);
            if (!primitive.is_filled && primitive.count_points > 1) {
                boolean all_points_in_polygons = true;
                point_index = 0;
                while (point_index < primitive.count_points && all_points_in_polygons) {
                    if ((this.point_flags[primitive.points[point_index]] & 1) == 0) {
                        all_points_in_polygons = false;
                    }
                    ++point_index;
                }
                if (all_points_in_polygons) {
                    Primitive3D primitive2 = null;
                    int primitive2_index = 0;
                    while (primitive2_index < this.count_primitives) {
                        boolean all_points_in_polygon = true;
                        primitive2 = (Primitive3D)this.primitives.elementAt(primitive2_index);
                        if (primitive2.is_filled) {
                            point_index = 0;
                            while (point_index < primitive.count_points && all_points_in_polygon) {
                                boolean point_in_polygon = false;
                                int point2_index = 0;
                                while (point2_index < primitive2.count_points && !point_in_polygon) {
                                    if (primitive.points[point_index] == primitive2.points[point2_index]) {
                                        point_in_polygon = true;
                                    }
                                    ++point2_index;
                                }
                                if (!point_in_polygon) {
                                    all_points_in_polygon = false;
                                }
                                ++point_index;
                            }
                            if (all_points_in_polygon) {
                                primitive2.addEdge(primitive);
                                is_edge = true;
                            }
                        }
                        ++primitive2_index;
                    }
                }
            }
            if (!is_edge) {
                this.order[ordered_primitive_index] = primitive_index;
                ++ordered_primitive_index;
            }
            ++primitive_index;
        }
        this.count_ordered_primitives = ordered_primitive_index;
        this.left_pixel_xs = new int[this.count_points];
        this.right_pixel_xs = new int[this.count_points];
        this.pixel_ys = new int[this.count_points];
        this.point_scale = new int[this.count_points];
        this.temp_xs = new int[this.max_primitive_count_points + 1];
        this.temp_ys = new int[this.max_primitive_count_points + 1];
        this.temp_line_xs = new int[6];
        this.temp_line_ys = new int[6];
        this.rotated_center_zs = new int[this.count_primitives];
        if (this.option_TextStyle_font_family == null) {
            this.option_TextStyle_font_family = "Courier";
        }
        if (this.option_TextStyle_font_weight == -1) {
            this.option_TextStyle_font_weight = 0;
        }
        if (this.option_TextStyle_font_slant == -1) {
            this.option_TextStyle_font_slant = 0;
        }
        if (this.option_TextStyle_font_size == -1) {
            this.option_TextStyle_font_size = 10;
        }
        primitive_index = 0;
        while (primitive_index < this.count_primitives) {
            Primitive3D primitive = (Primitive3D)this.primitives.elementAt(primitive_index);
            if (primitive.text != null) {
                if (primitive.font_url == null) {
                    primitive.font_url = this.option_TextStyle_font_url;
                }
                if (primitive.font == null) {
                    primitive.font = this.option_TextStyle_font_family;
                }
                if (primitive.font_size == -1) {
                    primitive.font_size = this.option_TextStyle_font_size;
                }
                if (primitive.font_weight == -1) {
                    primitive.font_weight = this.option_TextStyle_font_weight;
                }
                if (primitive.font_slant == -1) {
                    primitive.font_slant = this.option_TextStyle_font_slant;
                }
                primitive.font = new Font((String)primitive.font, primitive.font_weight | primitive.font_slant, primitive.font_size);
                g.setFont((Font)primitive.font);
                FontMetrics fm = g.getFontMetrics();
                primitive.font_size = fm.getMaxAscent() + fm.getMaxDescent();
                primitive.font_weight = fm.stringWidth(primitive.text);
                primitive.font_slant = -((int)((double)primitive.font_weight * (primitive.original_point_size + 1.0) / 2.0));
                primitive.font_y_offset = (int)((double)primitive.font_size * (primitive.original_thickness + 1.0) / 2.0) - fm.getMaxDescent();
                primitive.first_point = primitive.font_slant - 2;
                primitive.second_point = primitive.font_y_offset - fm.getMaxAscent() - 2;
                primitive.third_point = primitive.font_weight + 4;
                primitive.fourth_point = primitive.font_size + 4;
            }
            ++primitive_index;
        }
    }

    public int getPointDistance(Primitive3D primitive, int edge_index) {
        int point1 = primitive.points[edge_index];
        int point2 = primitive.points[(edge_index + 1) % primitive.count_points];
        return Math.abs(this.xs[point2] - this.xs[point1]) + Math.abs(this.ys[point2] - this.ys[point1]) + Math.abs(this.zs[point2] - this.zs[point1]);
    }

    public void setPerspective(double length_view_point, double magnification, boolean is_stereo, double stereo_distance) {
        this.length_view_point = length_view_point;
        this.magnification = magnification;
        this.is_stereo = is_stereo;
        this.stereo_distance = stereo_distance;
        if (!is_stereo) {
            this.pixel_width = this.full_pixel_width;
            this.pixel_height = this.full_pixel_height;
        } else {
            this.pixel_width = (this.full_pixel_width + 1) / 2;
            this.pixel_height = this.full_pixel_height;
        }
        double radius = 0.5 * (double)max_coordinate * Math.sqrt(this.option_BoxRatios[0] * this.option_BoxRatios[0] + this.option_BoxRatios[1] * this.option_BoxRatios[1] + this.option_BoxRatios[2] * this.option_BoxRatios[2]);
        length_view_point = (double)max_coordinate * length_view_point;
        if (length_view_point < 1.01 * radius) {
            length_view_point = 1.01 * radius;
            this.length_view_point = length_view_point / (double)max_coordinate;
        }
        this.eye_distance = (int)length_view_point;
        this.height = this.width = 2 * (int)Math.sqrt(length_view_point * length_view_point * radius * radius / (length_view_point * length_view_point - radius * radius));
        if (this.pixel_width < this.pixel_height) {
            this.height = (int)((double)this.height * (double)this.pixel_height / (double)this.pixel_width);
        } else {
            this.width = (int)((double)this.width * (double)this.pixel_width / (double)this.pixel_height);
        }
        this.eye_distance = (int)((double)this.eye_distance / magnification);
        this.width = (int)((double)this.width / magnification);
        this.height = (int)((double)this.height / magnification);
        this.stereo_offset = (int)(stereo_distance / 2.0 * radius * 2.0);
    }

    public void setCutPrimitivesCount(int count, int visible_faces_default) {
        this.min_primitive_index = 0;
        this.max_primitive_index = this.count_primitives - count - 1;
        this.visible_faces = count > 0 ? 3 : visible_faces_default;
    }

    public void paint(Graphics left_graphics, Graphics right_graphics, Image right_image) {
        if (!this.is_stereo) {
            this.paintPrimitives(left_graphics, this.left_pixel_xs);
        } else {
            this.paintPrimitives(left_graphics, this.left_pixel_xs);
            this.paintPrimitives(right_graphics, this.right_pixel_xs);
            left_graphics.drawImage(right_image, this.pixel_width, 0, null);
        }
    }

    public void paintPrimitives(Graphics g, int[] pixel_xs) {
        int edge_index = 0;
        int ordered_index = 0;
        while (ordered_index < this.count_ordered_primitives) {
            int primitive_index = this.order[ordered_index];
            if (this.min_primitive_index <= primitive_index && primitive_index <= this.max_primitive_index) {
                Primitive3D primitive;
                Primitive3D polygon = primitive = (Primitive3D)this.primitives.elementAt(primitive_index);
                edge_index = -1;
                while (primitive != null) {
                    int diameter;
                    int point;
                    int point_index;
                    boolean is_visible = true;
                    int count_primitive_points = primitive.count_points;
                    if (primitive.text != null) {
                        if (primitive.count_points == 0) {
                            if (primitive.back_color != null) {
                                g.setColor(primitive.back_color);
                                g.fillRect(this.pixel_width / 2 + primitive.first_point, 2 + primitive.second_point, primitive.third_point, primitive.fourth_point);
                            }
                            g.setColor(primitive.front_color);
                            g.setFont((Font)primitive.font);
                            g.drawString(primitive.text, this.pixel_width / 2 + primitive.font_slant, 2 + primitive.font_y_offset);
                        } else {
                            point_index = primitive.points[0];
                            if (this.point_scale[point_index] != 0) {
                                if (primitive.back_color != null) {
                                    g.setColor(primitive.back_color);
                                    g.fillRect(pixel_xs[point_index] + primitive.first_point, this.pixel_ys[point_index] + primitive.second_point, primitive.third_point, primitive.fourth_point);
                                }
                                g.setColor(primitive.front_color);
                                g.setFont((Font)primitive.font);
                                g.drawString(primitive.text, pixel_xs[point_index] + primitive.font_slant, this.pixel_ys[point_index] + primitive.font_y_offset);
                            }
                        }
                    } else if (count_primitive_points == 1) {
                        point = primitive.points[0];
                        if (this.point_scale[point] != 0) {
                            g.setColor(primitive.standard_color);
                            diameter = primitive.is_absolute_point_size ? primitive.point_diameter : primitive.point_diameter / this.point_scale[point];
                            if (diameter > 1) {
                                int radius = diameter / 2;
                                g.fillOval(pixel_xs[point] - radius, this.pixel_ys[point] - radius, diameter, diameter);
                                if (this.point_edge_color != null) {
                                    g.setColor(this.point_edge_color);
                                    g.drawOval(pixel_xs[point] - radius, this.pixel_ys[point] - radius, diameter, diameter);
                                }
                            } else {
                                if (this.point_edge_color != null) {
                                    g.setColor(this.point_edge_color);
                                }
                                g.drawLine(pixel_xs[point], this.pixel_ys[point], pixel_xs[point], this.pixel_ys[point]);
                            }
                        }
                    } else if (count_primitive_points > 1) {
                        point_index = 0;
                        while (point_index < count_primitive_points) {
                            point = primitive.points[point_index];
                            if (this.point_scale[point] == 0) break;
                            this.temp_xs[point_index] = pixel_xs[point];
                            this.temp_ys[point_index] = this.pixel_ys[point];
                            ++point_index;
                        }
                        if (point_index >= count_primitive_points) {
                            boolean is_absolute_thickness = true;
                            if (primitive.is_filled && count_primitive_points > 2) {
                                int z_coordinate = (pixel_xs[primitive.second_point] - pixel_xs[primitive.first_point]) * (this.pixel_ys[primitive.fourth_point] - this.pixel_ys[primitive.second_point]) - (pixel_xs[primitive.fourth_point] - pixel_xs[primitive.second_point]) * (this.pixel_ys[primitive.second_point] - this.pixel_ys[primitive.first_point]);
                                if (z_coordinate == 0) {
                                    z_coordinate = primitive.last_z_coordinate;
                                } else {
                                    primitive.last_z_coordinate = z_coordinate;
                                }
                                if (z_coordinate <= 0) {
                                    if ((this.visible_faces & 1) == 1) {
                                        g.setColor(primitive.front_color);
                                    } else {
                                        is_visible = false;
                                    }
                                } else if (z_coordinate > 0) {
                                    if ((this.visible_faces & 2) == 2) {
                                        g.setColor(primitive.back_color);
                                    } else {
                                        is_visible = false;
                                    }
                                }
                                if (is_visible) {
                                    g.fillPolygon(this.temp_xs, this.temp_ys, count_primitive_points);
                                    if (primitive.is_outlined) {
                                        this.temp_xs[count_primitive_points] = this.temp_xs[0];
                                        this.temp_ys[count_primitive_points] = this.temp_ys[0];
                                        primitive.points[count_primitive_points] = primitive.points[0];
                                        ++count_primitive_points;
                                        g.setColor(primitive.edge_color);
                                        is_absolute_thickness = primitive.is_absolute_edge_thickness;
                                    }
                                }
                            } else if (!primitive.is_filled) {
                                g.setColor(primitive.standard_color);
                                is_absolute_thickness = primitive.is_absolute_thickness;
                            }
                            if (!primitive.is_filled || is_visible && primitive.is_outlined && count_primitive_points > 3) {
                                if (is_absolute_thickness && primitive.point_diameter < 2) {
                                    if (primitive.is_filled || count_primitive_points <= 2) {
                                        g.drawPolygon(this.temp_xs, this.temp_ys, count_primitive_points);
                                    } else {
                                        int x_start = this.temp_xs[0];
                                        int y_start = this.temp_ys[0];
                                        point_index = 1;
                                        while (point_index < count_primitive_points) {
                                            int x_end = this.temp_xs[point_index];
                                            int y_end = this.temp_ys[point_index];
                                            g.drawLine(x_start, y_start, x_end, y_end);
                                            x_start = x_end;
                                            y_start = y_end;
                                            ++point_index;
                                        }
                                    }
                                } else {
                                    diameter = primitive.point_diameter;
                                    int diameter_start = !is_absolute_thickness ? diameter / this.point_scale[primitive.points[0]] : diameter;
                                    int radius_start = --diameter_start / 2;
                                    int x_start = this.temp_xs[0] - radius_start;
                                    int y_start = this.temp_ys[0] - radius_start;
                                    point_index = 1;
                                    while (point_index < count_primitive_points) {
                                        int count_line_points = 0;
                                        int diameter_end = !is_absolute_thickness ? diameter / this.point_scale[primitive.points[point_index]] : diameter;
                                        int radius_end = --diameter_end / 2;
                                        int x_end = this.temp_xs[point_index] - radius_end;
                                        int y_end = this.temp_ys[point_index] - radius_end;
                                        count_line_points = 0;
                                        g.drawLine(x_start, y_start, x_end, y_end);
                                        if (diameter_start > 0 || diameter_end > 0) {
                                            if (diameter_start <= 0) {
                                                this.temp_line_xs[0] = x_start;
                                                this.temp_line_ys[0] = y_start;
                                                count_line_points = 1;
                                            }
                                            if (y_start < y_end) {
                                                if (x_start < x_end) {
                                                    if (diameter_start > 0) {
                                                        this.temp_line_xs[0] = x_start;
                                                        this.temp_line_ys[0] = y_start + diameter_start;
                                                        this.temp_line_xs[1] = x_start;
                                                        this.temp_line_ys[1] = y_start;
                                                        this.temp_line_xs[2] = x_start + diameter_start;
                                                        this.temp_line_ys[2] = y_start;
                                                        count_line_points = 3;
                                                    }
                                                    if (diameter_end > 0) {
                                                        this.temp_line_xs[count_line_points] = x_end + diameter_end;
                                                        this.temp_line_ys[count_line_points] = y_end;
                                                        this.temp_line_xs[count_line_points + 1] = x_end + diameter_end;
                                                        this.temp_line_ys[count_line_points + 1] = y_end + diameter_end;
                                                        this.temp_line_xs[count_line_points + 2] = x_end;
                                                        this.temp_line_ys[count_line_points + 2] = y_end + diameter_end;
                                                        count_line_points += 3;
                                                    }
                                                } else {
                                                    if (diameter_start > 0) {
                                                        this.temp_line_xs[0] = x_start;
                                                        this.temp_line_ys[0] = y_start;
                                                        this.temp_line_xs[1] = x_start + diameter_start;
                                                        this.temp_line_ys[1] = y_start;
                                                        this.temp_line_xs[2] = x_start + diameter_start;
                                                        this.temp_line_ys[2] = y_start + diameter_start;
                                                        count_line_points = 3;
                                                    }
                                                    if (diameter_end > 0) {
                                                        this.temp_line_xs[count_line_points] = x_end + diameter_end;
                                                        this.temp_line_ys[count_line_points] = y_end + diameter_end;
                                                        this.temp_line_xs[count_line_points + 1] = x_end;
                                                        this.temp_line_ys[count_line_points + 1] = y_end + diameter_end;
                                                        this.temp_line_xs[count_line_points + 2] = x_end;
                                                        this.temp_line_ys[count_line_points + 2] = y_end;
                                                        count_line_points += 3;
                                                    }
                                                }
                                            } else if (x_start > x_end) {
                                                if (diameter_start > 0) {
                                                    this.temp_line_xs[0] = x_start + diameter_start;
                                                    this.temp_line_ys[0] = y_start;
                                                    this.temp_line_xs[1] = x_start + diameter_start;
                                                    this.temp_line_ys[1] = y_start + diameter_start;
                                                    this.temp_line_xs[2] = x_start;
                                                    this.temp_line_ys[2] = y_start + diameter_start;
                                                    count_line_points = 3;
                                                }
                                                if (diameter_end > 0) {
                                                    this.temp_line_xs[count_line_points] = x_end;
                                                    this.temp_line_ys[count_line_points] = y_end + diameter_end;
                                                    this.temp_line_xs[count_line_points + 1] = x_end;
                                                    this.temp_line_ys[count_line_points + 1] = y_end;
                                                    this.temp_line_xs[count_line_points + 2] = x_end + diameter_end;
                                                    this.temp_line_ys[count_line_points + 2] = y_end;
                                                    count_line_points += 3;
                                                }
                                            } else {
                                                if (diameter_start > 0) {
                                                    this.temp_line_xs[0] = x_start + diameter_start;
                                                    this.temp_line_ys[0] = y_start + diameter_start;
                                                    this.temp_line_xs[1] = x_start;
                                                    this.temp_line_ys[1] = y_start + diameter_start;
                                                    this.temp_line_xs[2] = x_start;
                                                    this.temp_line_ys[2] = y_start;
                                                    count_line_points = 3;
                                                }
                                                if (diameter_end > 0) {
                                                    this.temp_line_xs[count_line_points] = x_end;
                                                    this.temp_line_ys[count_line_points] = y_end;
                                                    this.temp_line_xs[count_line_points + 1] = x_end + diameter_end;
                                                    this.temp_line_ys[count_line_points + 1] = y_end;
                                                    this.temp_line_xs[count_line_points + 2] = x_end + diameter_end;
                                                    this.temp_line_ys[count_line_points + 2] = y_end + diameter_end;
                                                    count_line_points += 3;
                                                }
                                            }
                                            if (diameter_end <= 0) {
                                                this.temp_line_xs[count_line_points] = x_end;
                                                this.temp_line_ys[count_line_points] = y_end;
                                                ++count_line_points;
                                            }
                                            g.fillPolygon(this.temp_line_xs, this.temp_line_ys, count_line_points);
                                        }
                                        diameter_start = diameter_end;
                                        radius_start = radius_end;
                                        x_start = x_end;
                                        y_start = y_end;
                                        ++point_index;
                                    }
                                }
                            }
                        }
                    }
                    primitive = !is_visible || !polygon.is_filled || polygon.edge_primitives == null || polygon.edge_primitives.size() <= edge_index + 1 ? null : (Primitive3D)polygon.edge_primitives.elementAt(++edge_index);
                }
            }
            ++ordered_index;
        }
    }
}

