package util {
	
	import events.NewXMLEvent;
	
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.IOErrorEvent;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	
	import mx.controls.Alert;
	import mx.events.ValidationResultEvent;
	
	public class SaveLoadUtil extends EventDispatcher{
		
		private var _loadFileRef:FileReference = new FileReference();
		private var _saveFileRef:FileReference = new FileReference();
		
		public function SaveLoadUtil() { 
			_loadFileRef.addEventListener(Event.COMPLETE,onFileLoaded);
			_loadFileRef.addEventListener(Event.SELECT,onFileSelect);
			_loadFileRef.addEventListener(IOErrorEvent.IO_ERROR,onFileError);
			
			_saveFileRef.addEventListener(Event.COMPLETE, onFileSaved);
			_saveFileRef.addEventListener(Event.SELECT, onSaveSelect);
			_saveFileRef.addEventListener(IOErrorEvent.IO_ERROR, onFileError);
		}
		
		//Save the file called xml.
		public function saveHandler(xml:XML):void {
			try {
				_saveFileRef.save(xml, "hexagon.xml");	
			} catch(e:Error) {
				Alert.show(e.message+'. Make sure you have the latest Flash player installed in your browser.',e.name);
			}	
		}
		
		public function loadHandler():void {
			_loadFileRef.browse([new FileFilter("xml", "*.xml")]);
		}
	
		private function onSaveSelect(event:Event):void {} 
		
		//Save file functionality.
		private function onFileSaved(event:Event):void {
			var f:FileReference = event.target as FileReference;
			Alert.show("The configuration of triangles from Experiment Window has" + 
					" been saved to "+f.name+".");
		}

		//Error loading file handler.
		private function onFileError(event:IOErrorEvent):void {
			trace(event);
		}	
	
		//File select handler.
		private function onFileSelect(event:Event):void {
			var f:FileReference = event.target as FileReference;
			try {
				f.load();	
			} catch(e:Error) {
				Alert.show(e.message+'. Make sure you have the latest Flash player installed in your browser.',e.name);
			}
		}

		//File loaded handler.
		private function onFileLoaded(event:Event):void {

			var f:FileReference = event.target as FileReference;
			
			newConfig(XML(f.data.toString()));
			
		
		}
		
		public function newConfig(xml:XML):void {
			var obj:Object = {property:xml.toString()};

			//If xml dodgy then give an error message. Otherwise proceed.
			if (validateXML(obj)) {
				var event:NewXMLEvent = new NewXMLEvent(NewXMLEvent.NEW_XML);
				event.xml = xml;
				dispatchEvent(event);
				
			} else {
				trace("xml error");
			}
		}
		 
		//Test if xml is okay.
		private function validateXML(obj:Object):Boolean { 
			var xmlValidator:XMLValidator = new XMLValidator();
			xmlValidator.source = obj; 
			xmlValidator.property = "property";
			return xmlValidator.validate().type == ValidationResultEvent.VALID;
		}
		
		
	}
}