/**
 * Class for labels of the form A, B,..., Z, AA, BB, ..,ZZ, AAA, ...,ZZZ, etc.
 */

package util {
	
	public class ExtendedAlphabet {
		
/* Next two functions are for converting between 0,1,2,3,... and A,B,..,AA,BB,...*/		
		
		
		//Returns integer index of String. Returns MAX_VALUE if no good.
		private static function stringToInt(s:String):uint {
			var t:String = s.charAt(0);
			for (var i:int=1; i!=s.length; i++) {
				if (t!=s.charAt(i)) return uint.MAX_VALUE; 
			}
			return t.charCodeAt(0)-65 + 26*(s.length-1);
		}
		
		//Converts integers index to ExtendedAlphabet string.			
		private static function intToString(I:uint):String {
			var m:int = I%26;
			var n:int = (I-m)/26;
			var s:String = String.fromCharCode(65+m);
			var t:String = '';
			for (var i:int=0; i!=n+1; i++) t += s;
			return t;
		}

/* Public functions for accessing Extended Alphabet strings. */
		
		//Returns the ith character.
		public static function getChar(I:uint):String {
			return intToString(I);
		}
		
		//Converts char to int.
		public static function getInt(s:String):uint {
			return stringToInt(s);
		}
		
		//Returns characters I, I+1,...,J-1 in any array.
		public static function getArrayChar(I:uint, J:uint):Array {
			if (J <= I) return [];
			var a:Array = [];
			for (var i:int=I; i!=J; i++) a.push(intToString(i));
			return a;
		}
		
		//Go through characters from char1 to char2 and return the Ith one.
		public static function getCharBetween(char1:String,char2:String,I:int):String {
			//First convert char1 and char2 to integers and make u the smaller.
			var u:uint = stringToInt(char1), v:uint = stringToInt(char2);
			if (u>v) { u=u+v; v=u-v; u=u-v; }
			//Now return appropriate character.
			return intToString(u+I);
		}
		
		

	}
}