package sprites {
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	
	public class Triangle extends Sprite {
		
		//Three possibilities for state.
		private const EMPTY:String = "empty";
		private const MARKED:String = "marked";
		private const FULL:String = "full";
		
		private const EMPTY_COL:uint = 0xffffff;
		private const OCCUPIED_COL:uint = 0x666666;
		private const MARKED_COL:uint = 0xffd5df;
		private const OVER_EMPTY_COL:uint = 0x999999;
		private const OVER_OCCUPIED_COL:uint = 0x000000;
		private const OVER_MARKED_COL:uint = 0xffaaaa;
		private const GRID_LINE_THICK:Number = 1;
		private const GRID_LINE_COL:uint = 0x666666;
		
		private var _up:Boolean = false; // True iff vertex points upwards.
		
		private var _occupied:Boolean = false;
		public function get occupied():Boolean {
			return _occupied;
		}
		public function set occupied(value:Boolean):void {
			_occupied = value;
			_state = (value) ? FULL : EMPTY;
			drawTriangle();
		}
		private var _state:String = EMPTY;
		
		private var _over:Boolean = false;
		 
		 
		//Length of side.
		private var _side:Number;
		public function set side(value:Number):void {
			_side = value;
		}
		
		//Vertices.
		private var ux:Number;
		private var uy:Number;
		private var vx:Number;
		private var vy:Number;
		private var wx:Number;
		private var wy:Number; 
		
		//value=true iff pointing up, disabled==true iff disabled
		public function Triangle(value:Boolean) {
			
			_up = value;
		//	_disabled = disabled;
			
		//	if (!disabled) {
			buttonMode = true;
			useHandCursor = true;
		
			addEventListener(MouseEvent.CLICK,clickHandler);
			addEventListener(MouseEvent.MOUSE_OVER,overHandler);
			addEventListener(MouseEvent.MOUSE_OUT,outHandler);
		//	}
		}
		
		public function redraw():void {
			calculateVertices();
			drawTriangle();
		}
		
		//Calculates vertices from side and centre.
		private function calculateVertices():void {
			ux = 0;
			uy = -_side/Math.sqrt(3);
			vx = 0.5*_side;
			vy = 0.5*_side/Math.sqrt(3);
			wx = -0.5*_side;
			wy = vy;
			if (!_up) {
				uy = -uy;
				vy = -vy;
				wy = -wy;
			}
		}
		
		
		private function clickHandler(event:MouseEvent):void {
			switch (_state) {
				case EMPTY:
					_state = MARKED;
					_occupied = false;
					break;
				case MARKED:
					_state = FULL;
					_occupied = true;
					break;
				case FULL:
					_state = EMPTY;
					_occupied = false;
					break;
			}
			drawTriangle();
		}
		
		private function overHandler(event:MouseEvent):void {
			_over = true;
			drawTriangle();
		}

		private function outHandler(event:MouseEvent):void {
			_over = false;
			drawTriangle();
		}
		
		private function drawTriangle():void {
			
			graphics.clear();
			graphics.lineStyle(GRID_LINE_THICK,GRID_LINE_COL,1);
			var col:uint,al:Number;
			switch (_state) {
				case EMPTY:
					col = (_over) ? OVER_EMPTY_COL : EMPTY_COL;
					break;
				case FULL:
					col = (_over) ? OVER_OCCUPIED_COL : OCCUPIED_COL;
					break;
				case MARKED:
					col = (_over) ? OVER_MARKED_COL : MARKED_COL;
					break;
			}

			graphics.beginFill(col,1);
			graphics.moveTo(ux,uy);
			graphics.lineTo(vx,vy);
			graphics.lineTo(wx,wy);
			graphics.lineTo(ux,uy);
			graphics.endFill();
		}
		
		public function clear():void {
			_occupied = false;
			_state = EMPTY;
			drawTriangle();
		}

	}
}