package sprites {
	
	import Data.TriangleData;
	
	import events.BeginRayEvent;
	import events.DestroyRayEvent;
	
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	import util.ExtendedAlphabet;
	
	public class Spot extends Sprite{
		
		private const PI:Number = Math.PI;
		private const EMPTY_COL:uint = 0xffffff; //Unoccupied
		private const FULL_START_COL:uint = 0xffaaaa; //Start of ray.
		private const FULL_END_COL:uint = 0xaaccff; //End of ray.
		private const OVER_COL:uint = 0x000000;
		private const PRESS_COL:uint = 0x666666;
		private const LINE_THICK:Number = 1;
		private const LINE_COL:uint = 0xaaaaaa;
		private const ARROW_COL:Number = 0x000000;

		public static const EMPTY:String = "empty";
		public static const START:String = "start";
		public static const END:String = "end";
		
		//Angle of split line.
		private var _theta:Number = PI*0.5;
		public function set theta(value:Number):void {
			_theta = value;
		}
		
		//Index of the spot round the outside of the hexagon.
		private var _index:int = 0;
		
		private var _overLeft:Boolean = false; 
		private var _overRight:Boolean = false; 
		
		//Three values: EMPTY, START, or END.
		private var _leftOccupied:String = EMPTY;
		private var _rightOccupied:String = EMPTY;
		
		 
		/** After clicking one of the buttons, we must know what is the next triangle. Each
		 *  triangle has an (i,j) location, and we also need a compass direction to know where to go next.
		 */
		//Indices of adjacent triangle. 
		private var I:int = 0;    
		private var J:int = 0;
		//Direction.
		private var _leftDirection:String = "N";    
		private var _rightDirection:String = "N";    
		 
		private var _leftHalf:Sprite = new Sprite();
		private var _rightHalf:Sprite = new Sprite();
		private var _arrow:Shape= new Shape(); 
		
		private var _leftTextField:TextField = new TextField();
		private var _rightTextField:TextField = new TextField();
		
		private var _format:TextFormat = new TextFormat();
		
		//Either number or letter.
		private var _numberLabel:Boolean = true;
		 
		//Spot radius.
		private var _radius:Number = 10;
		public function set radius(value:Number):void {
			_radius = value;
		}


		public function Spot(index:int,i:int,j:int,l:String,r:String,b:Boolean) {
			
			_index = index;
			I = i;
			J = j;
			_leftDirection = l; 
			_rightDirection = r;
			_numberLabel = b;
		//	trace("I = "+I);
		//	trace("J = "+J);
		//	trace("_leftDirection = "+_leftDirection);
		//	trace("_rightDirection = "+_rightDirection);

		//	_leftTextField.border = true;
		//	_rightTextField.border = true;
							
			addChild(_arrow);
			addChild(_leftHalf);
			addChild(_rightHalf);
       		addChild(_leftTextField);
       		addChild(_rightTextField);
       		
			createLabels();
			
			_leftHalf.buttonMode = _rightHalf.buttonMode = true;
			_leftHalf.useHandCursor = _rightHalf.useHandCursor = true;
			
			_leftHalf.addEventListener(MouseEvent.CLICK,clickHandler);
			_leftHalf.addEventListener(MouseEvent.MOUSE_OVER,overHandler);
			_leftHalf.addEventListener(MouseEvent.MOUSE_OUT,outHandler);
			_rightHalf.addEventListener(MouseEvent.CLICK,clickHandler);
			_rightHalf.addEventListener(MouseEvent.MOUSE_OVER,overHandler);
			_rightHalf.addEventListener(MouseEvent.MOUSE_OUT,outHandler);
		}
		
		public function redraw():void {
			
			var col:uint;
			
			//Draw left semicircle.
			col = (_overLeft) ? OVER_COL :
			      (_leftOccupied==EMPTY) ? EMPTY_COL :
			      (_leftOccupied==START) ? FULL_START_COL : FULL_END_COL;
			drawSemiCircle(_leftHalf,_theta,LINE_COL,1,LINE_THICK,col,1);
			
			//Draw right semicircle.
			col = (_overRight) ? OVER_COL :
			      (_rightOccupied==EMPTY) ? EMPTY_COL :
			      (_rightOccupied==START) ? FULL_START_COL : FULL_END_COL;
			drawSemiCircle(_rightHalf,_theta+PI,LINE_COL,1,LINE_THICK,col,1);
			
			if (_overLeft) drawArrow("left");
			else if(_overRight) drawArrow("right");
			else _arrow.graphics.clear();
			
			positionLabels();
		}
		
		//Draw closed semi circle from angle to angle + pi.
		private function drawSemiCircle(s:Sprite,angle:Number,lineCol:uint,lineAl:Number,lineThick:Number,fillCol:uint,fillAl:Number):void {
			s.graphics.clear();
			s.graphics.lineStyle(lineThick,lineCol,lineAl);
			s.graphics.beginFill(fillCol,fillAl);
			s.graphics.moveTo(_radius*Math.cos(angle),_radius*Math.sin(angle));
			for (var i:int=1; i!=101; i++) {
				s.graphics.lineTo(_radius*Math.cos(angle+0.01*PI*i),_radius*Math.sin(angle+0.01*PI*i));		
			}
			s.graphics.lineTo(_radius*Math.cos(angle),_radius*Math.sin(angle));
			s.graphics.endFill();
		}
		
		private function clickHandler(event:MouseEvent):void {
			
			//Need to broadcast click.
			var s:Sprite = Sprite(event.currentTarget);
			if ( (s==_leftHalf && _leftOccupied==EMPTY) || 
			     (s==_rightHalf && _rightOccupied==EMPTY) ) {
				var evt:BeginRayEvent = new BeginRayEvent(BeginRayEvent.BEGIN_RAY);
				var tri:TriangleData = new TriangleData();
				tri.I = I;
				tri.J = J;
				tri.direction = (s==_leftHalf) ? _leftDirection : _rightDirection;
				evt.triangle = tri;
				evt.index = _index;
				evt.side = (s==_leftHalf) ? "left" : "right";
				dispatchEvent(evt);
		    } else {
		    	var ev:DestroyRayEvent = new DestroyRayEvent(DestroyRayEvent.DESTROY_RAY);
		    	trace("s = "+s);
		    	trace("_rightOccupied = "+_rightOccupied);
		    	
		    	if ( (s==_leftHalf && _leftOccupied==START)	) {
		    		ev.startIndex = _index;
		    		ev.startSide = "left";
		    	} else if ( (s==_leftHalf && _leftOccupied==END) ) {
		    		ev.endIndex = _index;
		    		ev.endSide = "left";
		    	} else if ( (s==_rightHalf && _rightOccupied==START) ) {
		    		ev.startIndex = _index;
		    		ev.startSide = "right";
		    	} else if ( (s==_rightHalf && _rightOccupied==END) ) {
		    		
		    		ev.endIndex = _index;
		    		ev.endSide = "right";
		    	}
				dispatchEvent(ev);
		    }
			
		}
		
		private function overHandler(event:MouseEvent):void {
			var s:Sprite = Sprite(event.currentTarget);
			if (s == _leftHalf) {
				_overLeft = true;
			} else {
				_overRight = true;
			}
			redraw();
		}

		private function outHandler(event:MouseEvent):void {
			var s:Sprite = Sprite(event.currentTarget);
			if (s == _leftHalf) {
				_overLeft = false;
			} else {
				_overRight = false;
			}
			redraw();
		}
		
		/**
		 * Arrow functions.
		 */ 
		
		
		//Direction is either left or right.
		private function drawArrow(direction:String):void {
			var startx:Number = -_radius*Math.cos(_theta);
			var starty:Number = -_radius*Math.sin(_theta);
			var unitx:Number,unity:Number;
			var diffx:Number,diffy:Number;
			var px:Number,py:Number;
			var qx:Number,qy:Number;
			
			var length:Number = _radius*4;
			
			if (direction=="right") {
				unitx = -Math.cos(_theta+PI/6);		
				unity = -Math.sin(_theta+PI/6);		
			} else {
				unitx = -Math.cos(_theta-PI/6);		
				unity = -Math.sin(_theta-PI/6);		
			}
			diffx = length*unitx;
			diffy = length*unity;
			px = -_radius*unitx+0.4*_radius*unity;
			py = -_radius*unity-0.4*_radius*unitx;
			qx = -_radius*unitx-0.4*_radius*unity;
			qy = -_radius*unity+0.4*_radius*unitx;
			
			var finishx:Number = diffx+startx;
			var finishy:Number = diffy+starty;
			_arrow.graphics.clear();
			_arrow.graphics.lineStyle(_radius*0.2,ARROW_COL,1);
			_arrow.graphics.moveTo(startx,starty);
			//Shorten finish line a little to give sharp end.
			_arrow.graphics.lineTo(0.9*finishx,0.9*finishy);
			
			//Now draw triangle at end.
			_arrow.graphics.lineStyle(0,ARROW_COL,0);
			_arrow.graphics.beginFill(ARROW_COL,1);
			_arrow.graphics.moveTo(finishx,finishy);
			_arrow.graphics.lineTo(finishx+px,finishy+py);
			_arrow.graphics.lineTo(finishx+qx,finishy+qy);
			_arrow.graphics.lineTo(finishx,finishy);
			_arrow.graphics.endFill();
			
		}
		
		/** 
		 * Label functions.
		 */ 
		
		
		private function createLabels():void {
	       	_format.font = "ArialEmbedded";
	        _format.size = 12;
	        _format.align = "center";
       	    _format.bold = false;
       	    
       	    _leftTextField.embedFonts = true;
       	    _leftTextField.defaultTextFormat = _format;
     		_leftTextField.text = " ";
       		_leftTextField.selectable = false;
       		_leftTextField.mouseEnabled = false;
       	//	_leftTextField.border = true;

       	    _rightTextField.embedFonts = true;
       	    _rightTextField.defaultTextFormat = _format;
      		_rightTextField.text = " ";
       		_rightTextField.selectable = false;
       		_rightTextField.mouseEnabled = false;
       	//	_rightTextField.border = true;
 		}
 		
 		private function positionLabels():void {
 			
 			//Adjust text size.
 			var s:int = int(_radius*0.4)+6;
 			if (s<10) s = 10;
 			
 			_format.size = s;
 			_leftTextField.defaultTextFormat = _format;
 			
 			_leftTextField.width = _leftTextField.height = 1.5*_radius;
 			_rightTextField.width = _rightTextField.height = 1.5*_radius;
 			_rightTextField.defaultTextFormat = _format;
 			_leftTextField.text = _leftTextField.text;
 			_rightTextField.text = _rightTextField.text;
 			
 			
 			//Need to find centre of left and right halves.
 			var lx:Number = 0.5*_radius*Math.cos(_theta+PI*0.5);
 			var ly:Number = 0.5*_radius*Math.sin(_theta+PI*0.5);
 			var rx:Number = 0.5*_radius*Math.cos(_theta-PI*0.5);
 			var ry:Number = 0.5*_radius*Math.sin(_theta-PI*0.5);
 			
 			_leftTextField.x = lx-_leftTextField.width*0.5;
       		_leftTextField.y = ly - _leftTextField.getCharBoundaries(0).y
			                      - _leftTextField.getCharBoundaries(0).height*0.5;
 			
 			_rightTextField.x = rx-_rightTextField.width*0.5;
       		_rightTextField.y = ry - _rightTextField.getCharBoundaries(0).y
			                      - _rightTextField.getCharBoundaries(0).height*0.5;
 		}
 		
		public function clearLabels():void {
			_leftTextField.text = _rightTextField.text = " ";
			_leftOccupied = _rightOccupied = EMPTY;
			redraw();
		}
		
		//Create start label. Variable pos is "start" or "finish".
		public function createLabel(side:String,label:int,pos:String):void {
			var t:String = convertToChar(label);
			if (side=="left") {
				_leftTextField.text = t;
				_leftOccupied = pos;
			} else {
				_rightTextField.text = t;
				_rightOccupied = pos;
			}
			//Have to redraw to shade in properly.
			redraw();
		}
		
		private function convertToChar(m:int):String {
			if (_numberLabel) return (m+1).toString();
			return ExtendedAlphabet.getChar(m);
		}
		
		
		
		
		
		
		
		
		
		
		
		
	}
}