package sprites {
	import flash.display.Sprite;
	
	
	public class HexCover extends Sprite {
		
		private const GRID_LINE_COL:uint = 0x666666;
		private const PI:Number = Math.PI;
		private const ROOT3:Number = Math.sqrt(3);
		
		private var _numTris:uint = 3;
		public function set numTris(value:uint):void {
			_numTris = value;
			drawHexagon();
		}
		private var r:Number;
		
		
		public function HexCover():void {
			mouseEnabled = true;
			
		}
		
		public function redraw(size:Number):void {
			r = HexSprite.SIZE*0.5*size;
			drawHexagon();
		}
		
		private function drawHexagon():void {
			var i:int;
			
			graphics.clear();

			var Ex:Number = r; 
			var Ey:Number = 0;
			var SEx:Number = r*0.5;
			var SEy:Number = r*ROOT3*0.5;
			var SWx:Number = -SEx;
			var SWy:Number = SEy;
			var Wx:Number = -r;
			var Wy:Number = 0;
			var NWx:Number = SWx;
			var NWy:Number = -SEy;
			var NEx:Number = SEx;
			var NEy:Number = NWy;
			

			//Draw hexagon.
			graphics.lineStyle(1,0xffffff,1);
			graphics.beginFill(0xffffff,1);
			graphics.moveTo(Ex,Ey);
			graphics.lineTo(SEx,SEy);
			graphics.lineTo(SWx,SWy);
			graphics.lineTo(Wx,Wy);
			graphics.lineTo(NWx,NWy);
			graphics.lineTo(NEx,NEy);
			graphics.lineTo(Ex,Ey);
			graphics.endFill();
			
			var s:Number = r/_numTris;
			var h:Number = s*0.5*ROOT3;
			
			var px:Number,py:Number;
			var qx:Number,qy:Number;
			
			//Draw the lines.
			graphics.lineStyle(1,GRID_LINE_COL,1);
			for (i=0; i!=2*_numTris+1; i++) {
				px = s*0.5*(Math.abs(_numTris-i)-_numTris);
				graphics.moveTo(NWx+px,NWy+i*h);
				graphics.lineTo(NEx-px,NWy+i*h);
				
				px = (i<=_numTris) ? i*0.5*s : (i-_numTris)*s+0.5*r;
				py = (i<=_numTris) ? -i*h : -r*ROOT3*0.5;
				qx = (i<=_numTris) ? i*s : (i-_numTris)*s*0.5+r;
				qy = (i<=_numTris) ? 0 : - h*(i-_numTris); 
				graphics.moveTo(Wx+px,Wy+py);
				graphics.lineTo(SWx+qx,SWy+qy);
				
				graphics.moveTo(Wx+px,-Wy-py);
				graphics.lineTo(SWx+qx,-SWy-qy);
			}
		}
		

	}
}