package skins {
	
	import mx.skins.ProgrammaticSkin;
	
	public class PlusCustomSkin extends ProgrammaticSkin {		
		
		protected override function updateDisplayList(unscaledWidth:Number,unscaledHeight:Number):void{
			
			super.updateDisplayList(unscaledWidth, unscaledHeight);			
			var backgroundFillColor:Number;			
			var borderColor:Number;
			var crossColor:Number;
			graphics.clear();
			
			switch (name) {
				case "upSkin":
					backgroundFillColor = 0xffffff;
					borderColor = 0x5fbcd3;
					crossColor = 0x5fbcd3;
					break;
				case "overSkin":
					backgroundFillColor = 0x5fbcd3;
					borderColor = 0xffffff;
					crossColor = 0xffffff;
					break;
				case "downSkin":
					backgroundFillColor = 0xffffff;
					borderColor = 0x5fbcd3;
					crossColor = 0x5fbcd3;
					break;
			}
			 
			//Draw box.
			graphics.lineStyle(0,borderColor,0)
			graphics.beginFill(backgroundFillColor);
			graphics.drawRect(0, 0, unscaledWidth, unscaledHeight);
			graphics.endFill();
			
			
			//Draw cross.
			graphics.lineStyle(2,crossColor,1);
			graphics.moveTo(0.5*unscaledWidth,0.25*unscaledWidth);
			graphics.lineTo(0.5*unscaledWidth,0.75*unscaledWidth);
			graphics.moveTo(0.25*unscaledWidth,0.5*unscaledWidth);
			graphics.lineTo(0.75*unscaledWidth,0.5*unscaledWidth);
			
		}
	}
}