﻿/* Sample code for the object you drag */

import Snapper;

class ObjectToSnap extends MovieClip {
	
	var x0:Number;
	var y0:Number;
	
	/* 
	 * These variables are set up in frame 1 of the .fla file in this example. 
	 */
	var snapSet:SnapSet;

	function ObjectToSnap() {
		onReleaseOutside = onRelease;
		x0 = _x;
		y0 = _y;
	}
	
	function onPress():Void {
		this.startDrag();
	}
	
	function onRelease():Void {
		this.stopDrag();
		var snapper:Snapper = snapSet.inside(this);
		if (snapper == null) {
			reset()
		}
		else {
			snapper.snap(this);
		}
	}

	function reset() {
		_x = x0;
		_y = y0;
	}
}