package sprites {
	
    import flash.display.GradientType;
    import flash.display.Shape;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.filters.BevelFilter;
    import flash.filters.BitmapFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BitmapFilterType;
    import flash.filters.DropShadowFilter;
    import flash.geom.Matrix;
    import flash.utils.Timer;
    
    import gs.TweenLite;
    
	public class Dice extends Sprite implements IRandomTool{
		
		//Side length.
		private var _side:Number = 100;
		
		//Colours. First the old grey dice.
		private var _mainSquareColour:Number = 0xaa0000;
		private var _spotColourDark:Number = 0xaaaaaa;
		private var _spotColourLight:Number = 0xeeeeee;
		private var _shadowColour:Number = 0x000000;
		private var _bevelColourLight:Number = 0xcc0000;
		private var _bevelColourDark:Number = 0x990000;
		
		//Alphas
		private var _fillAlpha:Number = 1;
		private var _spotAlpha:Number = 1;

		private var _numberSpins:int = 3;
		 
		private var _spots1:Shape = new Shape();  
		private var _spots2:Shape = new Shape();  
		private var _spots3:Shape = new Shape();  
		private var _spots4:Shape = new Shape();  
		private var _spots5:Shape = new Shape();  
		private var _spots6:Shape = new Shape();  
		
		private var _diceValue:int;
		
		//1 to 6
		private var _value:int;
		public function set value(v:int):void {
			_value = v;
			_spots1.visible = _spots2.visible = _spots3.visible =  
			_spots4.visible = _spots5.visible = _spots6.visible = false;
			getChildAt(v).visible = true;  
		} 
		public function get value():int { return _value; } 
	
		private var timer:Timer = new Timer(100); //tenth of a second.
		
		private var _square:Shape = new Shape();
		
		//Constructor.
		function Dice(v:int):void {
			drawSquare();
			addSpots();
			
			value = v;
			
			addEventListener(MouseEvent.MOUSE_DOWN,mouseDownHandler);
			addEventListener(MouseEvent.MOUSE_UP,mouseUpHandler);
			timer.addEventListener(TimerEvent.TIMER,timerHandler);
			
			addOrRemoveShadow(false);
			
			buttonMode = true;
			useHandCursor = true;
		}
		
/******************************************************
 * Graphics
 */
 
		//Draw the square.
		private function drawSquare():void {
			
			//Draw main square.
			_square.graphics.clear();
			_square.graphics.beginFill(_mainSquareColour,_fillAlpha);
			var s:Number = 0.5*_side;
			_square.graphics.drawRoundRect(-s,-s,_side,_side,s,s);
			_square.graphics.endFill();
			
			addChild(_square);
			var filter:BitmapFilter = bevelFilter();
			_square.filters = [filter];
		}
		
		//Add the text.
		private function addSpots():void {

			createSpot(_spots1,0,0);
			createSpot(_spots2,-_side*0.2,_side*0.2);
			createSpot(_spots2,_side*0.2,-_side*0.2);
			createSpot(_spots3,-_side*0.25,_side*0.25);
			createSpot(_spots3,0,0);
			createSpot(_spots3,_side*0.25,-_side*0.25);
			createSpot(_spots4,-_side*0.2,_side*0.2);
			createSpot(_spots4,-_side*0.2,-_side*0.2);
			createSpot(_spots4,_side*0.2,-_side*0.2);
			createSpot(_spots4,_side*0.2,_side*0.2);
			createSpot(_spots5,_side*0.25,-_side*0.25);
			createSpot(_spots5,-_side*0.25,_side*0.25);
			createSpot(_spots5,-_side*0.25,-_side*0.25);
			createSpot(_spots5,_side*0.25,_side*0.25);
			createSpot(_spots5,0,0);
			createSpot(_spots6,-_side*0.23,-_side*0.25);
			createSpot(_spots6,-_side*0.23,0);
			createSpot(_spots6,-_side*0.23,_side*0.25);
			createSpot(_spots6,_side*0.23,-_side*0.25);
			createSpot(_spots6,_side*0.23,0);
			createSpot(_spots6,_side*0.23,_side*0.25);
			
			
			addChild(_spots1);
			addChild(_spots2);
			addChild(_spots3);
			addChild(_spots4);
			addChild(_spots5);
			addChild(_spots6);

		}
		
		private function createSpot(shape:Shape,X:Number,Y:Number):void {
			var fillType:String = GradientType.RADIAL;
			var cols:Array = [_spotColourDark,_spotColourLight];
       	    var alphas:Array = [1,1];
        	var ratios:Array = [0,255];
        	var matr:Matrix = new Matrix();
        	var spreadMethod:String = SpreadMethod.PAD;

			var r:Number = _side*0.1;
			
			matr.createGradientBox(2*r, 2*r, 0, X-0.8*r, Y-0.8*r);
			shape.graphics.beginGradientFill(fillType,cols,alphas,ratios,matr,spreadMethod);
		 	shape.graphics.drawCircle(X,Y,r);	
			shape.graphics.endFill();
		}
		

		//Drop a shadow.
		private function shadowFilter(value:Number):BitmapFilter {
            var color:Number = _shadowColour,
                angle:Number = 45,
                alpha:Number = 1,
                blurX:Number = 5,
                blurY:Number = 5,
                distance:Number = _side*0.1*value,
                strength:Number = 1.0,
                inner:Boolean = false,
                knockout:Boolean = false,
                quality:Number = BitmapFilterQuality.HIGH;
            return new DropShadowFilter(distance,
                                        angle,
                                        color,
                                        alpha,
                                        blurX,
                                        blurY,
                                        strength,
                                        quality,
                                        inner,
                                        knockout);
        }
        
        private function bevelFilter():BitmapFilter {
            var distance:Number       = 5;
            var angleInDegrees:Number = 45;
            var highlightColor:Number = _bevelColourLight;
            var highlightAlpha:Number = 0.8;
            var shadowColor:Number    = _bevelColourDark;
            var shadowAlpha:Number    = 0.8;
            var blurX:Number          = 5;
            var blurY:Number          = 5;
            var strength:Number       = 5;
            var quality:Number        = BitmapFilterQuality.HIGH;
            var type:String           = BitmapFilterType.INNER;
            var knockout:Boolean      = false;
            return new BevelFilter(distance,
                                   angleInDegrees,
                                   highlightColor,
                                   highlightAlpha,
                                   shadowColor,
                                   shadowAlpha,
                                   blurX,
                                   blurY,
                                   strength,
                                   quality,
                                   type,
                                   knockout);
        }
        
        private function addOrRemoveShadow(add:Boolean):void {
        	var filter:BitmapFilter;
        	if (add) {
				filter = shadowFilter(1.5);
				filters = [filter]; 
        	} else {
        		filter = shadowFilter(0.5);
				filters = [filter]; 
        	}
        }
        
/******************************************************
 * Listener functions
 */        
  		
  		private function mouseDownHandler(event:MouseEvent):void {
  			startDrag(false);
  			addOrRemoveShadow(true);
  		}
  		
  		private function mouseUpHandler(event:MouseEvent):void {
  			stopDrag();	
  			addOrRemoveShadow(false);
  		}
  		
  		public function removeAllEventListeners():void {
  			removeEventListener(MouseEvent.MOUSE_DOWN,mouseDownHandler);
  			removeEventListener(MouseEvent.MOUSE_UP,mouseUpHandler);
  		}
  		      
/******************************************************
 * Action functions
 */        
 
 		public function randomSpin():int {
 			_diceValue = int(6*Math.random())+1; 
 			spinToSlot();
 			return _diceValue;
 		}
 		/* 
 		public function randomSpins(n:int):Array {
 			var i:int;
 			var outcomes:Array = [];
 			for (i=0; i!=n; i++) outcomes[i] = int(6*Math.random())+1; 
 			_diceValue = outcomes[n-1];
 			spinFast(_diceValue);
 			return outcomes;	
 		}
 		 */
 		
 		//Spin once.
		private function spinToSlot():void {
			var theta:Number = _numberSpins*360;
			
			 TweenLite.to(this,2,{rotation:theta,onComplete:finishTween});
			 timer.start();                    
		}
		/* 
		//Spin 100.
		private function spinFast(n:int):void {
			var theta:Number = _numberSpins*540;
			
			TweenLite.to(this,2,{rotation:theta,onComplete:finishTween});
			timer.start();
		}
		 */
		private function timerHandler(event:TimerEvent):void {
			if (timer.currentCount<9) value = int(Math.floor(6*Math.random()))+1;
			else if (timer.currentCount==9) value = _diceValue;
		}
		
		private function finishTween():void {
			if (_value != _diceValue) value = _diceValue;
			timer.reset();
		}
		
		
		
		
		
		
		
	}
	
	
}

