package skins {
	
	import colours.Colours;
	
	import mx.skins.ProgrammaticSkin;
	
	public class ArrowCustomSkin extends ProgrammaticSkin {		
		
		private const ARROW_BUTTON_WIDTH:Number = 22;
		private const P:Number = 0.37;
		
		protected override function updateDisplayList(unscaledWidth:Number,unscaledHeight:Number):void{
			
			super.updateDisplayList(unscaledWidth, unscaledHeight);			
			var backgroundFillColor:Number;			
			var borderColor:Number;
			var arrowColor:Number;
			graphics.clear();

			switch (name) {
				case "popUpOverSkin":
					backgroundFillColor = Colours.COL4;
					borderColor = Colours.COL2;
					arrowColor = Colours.COL1;
					break;
				case "popUpDownSkin":
					backgroundFillColor = Colours.COL1;
					borderColor = Colours.COL2;
					arrowColor = Colours.COL2;
					break;
			}
			
			//Draw left box.
			graphics.lineStyle(1,Colours.COL2,1)
			graphics.beginFill(Colours.COL1);
			graphics.drawRect(0, 0, unscaledWidth-ARROW_BUTTON_WIDTH, unscaledHeight);
			graphics.endFill();
			
			//Draw right box.
			graphics.lineStyle(1,borderColor,1)
			graphics.beginFill(backgroundFillColor);
			graphics.drawRect(unscaledWidth-ARROW_BUTTON_WIDTH,0,ARROW_BUTTON_WIDTH, unscaledHeight);
			graphics.endFill();
			
			//Draw arrow in right box.
			graphics.lineStyle(1,arrowColor,1)
			graphics.beginFill(arrowColor);
			graphics.moveTo(unscaledWidth-(1-P)*ARROW_BUTTON_WIDTH,P*unscaledHeight);
			graphics.lineTo(unscaledWidth-P*ARROW_BUTTON_WIDTH,P*unscaledHeight);
			graphics.lineTo(unscaledWidth-0.5*ARROW_BUTTON_WIDTH,(1-P)*unscaledHeight);
			graphics.lineTo(unscaledWidth-(1-P)*ARROW_BUTTON_WIDTH,P*unscaledHeight);
			graphics.endFill();
			
		}
	}
}