package validators {
	
	import mx.validators.ValidationResult;
	import mx.validators.Validator;

	public class XMLValidator extends Validator {
		private var results:Array;
		[Bindable]
		public var isValid:Boolean = true;
		
		public function XMLValidator() {
			super();
		}
		
		override protected function doValidation(value:Object):Array {
			results = [];
			
			//Generic validation.
			results = super.doValidation(value);
			if(results.length > 0)
				return results;
			
			var xml:XML;
			
			//Check if xml is well formed.
			try {
				xml = new XML(value as String);
				isValid = true;
			}
			catch (e:Error) {
				isValid = false;
				results.push(new ValidationResult(true, "xml", "66", "The XML is not well formed"));
			}
			
			return results;
		}
		
	}
}