package sprites {
	
    import flash.display.GradientType;
    import flash.display.Shape;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.filters.BevelFilter;
    import flash.filters.BitmapFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BitmapFilterType;
    import flash.filters.DropShadowFilter;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    import gs.TweenLite;
    
	public class Spinner extends Sprite implements IRandomTool {
		
		//Embed Arial font.
 		[Embed(source="../assets/Arial.ttf",fontName="ArialBold")] 
		private static const ArialBold:Class;
 		
 		//Embed Arrow.
 		[Embed(source="../assets/Icons.swf", symbol='Arrow')] 
		private static const ARROW:Class;
 		
		//Radius of main disc.
		private var _radius:Number = 65;
		
		//Colours.
		/* 
     	private var _textColour:Number = 0xffffff;
		private var _mainDiscColour:Number = 0xaabbbb;
		private var _lineColour:Number = 0xbbcccc;
		private var _pivotColourDark:Number = 0xaabbbb;
		private var _pivotColourLight:Number = 0xffffff;
		private var _shadowColour:Number = 0x000000;
		private var _bevelColourLight:Number = 0xbbcccc;
		private var _bevelColourDark:Number = 0x99aaaa;
     	 */
     	private var _textColour:Number = 0xffffff;
		private var _mainDiscColour:Number = 0xaa0000;
		private var _lineColour:Number = 0x880000;
		private var _pivotColourDark:Number = 0x666666;
		private var _pivotColourLight:Number = 0xffffff;
		private var _shadowColour:Number = 0x000000;
		private var _bevelColourLight:Number = 0xaa0000;
		private var _bevelColourDark:Number = 0x770000;
     	/* 
		private var _spotColourDark:Number = 0xaaaaaa;
		private var _spotColourLight:Number = 0xeeeeee;
     	 */
     	
		//Size of text.
		private var _fontSize:Number = 15;
		
		//Number of slots.
		private var _slotsCount:int = 6;
		
		//Array length slots of entries in spinner.
		private var _slots:Array;
		public function get slots():Array { return _slots; }
		
		//Alphas.
		private var _fillAlpha:Number = 1;
		private var _lineAlpha:Number = 1;

		private var _lineThickness:Number = 1;
		
		
		private var _disc:Sprite = new Sprite();
		private var _arrow:Sprite = new Sprite();
		private var _pivot:Shape = new Shape();
		
		private var numberSpins:int = 3;
		
		//An array of textfields.
		private var _textEntries:Array = [];
		 
		//Constructor.
		function Spinner(slots:Array):void {
			
			_slotsCount = slots.length;
			_slots = slots;
			
			drawDisc();
			addLabels();
			addArrow();
			addPivot();
			
			addEventListener(MouseEvent.MOUSE_DOWN,mouseDownHandler);
			addEventListener(MouseEvent.MOUSE_UP,mouseUpHandler);
			
			addOrRemoveShadow(false);
			
			buttonMode = true;
			useHandCursor = true;
		}
		
/******************************************************
 * Graphics
 */
 
		//Draw the disc.
		private function drawDisc():void {
			
			//Draw main disc.
			_disc.graphics.clear();
			_disc.graphics.beginFill(_mainDiscColour,_fillAlpha);
			_disc.graphics.drawCircle(0,0,_radius);
			_disc.graphics.endFill();
			
			//Now draw lines on top.
			var theta:Number = 2*Math.PI/_slotsCount;
			_disc.graphics.lineStyle(_lineThickness,_lineColour,_lineAlpha);
			for (var i:int=0; i!=_slotsCount; i++) {
				_disc.graphics.moveTo(0,0);
				_disc.graphics.lineTo(_radius*Math.cos(i*theta),_radius*Math.sin(i*theta));
			}
			
			var filter:BitmapFilter = bevelFilter();
			_disc.filters = [filter];
			_disc.mouseEnabled = false;
			addChild(_disc);
			
		}
		
		//Add the text.
		private function addLabels():void {
	       var format:TextFormat = new TextFormat();
       	   format.font = "ArialBold";
	       format.size = _fontSize;
	       format.align = "center";
       	   format.bold = true;
       	   format.color = _textColour;
       		
       		
       	   var theta:Number = 2*Math.PI/_slotsCount, angle:Number, phi:Number;
       	   var d:Number, a:Number, b:Number, A:Number, B:Number;
       	   	
		   var textField:TextField; 
       	   for (var i:int=0; i!=_slotsCount; i++) {
       	   		
       	   	   textField = new TextField();	
		       textField.embedFonts = true;
		       textField.defaultTextFormat = format;
   	    	   textField.text = _slots[i].toString();	
    	   	   textField.selectable = false;
    	   	   
    	   	   angle = theta*(i+0.5);
    	   	   d = 0.75*_radius;

			   phi = angle+0.5*Math.PI;

			   a = textField.width*0.5,
			   b = textField.getCharBoundaries(0).y
			              +textField.getCharBoundaries(0).height*0.5;
			
			   A = a*Math.cos(phi)-b*Math.sin(phi);
			   B = a*Math.sin(phi)+b*Math.cos(phi);
			
			   textField.rotation = phi*180/Math.PI;
			
			   textField.x = d*Math.cos(angle)-A;
			   textField.y = d*Math.sin(angle)-B;	

			   _textEntries.push(textField);
			   textField.mouseEnabled = false;	
	    	   addChild(textField);
       	   }			

		}
		
		private function addArrow():void {
			
			_arrow.addChild(new ARROW());
			_arrow.alpha = 1;
			
			var filter:BitmapFilter = shadowFilter(1);
			_arrow.filters = [filter]; 
			
			_arrow.mouseEnabled = false;
			addChild(_arrow);
		}
		
		private function addPivot():void {
		
		
			//Data for the counter effect. 
      	    var fillType:String = GradientType.RADIAL;
       	    var alphas:Array = [1,1];
        	var ratios:Array = [0x00, 0xFF];
        	var matr:Matrix = new Matrix();
        	var spreadMethod:String = SpreadMethod.PAD;
		
			var r:Number = _radius*0.06;
			
			var cols:Array = [_pivotColourLight,_pivotColourDark];
			 
			_pivot.graphics.clear();
			matr.createGradientBox(2*r, 2*r, 0, -1.4*r, -1.4*r);
			_pivot.graphics.beginGradientFill(fillType,cols,alphas,ratios,matr,spreadMethod);
		 	_pivot.graphics.drawCircle(0,0,r);	
			_pivot.graphics.endFill();
			
			addChild(_pivot);
		}

		//Drop a shadow.
		private function shadowFilter(value:Number):BitmapFilter {
            var color:Number = _shadowColour,
                angle:Number = 45,
                alpha:Number = 1,
                blurX:Number = 5,
                blurY:Number = 5,
                distance:Number = _radius*0.1*value,
                strength:Number = 1.0,
                inner:Boolean = false,
                knockout:Boolean = false,
                quality:Number = BitmapFilterQuality.HIGH;
            return new DropShadowFilter(distance,
                                        angle,
                                        color,
                                        alpha,
                                        blurX,
                                        blurY,
                                        strength,
                                        quality,
                                        inner,
                                        knockout);
        }
        
         private function bevelFilter():BitmapFilter {
            var distance:Number       = 5;
            var angleInDegrees:Number = 45;
            var highlightColor:Number = _bevelColourLight;
            var highlightAlpha:Number = 0.8;
            var shadowColor:Number    = _bevelColourDark;
            var shadowAlpha:Number    = 0.8;
            var blurX:Number          = 5;
            var blurY:Number          = 5;
            var strength:Number       = 5;
            var quality:Number        = BitmapFilterQuality.HIGH;
            var type:String           = BitmapFilterType.INNER;
            var knockout:Boolean      = false;
            return new BevelFilter(distance,
                                   angleInDegrees,
                                   highlightColor,
                                   highlightAlpha,
                                   shadowColor,
                                   shadowAlpha,
                                   blurX,
                                   blurY,
                                   strength,
                                   quality,
                                   type,
                                   knockout);
        }
/* 		
		private function glowFilter():BitmapFilter {
			var gradientGlow:GradientGlowFilter = new GradientGlowFilter();
			gradientGlow.distance = 0;
			gradientGlow.angle = 45;
			gradientGlow.colors = [0x000000, 0xFF0000];
			gradientGlow.alphas = [0, 1];
			gradientGlow.ratios = [0, 255];
			gradientGlow.blurX = 10;
			gradientGlow.blurY = 10;
			gradientGlow.strength = 2;
			gradientGlow.quality = BitmapFilterQuality.HIGH;
			gradientGlow.type = BitmapFilterType.OUTER;

			return gradientGlow;			
			
		}
		
 */        
        
        private function addOrRemoveShadow(add:Boolean):void {
        	var filter:BitmapFilter;
        	if (add) {
				filter = shadowFilter(1.5);
				filters = [filter]; 
        	} else {
				filter = shadowFilter(0.5);
				filters = [filter]; 
        	}
        }
        
/******************************************************
 * Listener functions
 */        
  		
  		private function mouseDownHandler(event:MouseEvent):void {
  			startDrag(false);
  			addOrRemoveShadow(true);
  		}
  		
  		private function mouseUpHandler(event:MouseEvent):void {
  			stopDrag();	
  			addOrRemoveShadow(false);
  		}
  		
  		public function removeAllEventListeners():void {
  			removeEventListener(MouseEvent.MOUSE_DOWN,mouseDownHandler);
  			removeEventListener(MouseEvent.MOUSE_UP,mouseUpHandler);
  		}
  		      
/******************************************************
 * Action functions
 */        
 
 		public function randomSpin():int {
 			//First choose a random slot.
 			var n:int = int(_slotsCount*Math.random()); 
 			spinToSlot(n);
 			return int(_slots[n]);
 		}
 		/* 
 		public function randomSpins(m:int):Array {
 			var i:int;
 			var slotChoice:int;
 			var outcomes:Array = [];
 			for (i=0; i!=m; i++) {
 				slotChoice = int(_slotsCount*Math.random());
 				outcomes[i] = int(_slots[slotChoice]); 
 			}
 			spinFast(slotChoice);
 			return outcomes;	
 		}
  */
 		//Spin once.
		private function spinToSlot(n:int):void {
			var theta:Number = numberSpins*360+(n+0.5)*360/_slotsCount;
			
			TweenLite.to(_arrow,2,{rotation:theta});
		}
		/* 
		//Spin 100.
		private function spinFast(n:int):void {
			var theta:Number = 1.5*numberSpins*360+(n+0.5)*360/_slotsCount;
			
			TweenLite.to(_arrow,2,{rotation:theta});
		}
		 */
		public function newTextEntries(a:Array):void {
			var L:int = _textEntries.length;
			if (a.length != L) return;
			for (var i:int=0; i!=L; i++) {
				_textEntries[i].text = a[i].toString();
			}
		}
		
		
		
		
		
	}
	
	
}

