package skins {
	
	import colours.Colours;
	
	import mx.skins.ProgrammaticSkin;
	
	public class PlusCustomSkin extends ProgrammaticSkin {		
		
		protected override function updateDisplayList(unscaledWidth:Number,unscaledHeight:Number):void{
			
			super.updateDisplayList(unscaledWidth, unscaledHeight);			
			var backgroundFillColor:Number;			
			var borderColor:Number;
			var crossColor:Number;
			graphics.clear();
			
			switch (name) {
				case "upSkin":
					backgroundFillColor = Colours.COL1;
					borderColor = Colours.COL2;
					crossColor = Colours.COL2;
					break;
				case "overSkin":
					backgroundFillColor = Colours.COL4;
					borderColor = Colours.COL2;
					crossColor = Colours.COL1;
					break;
				case "downSkin":
					backgroundFillColor = Colours.COL1;
					borderColor = Colours.COL2;
					crossColor = Colours.COL2;
					break;
			}
			
			//Draw box.
			graphics.lineStyle(1,borderColor,1)
			graphics.beginFill(backgroundFillColor);
			graphics.drawRect(0, 0, unscaledWidth, unscaledHeight);
			graphics.endFill();
			
			
			//Draw cross.
			graphics.lineStyle(1,crossColor,1);
			graphics.moveTo(0.5*unscaledWidth,0.25*unscaledWidth);
			graphics.lineTo(0.5*unscaledWidth,0.75*unscaledWidth);
			graphics.moveTo(0.25*unscaledWidth,0.5*unscaledWidth);
			graphics.lineTo(0.75*unscaledWidth,0.5*unscaledWidth);
			
		}
	}
}