package skins {
	
	import colours.Colours;
	
	import mx.skins.ProgrammaticSkin;
	
	public class CustomSkin extends ProgrammaticSkin {		
		
		protected override function updateDisplayList(unscaledWidth:Number,unscaledHeight:Number):void{
			
			super.updateDisplayList(unscaledWidth, unscaledHeight);			
			var backgroundFillColor:Number;			
			var borderColor:Number;
			graphics.clear();

			switch (name) {
				case "upSkin":
					backgroundFillColor = Colours.COL1;
					borderColor = Colours.COL2;
					break;
				case "overSkin":
					backgroundFillColor = Colours.COL4;
					borderColor = Colours.COL2;
					break;
				case "downSkin":
					backgroundFillColor = Colours.COL1;
					borderColor = Colours.COL2;
					break;
				case "disabledSkin":
					backgroundFillColor = 0x00441b;
					borderColor = 0x238B45;
					break;
			}
			
			graphics.lineStyle(1,borderColor,1)
			graphics.beginFill(backgroundFillColor);
			graphics.drawRect(0, 0, unscaledWidth, unscaledHeight);
			graphics.endFill();
			/* 
			if(name != "downSkin") {	            
	            filters = [new DropShadowFilter(4, 45,0x000000,.2)];
			}
			 */
		}
	}
}