package renderers {
	import mx.charts.AxisLabel;
	import mx.controls.Label;
	
	import mx.controls.Button;
	
	
	public class CustomLabelRenderer extends Button  {
		
		public function CustomLabelRenderer(){ 
			setStyle("paddingTop",0);
			setStyle("paddingBottom",0);
			setStyle("paddingLeft",3);
			setStyle("paddingRight",3);
			setStyle("fontSize",14);
			setStyle("fontWeight","normal");
			setStyle("fontFamily","ArialEmbedded");
			
			toggle = true;
	        useHandCursor = true;
	        buttonMode = true;
	        styleName = "visibilityButton";
		}
		
		private var _data:AxisLabel;

		override public function get data():Object { return _data; }
		
		override public function set data(value:Object):void {
			if(value != null) {
				_data = value as AxisLabel;
				label = _data.text;
			}
		}
		
		override protected function updateDisplayList(w:Number,h:Number):void {
			super.updateDisplayList(w,h);
			textField.alpha = (selected) ? 0.4 : 1;
		}

	}
}