package renderers {

	import flash.geom.Rectangle;
	
	import mx.charts.ChartItem;
	import mx.charts.series.items.BarSeriesItem;
	import mx.controls.Label;
	import mx.core.IDataRenderer;
	import mx.core.UIComponent;
	
	public class BarSeriesLabelRenderer extends UIComponent implements IDataRenderer {
		
		
		private var _label:Label;
		private static var fills:Array = [];
		
		public function BarSeriesLabelRenderer():void { 
			super();

			_label = new Label();
			addChild(_label);
			_label.setStyle("color",0xffffff);
			_label.setStyle("fontFamily","ArialEmbedded");

		}

		private var _chartItem:ChartItem;
		public function get data():Object{
			return _chartItem;
		}
		public function set data(value:Object):void {
			if (_chartItem == value) return;
			_chartItem = ChartItem(value);
			if(_chartItem != null) {
				var b:BarSeriesItem = BarSeriesItem(_chartItem);
				var m:Number;
				if (isNaN(b.xNumber)) {
					_label.text = "";	
				} else if (b.minNumber) {
					m = (b.xNumber > b.minNumber) ? b.xNumber-b.minNumber : b.minNumber-b.xNumber;
					_label.text = m.toString();
				} else {
					m = (b.xNumber>0) ? b.xNumber : -b.xNumber;
					_label.text = m.toString();
				}
			}
		}


		override protected function updateDisplayList(w:Number,h:Number):void{
			
			super.updateDisplayList(w,h);
			
			fills = getStyle("fills");

			var fill:uint = (_chartItem == null)? 0:fills[_chartItem.index %fills.length];
		//	var rc:Rectangle = new Rectangle(0, 0, width , height );
			var rc:Rectangle = new Rectangle(0, 0, w , h );
			
			graphics.clear();
			graphics.moveTo(rc.left,rc.top);
			graphics.beginFill(fill);
			graphics.lineTo(rc.right,rc.top);		
			graphics.lineTo(rc.right,rc.bottom);
			graphics.lineTo(rc.left,rc.bottom);
			graphics.lineTo(rc.left,rc.top);
			graphics.endFill();
			
			//Now position label.
			if (_label.text.length ==1) _label.text = " "+_label.text;
			
			var chartWidth:Number = parent.width;

			var W:Number = _label.getExplicitOrMeasuredWidth();
			var H:Number = _label.getExplicitOrMeasuredHeight();
				
			_label.setActualSize(W,H);
			
			
			var absw:Number = (w>0) ? w : -w;
			_label.visible = (W<absw && H<h);
			
			if (w<=chartWidth) { //bar fully visible
				if (w>0) _label.move(w-W,(h-H)*0.5);
				else if (w<0) _label.move(w,(h-H)*0.5);
			} else { //bar goes off screen
				
				/* No longer want this; no bars should go off screen.
				   I'm still getting triangles for borderline cases, and I don't want them.
				
				//Draw white triangle.
				graphics.beginFill(0xffffff);
				graphics.moveTo(chartWidth-2,h*0.5);
				graphics.lineTo(chartWidth-10,h*0.5-5);
				graphics.lineTo(chartWidth-10,h*0.5+5);
				graphics.lineTo(chartWidth-2,h*0.5);
				graphics.endFill();
				_label.move(chartWidth-W-10,(h-H)*0.5);	
				
				*/
			}

		}


	}
}