/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;

public class ModellingSolutions
extends PApplet {
    float t = 0.0f;
    float dt = 0.5f;
    float px1 = 0.0f;
    float py1 = 0.0f;
    float r1 = 10.0f;
    float px2 = 0.0f;
    float py2 = 0.0f;
    float r2 = 10.0f;
    float m = 1.0f;
    float k = 0.01f;
    float g = 0.5f;
    float p;
    float q = this.p = 13.2f;
    float angle;
    float fade = 32.0f;
    HScrollbar hsDrag;
    HScrollbar hsAngle;
    PFont fontA;

    public void setup() {
        this.size(700, 450);
        this.background(0);
        this.noStroke();
        this.frameRate(30.0f);
        this.smooth();
        this.fontA = this.loadFont("CourierNew36.vlw");
        this.fill(220.0f, 255.0f, 255.0f);
        this.textFont(this.fontA, 18.0f);
        this.textAlign(3);
        this.text("Drag", (float)(this.width / 2), 20.0f);
        this.text("Angle", (float)(this.width / 2), 50.0f);
        this.fill(255.0f, 220.0f, 22.0f);
        this.textFont(this.fontA, 16.0f);
        this.textAlign(37);
        this.text("Low", 10.0f, 20.0f);
        this.text("0\u00b0", 10.0f, 50.0f);
        this.textAlign(39);
        this.text("High", (float)(this.width - 10), 20.0f);
        this.text("90\u00b0", (float)(this.width - 10), 50.0f);
        this.hsDrag = new HScrollbar(0, 30, this.width, 10, 16);
        this.hsAngle = new HScrollbar(0, 60, this.width, 10, 16);
    }

    public void draw() {
        this.px1 = this.p * this.t;
        this.py1 = this.q * this.t - 0.5f * this.g * this.t * this.t;
        this.px2 = this.m / this.k * this.p * (1.0f - ModellingSolutions.exp(-this.k * this.t / this.m));
        this.py2 = this.m / this.k * (this.m / this.k) * this.g + this.m / this.k * this.q - (this.m / this.k * (this.m / this.k) * this.g + this.m / this.k * this.q) * ModellingSolutions.exp(-this.k * this.t / this.m) - this.m * this.g * this.t / this.k;
        if (this.py1 >= 0.0f) {
            this.t += this.dt;
        } else {
            this.t = 0.0f;
            this.k = 0.001f + 0.02f * this.hsDrag.getPos() / (float)this.width;
            this.angle = 1.5707964f * this.hsAngle.getPos() / (float)this.width;
            this.p = 18.67f * ModellingSolutions.cos(this.angle);
            this.q = 18.67f * ModellingSolutions.sin(this.angle);
        }
        this.fill(0, this.fade);
        this.rect(0.0f, 80.0f, this.width, this.height - 80);
        this.fill(175.0f, 175.0f, 200.0f);
        this.ellipse(this.px1, (float)this.height - this.py1, this.r1, this.r1);
        this.fill(125.0f, 150.0f, 125.0f);
        this.ellipse(this.px2, (float)this.height - this.py2, this.r2, this.r2);
        this.hsDrag.update();
        this.hsDrag.display();
        this.hsAngle.update();
        this.hsAngle.display();
    }

    public static void main(String[] stringArray) {
        PApplet.main(new String[]{"ModellingSolutions"});
    }

    class HScrollbar {
        int swidth;
        int sheight;
        int xpos;
        int ypos;
        float spos;
        float newspos;
        int sposMin;
        int sposMax;
        int loose;
        boolean over;
        boolean locked;
        float ratio;

        HScrollbar(int n, int n2, int n3, int n4, int n5) {
            this.swidth = n3;
            this.sheight = n4;
            int n6 = n3 - n4;
            this.ratio = (float)n3 / (float)n6;
            this.xpos = n;
            this.ypos = n2 - this.sheight / 2;
            this.newspos = this.spos = (float)(this.xpos + this.swidth / 2 - this.sheight / 2);
            this.sposMin = this.xpos;
            this.sposMax = this.xpos + this.swidth - this.sheight;
            this.loose = n5;
        }

        public void update() {
            this.over = this.over();
            if (ModellingSolutions.this.mousePressed && this.over) {
                this.locked = true;
            }
            if (!ModellingSolutions.this.mousePressed) {
                this.locked = false;
            }
            if (this.locked) {
                this.newspos = this.constrain(ModellingSolutions.this.mouseX - this.sheight / 2, this.sposMin, this.sposMax);
            }
            if (ModellingSolutions.abs(this.newspos - this.spos) > 1.0f) {
                this.spos += (this.newspos - this.spos) / (float)this.loose;
            }
        }

        public int constrain(int n, int n2, int n3) {
            return ModellingSolutions.min(ModellingSolutions.max(n, n2), n3);
        }

        public boolean over() {
            return ModellingSolutions.this.mouseX > this.xpos && ModellingSolutions.this.mouseX < this.xpos + this.swidth && ModellingSolutions.this.mouseY > this.ypos && ModellingSolutions.this.mouseY < this.ypos + this.sheight;
        }

        public void display() {
            ModellingSolutions.this.fill(255);
            ModellingSolutions.this.rect(this.xpos, this.ypos, this.swidth, this.sheight);
            if (this.over || this.locked) {
                ModellingSolutions.this.fill(153.0f, 102.0f, 0.0f);
            } else {
                ModellingSolutions.this.fill(102.0f, 102.0f, 102.0f);
            }
            ModellingSolutions.this.rect(this.spos, this.ypos, this.sheight, this.sheight);
        }

        public float getPos() {
            return this.spos * this.ratio;
        }
    }
}

