package numberTheory {
	
	//Takes a real number and works out its continued fraction expansion.
	public class Convergents {
		
		public var b:Array; //The usual coefficients b_n.
		public var P:Array; //The usual numerators P_n.
		public var Q:Array; //The usual denominators Q_n.
		public const length:int = 20; //Number of b_ns.
		
		function Convergents():void {
			b = new Array(length);
			P = new Array(length);
			Q = new Array(length);
		}
		
		//Evaluate b, P, and Q.
		public function evaluate(r:Number):void {
			for (var i:int = 0; i!=length; i++) {
				b[i] = P[i] = Q[i] = null;
			}
		
			//Current value of cf.
			var s:Number = r;
			var breakLoop:Boolean = false;
			for (var j:int = 0; j!=length; j++) {
				if (Math.floor(s)+1-s<0.0000001) {
					b[j] = Math.floor(s)+1;
					breakLoop = true;
				} else if (s-Math.floor(s)<0.0000001) {
					b[j] = Math.floor(s);
					breakLoop = true;
				} else {
					b[j] = Math.floor(s);
					s = 1/(s-b[j])
				}
				if (j==0) { P[0]=b[0]; Q[0]=1; } 
				else if (j==1) { P[1]=b[0]*b[1]+1; Q[1]=b[1]; }
				else {
					P[j] = b[j]*P[j-1]+P[j-2];
					Q[j] = b[j]*Q[j-1]+Q[j-2];
				}
				if (breakLoop) break;
			} 
			trace(P);
		}
		
		
	}
}