//
// Create a menu from the imsmanifest
//
var xmlDoc;
var activeItemIndex = -1;
var resources=[];
var linkIndex = 0;
var links=[]

function readManifest() {
	loadXML("imsmanifest.xml");
	activateItem(0);
}

function loadXML(url) {
  // load xml file
  // code for IE
  if (window.ActiveXObject) {
    xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
    xmlDoc.async=true;
    xmlDoc.onreadystatechange = processReqChange;
    xmlDoc.load(url);
	return;
  }
  // code for Mozilla, etc.
  var oXML = new XMLHttpRequest();
  if (oXML != null) {
    var oXML=new XMLHttpRequest();
    oXML.open("GET","./"+url,false);
    oXML.send(null);
    xmlDoc=oXML.responseXML;
    oXML.onload=updateMenu();
	return;
  }
  // old code for Mozilla which fails in Safari, possibly in Opera too
  /*
	if (document.implementation && document.implementation.createDocument) {
		xmlDoc= document.implementation.createDocument("","",null);
		xmlDoc.onload=updateMenu;
		xmlDoc.load(url);
	}
  */
    alert('Sorry, your browser is incompatible with this page.\n Try Mozilla Firefox or Safari or Opera 8+ or Internet Explorer v6+');
}

function processReqChange() {
    // only if xmlDoc shows "loaded"
    if (xmlDoc.readyState == 4) {
		updateMenu();
	}
}

function updateMenu() {
	readResources();
	writeOrganizations();
	activateItem(0);
	//traceLinks();
	//document.getElementById("scormframe").className="narrow";
}

/*
function writeTitle() {
	var packageName = document.getElementById("packageName");
}
*/

function writeOrganizations() {
	var html = document.getElementById("base");
	//
	// Note: following code unlikely to be correct for multiple organizations
	//
	var orgNodes = xmlDoc.getElementsByTagName("organization");
	for(i = 0; i < orgNodes.length; i++) { 
		var orgNode = orgNodes.item(i);
		orgNode.normalize();
		if(orgNode != null) {
			var ulTop = document.createElement("ul");
			//html.replaceChild(ulTop,html.firstChild); 
			appendCollection(ulTop, orgNode);
		}
		//alert(ulTop.innerHTML);
	}
	html.innerHTML = ulTop.innerHTML
}

function getNodeTitle(node) {
	for(var n=node.firstChild; n != null; n = n.nextSibling) {
		if(n.nodeName == "title") {
			return n;
		}
	}
	return null;
}

function activateItem(index) {
	if(index < 0) {
		index = 0;
	}
	else if(index >= links.length) {
		index = links.length-1;
	}
	var html = document.getElementById("scormframe");
	activeItemIndex = index;
	//html.innerHTML='<iframe name="scormframe" id="scormframe" src="' + links[index] + '"></iframe>';
	html.src = links[index];
	if(document.getElementById("menu").className=="hidden") {
		html.className="wide";
	}
}

function homeItem() {
	//alert("activeItemIndex = "+activeItemIndex);
	activateItem(0);
}

function nextItem() {
	//alert("activeItemIndex = "+activeItemIndex);
	activateItem(++activeItemIndex);
}

function previousItem() {
	activateItem(--activeItemIndex);
}

function traceLinks() {
	s="";
	for(var i = 0; i < linkIndex; i++) {
		s += links[i] + "\n";
	}
	alert(s);
}

function hideMenu() {
	document.getElementById("fullMenu").className="hide";
	document.getElementById("linkToMenu").className="show";
	document.getElementById("menu").className="hidden";
	document.getElementById("scormframe").className="wide";
}
function showMenu() {
	document.getElementById("fullMenu").className="show";
	document.getElementById("linkToMenu").className="hide";
	document.getElementById("menu").className="visible";
	document.getElementById("scormframe").className="narrow";
}

var tabindex = 1;
function appendCollection(html, xml) {
	var titleNode = getNodeTitle(xml);
	if(titleNode == null) {
		return;
	}
	var identifier = xml.getAttribute("identifier");
	//alert("appendCollection " + xml.nodeName + "[" + identifier + "]");
	var isvisible = xml.getAttribute("isvisible");
	var idref = xml.getAttribute("identifierref");
	var resource = null;
	if(idref != null && idref != "") {
		resource = resources[idref];
		//alert("linking to " + resource);
	}
	/*
	if(resource != null) {
		// this links to an item
		var li = document.createElement("li");
		li.setAttribute("class", "basic");
		li.setAttribute("onfocus", "liFocusEvent(event);"); // all except IE
		li.setAttribute("onfocusin", "liFocusEvent(event);"); // IE only
		li.setAttribute("onblur", "liFocusEvent(event);"); // all except IE
		li.setAttribute("onfocusout", "liFocusEvent(event);"); // IE only
		li.setAttribute("tabindex", tabindex++);
		appendItem(li, xml, titleNode);
		html.appendChild(li);
	}
	*/
	/*else*/  {
		// this is a collection of items
		if(isvisible != "false") {
			var li = document.createElement("li");
			var uli = document.createElement("ul");
			li.setAttribute("class", "col");
			if(resource == null) {
				var text = document.createTextNode(titleNode.firstChild.nodeValue);
				li.appendChild(text);
			}
			if(resource != null) {
				li.setAttribute("class", "col");
				appendItem(li, xml, titleNode);
			}
			//alert(titleNode.firstChild.nodeValue + " " + titleNode.nextSibling.nodeName);
			uli.setAttribute("class", "subexp");
			li.appendChild(uli);
			var isCollection = false;
			for(var node = titleNode.nextSibling; node != null; node = node.nextSibling) {
				if(node.nodeName == "item" && (node.getAttribute("isvisible")!="false")) {
					appendCollection(uli, node);
					isCollection = true;
				}
			}
			if(!isCollection) {
				li.setAttribute("class", "basic");
			}
			html.appendChild(li);
		}
	}
}

function appendItem(html, xml, titleNode) {
    // xml = <item identifier="ITEM-4725-clue" isvisible="true" identifierref="RES-MMP-ID-4725-clue">
	var identifier = xml.getAttribute("identifier");
	var isvisible = xml.getAttribute("isvisible");
	var idref = xml.getAttribute("identifierref");
	var resource;
	var href="";
	var a;
	var leaf;
	if(idref != null && idref != "") {
		//alert(idref);
		href = resources[idref];
		a = document.createElement("a");
		//a.setAttribute("href", href);
		a.setAttribute("href", '#');
		a.setAttribute("onclick", "activateItem("+linkIndex+")");
		//a.setAttribute("target", "scormframe");
		var text = document.createTextNode(titleNode.firstChild.nodeValue);
		a.appendChild(text);
		var div=document.createElement("div");
		div.setAttribute("title",href);
		div.appendChild(a);
		html.appendChild(div);
		links[linkIndex++] = href;
	}
	else {
		var text = document.createTextNode(titleNode.firstChild.nodeValue);
		html.appendChild(text);
		appendCollection(html, titleNode.nextSibling); 
	}
}

function readResources() {
	var resElements = xmlDoc.getElementsByTagName("resource");
	for(var i = 0; i < resElements.length; i++) {
		var r = resElements.item(i);
		var id = r.getAttribute("identifier");
		if(id != null && id != "") {
			var href = r.getAttribute("href");
			resources[id] = href;
		}
	}
}

