
import com.yahoo.maps.api.core.location.LatLon;

//This class contains different methods for distributing the tigers.

//This is the function called to generate a new latitude and longitude.
private function distLatLon():LatLon {
	
	//We use a different function to determine the distribution for each new lair.
	switch (dist) {
		case 1:
			return uniform();
			break;
		case 2:
			return uniformWedge();
			break;
		case 3:
			return normal();
			break;	
		case 4:
			return spiral();
			break;		
		default:
			break;	
	}
 	return new LatLon(0,0);	
}

//Initialisation function for the distributions (e.g., generate random mean and variance).
private function distInit():void {

	//First return to the central african republic.
	_address = new Address("CENTRAL AFRICAN REPUBLIC");
	_address.addEventListener(GeocoderEvent.GEOCODER_SUCCESS, geocodeOK);
	_address.geocode();
	
	//Random location of lair determined in geocodeOK.
	
}

//We return to a particular location and generate some data for that place.
private function geocodeOK(event:GeocoderEvent):void {
	var result:GeocoderResult = _address.geocoderResultSet.firstResult;
	_yahooMap.zoomLevel = result.zoomLevel-1;
	_yahooMap.centerLatLon = result.latlon;

	var bounds:BoundingBox = _yahooMap.getMapBounds();
	var southwest:LatLon = bounds.southwest;
	var northeast:LatLon = bounds.northeast;
				
	var lonSpan:Number = northeast.lon - southwest.lon;
	var latSpan:Number = northeast.lat - southwest.lat;
				
	//The upper and lower bounds for the radius.
	radiusUpMax = Math.min(lonSpan,latSpan)/2;
	radiusUpMin = Math.min(lonSpan,latSpan)/50;
								
	//Lair can be a random location on the map.
	lair = new LatLon(southwest.lat + latSpan*Math.random(), southwest.lon + lonSpan*Math.random());
							
	latScale = Math.cos(southwest.latRadians);
	
	distParameters();
}

//Create the distribution parameters.
private function distParameters():void {

	//Now determine upper and lower bounds for distance of tiger from lair.
	//Upper one can be a random number between 0 and radiusUpMax.
	radiusUp = radiusUpMin+Math.random()*(radiusUpMax-radiusUpMin);
	//Lower one can be a random number between 0 and radiusUp.
	radiusLow = Math.random()*radiusUp;
	
	//Determine wedge data. Both random numbers in [0,2\pi].
	wedgeStart = Math.random()*2*Math.PI;
	wedgeAngle = Math.random()*2*Math.PI; 
		
	//For option D, initialise prevlatlon.
	prevlatlon = lair;	
}


//Option 1 is to return uniform distribution.
private function uniform():LatLon {
	
	//Now, r must be a random number beteen radiusLow and radiusUp.
	var r:Number = radiusLow+(radiusUp-radiusLow)*Math.random();
	var theta:Number = Math.random()*2*Math.PI;
		
	var latlon:LatLon = new LatLon(lair.lat + r*Math.cos(theta)*latScale, lair.lon + r*Math.sin(theta));
	return latlon;	
}

//Option 2 is to return uniform distribution, but within a wedge.
private function uniformWedge():LatLon {
	
	//Now, r must be a random number beteen radiusLow and radiusUp.
	var r:Number = radiusLow+(radiusUp-radiusLow)*Math.random();
	
	//Theta a random number within the wedge angle.
	var theta:Number = wedgeStart+Math.random()*wedgeAngle;
		
	var latlon:LatLon = new LatLon(lair.lat + r*Math.cos(theta)*latScale, lair.lon + r*Math.sin(theta));
	return latlon;	
}

//Option 3 is to return normal disribution on radius.
private function normal():LatLon {
	
	
	//Recall Box-Muller argument; given two independent random variables U and V uniformly distributed in [0,1],
	//the two variables X=\sqrt{-2log(U)}cos(2\pi V) and X=\sqrt{-2log(U)}sin(2\pi V) are normally distributed with 
	//mean 0 and variance 1.
	 
	var s:Number = Math.abs(Math.sqrt(-2*Math.log(Math.random()))*Math.cos(2*Math.PI*Math.random()));
	//There is a risk of getting extraordinarily large readings occasionally. Very low though.
	//The quantity s is a random sample from N(0,1). If we multiply by radiusUp then we get a random sample
	//from N(0,radiusUp^2).
	var r:Number = radiusUp*s;
	var theta:Number = Math.random()*2*Math.PI;
		
	var latlon:LatLon = new LatLon(lair.lat + r*Math.cos(theta)*latScale, lair.lon + r*Math.sin(theta));
	return latlon;	
}


//Option 4 is the peculiar one. Uniform random distance and uniform random angle, 
//relative to previous guess. Thus we need to store previous latlon.
private function spiral():LatLon {
	
	//Now, r must be a random number beteen radiusLow and radiusUp.
	var r:Number = radiusLow+(radiusUp-radiusLow)*Math.random();
	var theta:Number = Math.random()*2*Math.PI;
		
	var latlon:LatLon = new LatLon(prevlatlon.lat + r*Math.cos(theta)*latScale, prevlatlon.lon + r*Math.sin(theta));
	prevlatlon = latlon
	return latlon;	
}