package com.yahoo.maps.markers
{
	import com.yahoo.maps.api.markers.Marker;
	import com.yahoo.maps.api.markers.events.MarkerEvent;
	
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.text.TextField;
	import flash.text.TextFormat;

	public class CustomImageMarker extends Marker
	{
		protected var _url:String;
		protected var _loader:Loader;
		protected var _textField:TextField;
		
		public function CustomImageMarker(url:String)
		{
			super();
			_url = url;
			init();
		}
		
		private function init():void 
		{
			// create a new loader, and load the URL provided.
			_loader = new Loader();
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, handleLoadComplete);
			_loader.load(new URLRequest(_url), new LoaderContext(true));
			this.addChild(_loader);
			
			// create a new text field.
			_textField = new TextField();
			_textField.cacheAsBitmap = true;
			_textField.defaultTextFormat = new TextFormat("Arial", 20, 0xFFFFFF, true);
			this.addChild(_textField);
			
			// listen for the MARKER_GEOCODE_SUCCESS event, we'll be setting the marker text to the geocoded address.
			this.addEventListener(MarkerEvent.MARKER_GEOCODE_SUCCESS, handleMarkerGeocodeSuccess);
		}
		
		private function setTitleText(text:String):void
		{
			_textField.text = text;
			_textField.width = _textField.textWidth+5;
			_textField.height = _textField.textHeight+5;
			
			_textField.x = 10
			_textField.y = -(_textField.height)/2;
		}
		
		private function handleLoadComplete(event:Event):void 
		{
			_loader.x = -(_loader.width)/2;
			_loader.y = -(_loader.height)/2;
		}
		
		private function handleMarkerGeocodeSuccess(event:MarkerEvent):void
		{
			// get the geocoder result, and its full address string
			var title:String = this.address.geocoderResultSet.firstResult.getLineAddress();
			setTitleText(title);
		}
		
	}
}