﻿import mx.styles.CSSStyleDeclaration;
import mx.core.View;
import BaseExperiment;
import Experiment;
import ScrolledLogger;
import Spinners;

var experiment:Experiment;

var buttonLock:Boolean = false;

initAccordion();
initResults();

//Count the number of spins.
var spinCount:Number = 0;

_global.styles.AccordionHeader.setStyle("fontSize", 14);
_global.styles.Accordion.setStyle("openDuration", 200);
_global.styles.Accordion.setStyle("headerHeight" , 22);
_global.styles.Accordion.setStyle("borderColor" , undefined);
_global.styles.Accordion.setStyle("backgroundColor" , undefined);
_global.styles.Accordion.setStyle("borderStyle" , "none"); 

function initAccordion() {
	
	accordion.setStyle("themeColor", 0x0000FF);
	accordion.setStyle("embedFonts",true); 
	accordion.setStyle("fontSize", 14); 

	accordion.createChild("Spinners", "spinners", {label:"Spinners"});
	accordion["spinners"].setStyle("themeColor",0xcc0000);
	//accordion["spinners"]["spinnerSizes"].selectedIndex;
	
	
	accordion.addEventListener("change", accListener);
	View(accordion.selectedChild).init();
	accordion._alpha = 100;
	sum = 0;
	N = 0;
	spinCount = 0;
	spinCount_txt.text = "0";
}

// Initialise the reports
function initResults() {	

	results.setStyle("themeColor", 0x0000FF);
	results.setStyle("embedFonts",true); 
	results.setStyle("fontSize", 14); 
	
	//results.createChild("Logger", "log", {label:"Results"});
	results.createChild("Chart","chart",{label: "Bar chart"});
	results.createChild("Frequency","frequency",{label: "Relative frequency table"});
	results.addEventListener("change", resultsListener);
	View(results.selectedChild).init();
	results._alpha = 100;
	
	ScrolledLogger(results.log).append("Exp. \t\t Results \t\t Sum\n\n");
}

// run once
run_btn.onRelease = function() {

	if (this._parent.accordion.spinners.spinnerCount >0 && !this._parent.buttonLock) {
		
		this._parent.buttonLock = true;
		var e:Experiment=Experiment(this._parent.accordion.selectedChild);
		runAndLog(e,true);
		//spinCount += 1;
		//spinCount_txt.text = spinCount;
		ScrolledLogger(results.log).end();
		//results.frequency.updateScores();
		this._parent.intervalID = setInterval(this._parent, "action", 1700);
		//trace("Results should be printed out here.");
	}
};


// run lots
lots_btn.onRelease = function() {
	if (this._parent.accordion.spinners.spinnerCount >0 && !this._parent.buttonLock) {
		this._parent.buttonLock = true;
		var e:BaseExperiment=BaseExperiment(this._parent.accordion.selectedChild);
		this._parent.runLots(100);
		ScrolledLogger(results.log).end();
	}
};



/*
// run loads
loads_btn.onPress = function() {
	if (this._parent.accordion.spinners.spinnerCount >0 && !this._parent.buttonLock) {
		this._parent.buttonLock = true;
		this._parent.accordion.selectedChild.calculating_mc._visible=true;
		this._parent.intervalID = setInterval(this._parent, "action", 1000);
	}
};
*/

var intervalID1:Number = null;
// run loads
loads_btn.onRelease = function() {
	if (this._parent.accordion.spinners.spinnerCount >0 && !this._parent.buttonLock) {
		this._parent.buttonLock = true;
		this._parent.accordion.selectedChild.calculating_mc._visible=true;
		var e:BaseExperiment=BaseExperiment(this._parent.accordion.selectedChild);
		ScrolledLogger(results.log).end();
		this._parent.intervalID1 = setInterval(this._parent, "action1", 10);
	}
};

function action1() {
	clearInterval(intervalID1);
	intervalID1 = null;
	runLots(50000);
}

function runLots(T:Number) {
	//trace("now1");
	accordion.selectedChild.calculating_mc._visible=true;
	var e:Experiment=Experiment(accordion.selectedChild);
	for (var i = 0; i<T; i++) {
		runAndLog(e,false);
	}
	spinCount_txt.text = spinCount;
	if (T<200) {
		if (intervalID != null) {
 			clearInterval(intervalID);
			intervalID = null;
		} else {
			intervalID = setInterval(this, "action", 1000);
		}
	} else {
		if (intervalID != null) {
 			clearInterval(intervalID);
			intervalID = null;
		} else {
			intervalID = setInterval(this, "action", 1000);
		}
	}
}

var intervalID:Number = null;

function action() {
	clearInterval(intervalID);
	intervalID = null;
	//trace("now2");
	accordion.spinners.calculating_mc._visible=false;
	results.frequency.updateScores();
	//Update frequency table. Lazy coding.
	buttonLock=false;
}

//trace( "results.getChildAt(1) " + results.getChildAt(1) );
results.getChildAt(0).clear_btn.onRelease = results.getChildAt(1).clear_btn.onRelease = function() {
	clearAll();
}

results.getChildAt(0).plus_btn.onRelease = function() {
	this._parent.tall*= 1.6; this._parent.prep();
}

results.getChildAt(0).minus_btn.onRelease = function() {
	this._parent.tall*= 0.625; this._parent.prep();
}

function clearAll() {
	sum = 0;
	N = 0;
	clear();
	results.chart.tall = 230;
	results.chart.init();
	ScrolledLogger(results.log).append("Exp. \t\t Results \t\t Sum\n\n");	
	for (var i:Number=0; i!=results.frequency.rows+1; i++) results.frequency.record[i]=0;
	spinCount_txt.text = "0";
	spinCount = 0;
	results.frequency["txt"].text = "";
}


var sum=0;
var N = 0;
function runAndLog(e:Experiment,withAnimation:Boolean) {
	
	var obj:Object = (withAnimation) ? e.runOnce() : e.runFast();
	
}

// stop running
stop_btn.onRelease = function() {
	var e:BaseExperiment=BaseExperiment(this._parent.accordion.selectedChild);
	e.onEnterFrame = undefined;
};


accordion.selectedChild.newSpin(4);
accordion.selectedChild.newSpin(4);


accordion["spinners"]["spinnerSizes"].selectedIndex = 2;