﻿class Spinners extends BaseExperiment implements Experiment {
	
	private var spinnerCount:Number = 0;
	
	var inMotion:Boolean = false;
	
	var intervalID:Number = null;	//For setInterval.
	
	//This is true iff we are working on the difference of two, rather than the sum.
	private var difference:Boolean = false;
	
	static var MAX_SPINNERS:Number = 4;
	
	var spinnerTotal:Number = 0;
	
	function Spinners() {
		}
	
	function init():Void {
		
		super.init();
		
		
		this["sum_txt"]._visible = false;
		this["difference_txt"]._visible = false;
		
		this["calculating_mc"]._visible = false;
		
		this["sumDifference_btn"]._y = -400;
		
		this["sumDifference_btn"].onPress = function() {
			this._parent.difference = (this._parent.difference) ? false : true;
			this._parent["sum_txt"]._visible = (this._parent["sum_txt"]._visible) ? false : true;
			this._parent["difference_txt"]._visible = (this._parent["difference_txt"]._visible) ? false : true;
			this._parent._parent._parent.clearAll();
		}
		
		this["newSpinner"].onPress = function() {	
			this._parent.newSpin(Number(this._parent.spinnerSizes.selectedItem.label));trace(this._parent);
		};
		
		this["deleteSpinners"].onPress = function() {	
			for (var i:Number = 0; i!=this._parent.spinnerCount; i++ )
				this._parent["spinner"+i].removeMovieClip();
			this._parent.spinnerCount = 0;
			this._parent.difference = false;
			this._parent.sumDifference_btn._y = -400;
			this._parent["sum_txt"]._visible = false;
			this._parent["difference_txt"]._visible = false;
			this._parent._parent._parent.clearAll();
		};
		
	}
	
	public function newSpin(N:Number):Void {
		if (spinnerCount < MAX_SPINNERS) {
				
				var mc:MovieClip = this;
				
				this._parent._parent.clearAll();

				var aSpinner = Spinner(mc.attachMovie("Spinner","spinner"+mc.spinnerCount,
					mc.getNextHighestDepth(),{nSlots:N}));
				
				this["sumDifference_btn"]._y = -400;
				
				this["difference_txt"]._visible = false;
				this["sum_txt"]._visible = true;
				
				if (mc.spinnerCount == 0) {
					aSpinner._x = 75;
					aSpinner._y = 120;
				} else if (mc.spinnerCount == 1) {
					aSpinner._x = 215;
					aSpinner._y = 120;
					this["sumDifference_btn"]._y = 0.4;
				} else if (mc.spinnerCount == 2) {
					aSpinner._x = 75;
					aSpinner._y = 260;
				} else if (mc.spinnerCount == 3) {
					aSpinner._x = 215;
					aSpinner._y = 260;
				}  
				
				
				mc.spinnerCount++;
				
				updateChartAxes();
				
				aSpinner._xscale = aSpinner._yscale = 35;
			}
	}
	
	public function updateChartAxes() {
		spinnerTotal = 0;
		for (var j:Number = 0; j!=spinnerCount; j++) {
			var t:Number = this["spinner"+j].entry[0];
			for (var k:Number = 1; k!=this["spinner"+j].nSlots; k++) {
				if (t<this["spinner"+j].entry[k]) t=this["spinner"+j].entry[k];
			}
			spinnerTotal += t;
		}
		trace("spinnerTotal = "+spinnerTotal);
		this._parent._parent.results.chart.bars = spinnerTotal+1;
		this._parent._parent.results.chart.prep();
	}
	
	
	public function runOnce():Object {
		
		//If no spinners then nothing happens.
		if (spinnerCount==0) return null;
		
		var obj:Object = new Object();
		obj.resultString = " ";
		var sum:Number = 0;
		if (!inMotion) {
			//Next line not necessary? Just set inMotion = true;
			inMotion = (spinnerCount==0) ? false : true;
			
			
			if (spinnerCount==2 && difference) {
				sum = Math.abs(this["spinner0"].spin(1.5) - this["spinner1"].spin(1.5));	
			} else {
				for (var i:Number = 0; i!=spinnerCount; i++) {
					var n:Number = this["spinner"+i].spin(1.5);
					obj.resultString += n + "\t";
					sum += n;
				}
			}
			
			
			for (var i:Number = 0; i!=MAX_SPINNERS-spinnerCount; i++)
				obj.resultString += "\t";
			
			obj.resultString += "\t" + sum;
			
			
			//Update stats.
			this._parent._parent.spinCount ++;
			this._parent._parent["spinCount_txt"].text = this._parent._parent.spinCount;
			this._parent._parent.results.frequency.record[sum]++;
			
			/*
				if (intervalID != null) {
 					clearInterval(intervalID);
					intervalID = null;
				} else intervalID = setInterval(this, "action", 1000,sum);
			*/
			
			return obj;
		} else return null;
	}
	
	/*
	function action(sum:Number) {
		clearInterval(intervalID);
		intervalID = null;
		//Update frequency table. Lazy coding.
		
		this._parent._parent.results.frequency.updateScores();
		this._parent._parent.buttonLock = false;
	}
*/
	
	
	//25 May 2008. I'm going to create a new runFast function that is much faster, and returns nothing.
	//Old one covered up below.
	
	//9 July 2008. I forgot to account for the user having changed the digits on the spinner. Yet another runFast
	//function needed. I'll keep the previous one, below, and delete the one covered up on 25 May.
	
	// Run the experiment fast with minimal or no animation
	function runFast():Void {
		
		//If no spinners then nothing happens.
		if (spinnerCount==0) return;

		var total:Number = 0;
		
		if (spinnerCount==2 && difference) {
				var u:Number = this["spinner0"].entry[Math.floor(Math.random()*this["spinner0"].nSlots)];
				var v:Number = this["spinner1"].entry[Math.floor(Math.random()*this["spinner1"].nSlots)];
				total = Math.abs(u-v) 
		} else {
			for (var i:Number = 0; i!=spinnerCount; i++) 
				total += this["spinner"+i].entry[Math.floor(Math.random()*this["spinner"+i].nSlots)];
		}
		
		this._parent._parent.spinCount++;
		this._parent._parent.results.frequency.record[total]++;
	}
	
	
	/*
	// Run the experiment fast with minimal or no animation
	function runFast():Void {
		
		//If no spinners then nothing happens.
		if (spinnerCount==0) return;

		var total:Number = 0;
		
		if (spinnerCount==2 && difference) {
				total = Math.abs(Math.floor(Math.random()*this["spinner0"].nSlots)-Math.floor(Math.random()*this["spinner1"].nSlots)); 
		} else {
			for (var i:Number = 0; i!=spinnerCount; i++) 
				total += Math.floor(Math.random()*this["spinner"+i].nSlots)+1;
		}
		
		this._parent._parent.spinCount++;
		this._parent._parent.results.frequency.record[total]++;
	}
	*/
	
	function getScore(result:Object):Number {
		return result.resultString;
	}
}