﻿//Want spinner to take following parameters.
//[1] Number of landing spots each spin.
//[2] Time it takes to start spin then stop and fix on a number.
//Want spinner to have following methods.
//[1] Start spin. Returns landing position.

class Spinner extends MovieClip {
	
	public var nSlots:Number = 20; //Number of positions on roulette wheel.
	
	public var tfFormat:TextFormat;
	
	public var output:Number = null;
	
	private var rad:Number = 147;
	
	//Contains the entries of the roulette wheel.
	public var entry:Array;
	
	//delete this
	var dig:Number;
	
	function Spinner() {
		
		entry = new Array(nSlots);
		for (var i:Number = 0; i!=nSlots; i++) entry[i]=i+1;
		
		tfFormat = new TextFormat();
		tfFormat.bold = true;
		//tfFormat.font = "Font3";
		tfFormat.size = 30;
		//if (nSlots<10) tfFormat.size = 30; else tfFormat.size = 20;
		tfFormat.color = 0xffffff;
		
		
		startup();
	}
	
	//init draws the spinner.
	function startup():Void {
		drawSlots(nSlots); //Draw the slots first.
		attachMovie("arrow","arrow",getNextHighestDepth());
		attachMovie("rim","rim",getNextHighestDepth());
		attachMovie("dragger","dragger",getNextHighestDepth(),
		{_x:-40,_y:-40,_alpha:0});
		this["dragger"].onPress = function() { this._parent.startDrag();}
		this["dragger"].onRelease = function() { this._parent.stopDrag();}
	}
	
	private function drawSlots():Void {
		var theta:Number = 2*Math.PI/nSlots;
		for (var i:Number = 0; i!=nSlots; i++) {
			if (i==0 && nSlots % 2 == 1) {
				lineStyle(1,0x009933,100) 
				beginFill(0x009933,100);
			}
			else if (i%2 == 0) {
				lineStyle(1,0x000000,100) 
				beginFill(0x000000,100);
			} else {
				lineStyle(1,0xff0000,100);
				beginFill(0xff0000,100);
			}
			moveTo(0,0);
			lineTo(rad*Math.cos(i*theta),rad*Math.sin(i*theta));
			lineTo(rad*Math.cos((i+1/4)*theta),rad*Math.sin((i+1/4)*theta));
			lineTo(rad*Math.cos((i+1/2)*theta),rad*Math.sin((i+1/2)*theta));
			lineTo(rad*Math.cos((i+3/4)*theta),rad*Math.sin((i+3/4)*theta));
			lineTo(rad*Math.cos((i+1)*theta),rad*Math.sin((i+1)*theta));
			lineTo(0,0);
			endFill();
			
			this.attachMovie("digits","spot"+i,this.getNextHighestDepth(),
				80*Math.cos((i+12/32)*theta),80*Math.sin((i+12/32)*theta),50,50);
			var halfFigureWidth:Number = this["spot"+i]._width/2;
			var halfFigureHeight:Number = this["spot"+i]._height/2;
			this["spot"+i]._rotation = 90+theta*(i+1/2)*180/Math.PI;
			var newHalfFigureWidth:Number = Math.cos((i+1/2)*theta)*halfFigureWidth-Math.sin((i+1/2)*theta)*halfFigureHeight;
			var newHalfFigureHeight:Number = Math.sin((i+1/2)*theta)*halfFigureWidth+Math.cos((i+1/2)*theta)*halfFigureHeight;
			
			this["spot"+i]._x = (rad*0.7)*Math.cos((i+1/2)*theta)-newHalfFigureWidth;
			this["spot"+i]._y = (rad*0.7)*Math.sin((i+1/2)*theta)-newHalfFigureHeight;
			
			this["spot"+i].gotoAndStop(i+1);
			
			this["spot"+i]._xscale = this["spot"+i]._yscale = 320;
			//this["spot"+i]._xscale = (nSlots<10) ? 350 : 200;
			//this["spot"+i]._yscale = (nSlots<10) ? 350 : 200;
			
			this["spot"+i].onPress = function() { 
				var I = +this._name.substring(4,5);
				if (this._currentframe ==this._totalframes) { 
					this.gotoAndStop(1);
					this._parent.entry[I] = 1;
				}
				else {
					this.nextFrame();
					this._parent.entry[I] = (this._parent.entry[I]!=15) ? this._parent.entry[I]+1 : 0;
				}
				this._parent._parent.updateChartAxes();
			}
			
		}
	}
	
	//Spins the wheel for a period of secs seconds and lands on a Number.
	public function spin(secs:Number):Number {
		this["arrow"]._rotation = 360*Math.random();
		//Final angle is above - 160.529676525935
		//So final number is:
		var finalRotAngle:Number = this["arrow"]._rotation - 160.529676525935 + 360;
		//trace("finalRotAngle " + finalRotAngle);
		var final:Number = Math.floor(    ( (finalRotAngle % 360)*nSlots/360 )+1 );
		//trace("final " + final);
		
		var counter:Number = 0;
		var intervalTime:Number = 10;
		var mc:MovieClip = this;
		var intervalID:Number = setInterval(round,intervalTime);
		//trace("angle0 " + mc.arrow._rotation);
		dig = Number(mc.arrow._rotation);
		function round() {
			mc.arrow._rotation += 80*Math.exp(-0.05*counter);
			counter++;
			//trace("counter "+counter);
			//trace("secs "+ secs);
			//trace("intervalTime " + intervalTime);
			if (counter > 1000*secs/intervalTime) {
				//trace("STOPPED");
				clearInterval(intervalID);
				mc._parent.inMotion = false;
				//trace(mc.nSlots);
				//trace(mc.arrow._rotation);
				//trace(Math.floor(((mc.arrow._rotation+360) % 360)*mc.nSlots/360));
				mc.output = Math.floor(((mc.arrow._rotation+360) % 360)*mc.nSlots/360)+1;
				//trace(mc.output);
				//trace("angle1 " + mc.arrow._rotation);
				//trace("dig "+ mc.dig);
				var p:Number = mc.arrow._rotation - mc.dig;
				//trace("angle2 " + p);
			}
			updateAfterEvent()
		}
		//trace("final is "+final);
		return entry[final-1];
	}
}
