﻿
import mx.controls.TextArea;

class Frequency extends mx.core.View {
	
	var rows:Number = 61;
	
	var record:Array;
	
	function Frequency() {
		record = new Array(100);
		for (var i:Number=0; i!=100; i++) record[i]=0;
	}
	
	function init():Void {
		
		//trace("In frequency initialisation.");
		
		this["clear_btn"].onPress = function() {
			for (var i:Number=0; i!=this._parent.rows+1; i++) this._parent.record[i]=0;
			this._parent["txt"].text = "";
			this._parent._parent._parent.spinCount_txt.text = "0";
		}
		
		if (t==undefined) {
			//this.createTextField("line"+i,this.getNextHighestDepth(),10,20+i*20,60,30);
			//this["line"+i].text = "test";
			var t = TextArea(createClassObject(TextArea, "txt", 1, {}));
			t._x = 5;
			t.editable=false;
			t.vScrollPolicy="auto"; 
			t.setSize(210, 280);
		}
				
	}
	
	public function updateScores():Void { 
		var sum:Number = 0;
		for (var i:Number = 0; i!=rows+1; i++) sum+= record[i];	
		this["txt"].text = "Exp. \t   Rel. Freq. \n\n";
		var relRecord:Array = new Array(61);
		if (sum==0) sum=1;
		for (var i:Number = 0; i!=rows; i++) {
			//Want to truncate answer to 3 decimal places.
			var n:Number = Math.floor(1000*record[i]/sum)/1000;
			relRecord[i] = n;
			if (i<9) this["txt"].text += " "+i + "\t\t" + ":" + "\t" + n + "\n";
			else this["txt"].text += i + "\t\t" + ":" + "\t" + n + "\n";			
		}
		for (var i:Number = 0; i!=61; i++)
			this._parent.chart.relRecord[i] = relRecord[i];
		this._parent.chart.prep();
	}
	
	
}