﻿class Chart extends mx.core.View {

	//Position of origin of graph.
	var origin_x:Number = 25;
	var origin_y:Number = 250;
	
	//Maximum number of bars to show.
	var bars:Number = 10;
	
	//Width and height of the chart. Note y-axis always same from 0 to 1.
	var wide:Number = 190;
	var tall:Number = 230;
	
	//Gap between bars.
	var gap:Number = 1;
	
	//Bar width calculated from gap, wide, and bars.
	var barWidth:Number;
	
	//List the entries in the bar chart. Relative frequencies.
	var relRecord:Array;
		
	function BarChart() {
		
	}
	
	
	function init():Void {
		
		
		relRecord = new Array(61);
		for (var i:Number = 0; i!=61; i++) relRecord[i] = 0;
		
		prep();
	}
	
	
	function prep() {
		
		
		//Calculate barWidth.
		barWidth = wide/bars - gap;
		
		//Clear the screen.
		clear();
		
		//Draw axes.
		drawAxes();
		
		//Mc to hold digits.
		this["digits"].removeMovieClip();
		this.createEmptyMovieClip("digits",this.getNextHighestDepth());
		
		//Draw ticks.
		drawVerticalTicks();
		drawHorizontalTicks();
		
		//Draw bars.
		drawBars();
	}
	
	//Draw bar chart axes.
	function drawAxes():Void {
		this.lineStyle(1,0x000000,100);
		this.moveTo(origin_x,origin_y); this.lineTo(origin_x,origin_y-tall);
		this.moveTo(origin_x,origin_y); this.lineTo(origin_x+wide,origin_y);
	}
	
	//Draw ticks on the vertical side of the graph.
	function drawVerticalTicks():Void {
		var t:Number = tall/10;
		for (var i:Number = 1; i!=11; i++) {
			this.moveTo(origin_x,origin_y-t*i); this.lineTo(origin_x-3,origin_y-t*i);
			this["digits"].createTextField("vertical"+i,this["digits"].getNextHighestDepth(),origin_x-22,origin_y-t*i-8,20,20);
			var j=i/10;
			this["digits"]["vertical"+i].selectable = false;
			this["digits"]["vertical"+i].text = j;
			this["digits"]["vertical"+i]._xscale = this["digits"]["vertical"+i]._yscale = 80;
		}
	}
	
	//Draw ticks on the x-axis.
	function drawHorizontalTicks():Void {
		var t:Number = barWidth+gap;
		
		//We only want to marks some of the ticks---say 10.
		var J: Number = Math.floor(bars/10)+1;
		//if (J==0) J = 1;
		
		for (var i:Number = 0; i!=bars; i++) {
			
			if (i % J == 0) {
				this.moveTo(origin_x+t*(i+0.5),origin_y); this.lineTo(origin_x+t*(i+0.5),origin_y+3);
				this["digits"].createTextField("horiz"+i,this["digits"].getNextHighestDepth(),origin_x+t*(i+0.5),origin_y+3,20,20);
				this["digits"]["horiz"+i].text = i;
				var K = (bars<5) ? 5 : bars; 
				this["digits"]["horiz"+i].selectable = false;
				this["digits"]["horiz"+i]._xscale = this["digits"]["horiz"+i]._yscale = 80;
				this["digits"]["horiz"+i]._x -= this["digits"]["horiz"+i]._width/4;
			}
		}
	}
	
	//Draw bars.
	function drawBars():Void {
		var t:Number = barWidth+gap;
		for (var i:Number = 0; i!=bars; i++) {
			//trace(tall*relRecord[i]);
			this.moveTo(origin_x+t*i,origin_y); 
			this.beginFill(0x0000cc,100);
			this.lineTo(origin_x+t*(i+1),origin_y);
			this.lineTo(origin_x+t*(i+1),origin_y-tall*relRecord[i]);
			this.lineTo(origin_x+t*(i),origin_y-tall*relRecord[i]);
			this.lineTo(origin_x+t*(i),origin_y);
			this.endFill();
		}
	}
	
}
