/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util;

import org.freehep.xml.util.BadXMLException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXErrorHandler
implements ErrorHandler {
    public static final int LEVEL_SUCCESS = 0;
    public static final int LEVEL_WARNING = 1;
    public static final int LEVEL_ERROR = 2;
    public static final int LEVEL_FATAL = 3;
    private int maxLevel = 0;
    private int minLevel;

    public SAXErrorHandler() {
        this(2);
    }

    public SAXErrorHandler(int n2) {
        this.minLevel = n2;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.handle(sAXParseException, 1, "Warning");
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.handle(sAXParseException, 2, "Error");
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.handle(sAXParseException, 3, "Fatal");
    }

    private void handle(SAXParseException sAXParseException, int n2, String string) throws SAXException {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = sAXParseException.getPublicId();
        if (string2 == null) {
            string2 = sAXParseException.getSystemId();
        }
        if (string2 != null) {
            stringBuffer.append(" at " + string2);
        }
        stringBuffer.append(" line " + sAXParseException.getLineNumber());
        if (n2 > this.maxLevel) {
            this.maxLevel = n2;
        }
        if (n2 >= this.minLevel) {
            throw new BadXMLException(stringBuffer.toString(), (Throwable)sAXParseException);
        }
        stringBuffer.append(": " + sAXParseException);
        System.err.println(stringBuffer);
    }

    public int getErrorLevel() {
        return this.maxLevel;
    }
}

