/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.freehep.util.io.RouteListener;

public class RoutedInputStream
extends InputStream {
    private InputStream in;
    private Map routes;
    private Map listeners;
    private byte[] buffer;
    private int sob;
    private int eob;
    private int index;
    private int state;
    private byte[] start;
    private static final int UNROUTED = 0;
    private static final int ROUTEFOUND = 1;
    private static final int ROUTEINFORM = 2;
    private static final int ROUTED = 3;
    private static final int CLOSING = 4;
    private static final int CLOSED = 5;

    public RoutedInputStream(InputStream inputStream) {
        this.in = inputStream;
        this.routes = new HashMap();
        this.listeners = new HashMap();
        this.buffer = new byte[20];
        this.sob = -1;
        this.eob = 0;
        this.index = 0;
        this.state = 0;
    }

    public int read() throws IOException {
        block7: while (true) {
            switch (this.state) {
                default: {
                    Object object;
                    int n2 = -1;
                    while (this.sob != this.eob) {
                        if (this.sob < 0) {
                            this.sob = 0;
                        }
                        if ((n2 = this.in.read()) < 0) {
                            this.state = 4;
                            continue block7;
                        }
                        this.buffer[this.eob] = (byte)n2;
                        this.eob = (this.eob + 1) % this.buffer.length;
                        object = this.routes.keySet().iterator();
                        while (object.hasNext()) {
                            this.start = (byte[])object.next();
                            this.index = (this.eob + this.buffer.length - this.start.length) % this.buffer.length;
                            if (!RoutedInputStream.equals(this.start, this.buffer, this.index)) continue;
                            this.state = 1;
                            continue block7;
                        }
                    }
                    int n3 = this.buffer[this.sob];
                    this.sob = (this.sob + 1) % this.buffer.length;
                    return n3;
                }
                case 1: {
                    if (this.sob == this.index) {
                        this.state = 2;
                        continue block7;
                    }
                    int n3 = this.buffer[this.sob];
                    this.sob = (this.sob + 1) % this.buffer.length;
                    return n3;
                }
                case 2: {
                    this.state = 3;
                    Object object = new Route(this.start, (byte[])this.routes.get(this.start));
                    ((RouteListener)this.listeners.get(this.start)).routeFound((Route)object);
                    this.state = 0;
                    if (this.sob == this.eob) {
                        this.sob = -1;
                        this.eob = 0;
                        continue block7;
                    }
                    int n3 = this.buffer[this.sob];
                    this.sob = (this.sob + 1) % this.buffer.length;
                    return n3;
                }
                case 3: {
                    int n3;
                    if (this.sob == this.eob) {
                        n3 = this.in.read();
                        if (n3 < 0) {
                            this.state = 5;
                            continue block7;
                        }
                    } else {
                        n3 = this.buffer[this.sob];
                        this.sob = (this.sob + 1) % this.buffer.length;
                    }
                    return n3;
                }
                case 4: {
                    if (this.sob == this.eob) {
                        this.state = 5;
                        continue block7;
                    }
                    int n3 = this.buffer[this.sob];
                    this.sob = (this.sob + 1) % this.buffer.length;
                    return n3;
                }
                case 5: 
            }
            break;
        }
        return -1;
    }

    public void addRoute(String string, String string2, RouteListener routeListener) {
        this.addRoute(string.getBytes(), string2 == null ? null : string2.getBytes(), routeListener);
    }

    public void addRoute(byte[] byArray, byte[] byArray2, RouteListener routeListener) {
        Object object = this.routes.keySet().iterator();
        while (object.hasNext()) {
            String string;
            String string2 = new String((byte[])object.next());
            if (!string2.startsWith(string = new String(byArray)) && !string.startsWith(string2)) continue;
            throw new IllegalArgumentException("Route '" + string + "' cannot be added since it overlaps with '" + string2 + "'.");
        }
        this.routes.put(byArray, byArray2);
        this.listeners.put(byArray, routeListener);
        if (byArray.length > this.buffer.length - 1) {
            object = new byte[byArray.length + 1];
            System.arraycopy(this.buffer, 0, object, 0, this.buffer.length);
            this.buffer = (byte[])object;
        }
    }

    private static boolean equals(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = byArray.length - 1; i2 > 0; --i2) {
            int n3 = (n2 + byArray2.length + i2) % byArray2.length;
            if (byArray2[n3] == byArray[i2]) continue;
            return false;
        }
        return byArray2[(n2 + byArray2.length) % byArray2.length] == byArray[0];
    }

    public class Route
    extends InputStream {
        private byte[] start;
        private byte[] end;
        private byte[] buffer;
        private int index;
        private boolean closed;

        public Route(byte[] byArray, byte[] byArray2) {
            this.start = byArray;
            this.end = byArray2;
            if (byArray2 != null) {
                this.buffer = new byte[byArray2.length];
            }
            this.index = 0;
            this.closed = false;
        }

        public int read() throws IOException {
            if (this.closed) {
                return -1;
            }
            int n2 = RoutedInputStream.this.read();
            if (n2 < 0) {
                this.closed = true;
                return n2;
            }
            if (this.end == null) {
                return n2;
            }
            this.buffer[this.index] = (byte)n2;
            this.index = (this.index + 1) % this.buffer.length;
            this.closed = RoutedInputStream.equals(this.end, this.buffer, this.index);
            return n2;
        }

        public void close() throws IOException {
            while (this.read() >= 0) {
            }
            this.closed = true;
        }

        public byte[] getStart() {
            return this.start;
        }

        public byte[] getEnd() {
            return this.end;
        }
    }
}

