/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class LogPen
implements EMFConstants {
    private int penStyle;
    private int width;
    private Color color;

    public LogPen(int n2, int n3, Color color) {
        this.penStyle = n2;
        this.width = n3;
        this.color = color;
    }

    public LogPen(EMFInputStream eMFInputStream) throws IOException {
        this.penStyle = eMFInputStream.readDWORD();
        this.width = eMFInputStream.readDWORD();
        eMFInputStream.readDWORD();
        this.color = eMFInputStream.readCOLORREF();
    }

    public void write(EMFOutputStream eMFOutputStream) throws IOException {
        eMFOutputStream.writeDWORD(this.penStyle);
        eMFOutputStream.writeDWORD(this.width);
        eMFOutputStream.writeDWORD(0);
        eMFOutputStream.writeCOLORREF(this.color);
    }

    public String toString() {
        return "  LogPen\n    penstyle: " + this.penStyle + "\n" + "    width: " + this.width + "\n" + "    color: " + this.color;
    }

    public int getPenStyle() {
        return this.penStyle;
    }

    public int getWidth() {
        return this.width;
    }

    public Color getColor() {
        return this.color;
    }
}

