﻿class DigitalClock extends MovieClip {

	public var myTime:Date;
	public var alarm:Date;
	
	function set(newTime:Date):Void {
		myTime = newTime;
		var hours = myTime.getHours(); /* currents hour represent like an integer between 0 and 23*/
		var minutes = myTime.getMinutes(); /* currents minute represent like an integer between 0 and 59*/
		var h1 = getDigit(hours, 1);
		var h2 = getDigit(hours, 2);
		var m1 = getDigit(minutes, 1);
		var m2 = getDigit(minutes, 2);
		this["h1"].set(h1 == 0 ? -1 : h1);
		this["h2"].set(h2);
		this["m1"].set(m1);
		this["m2"].set(m2);
	}
	
	function setAlarm(alarmTime:Date):Void {
		alarm = alarmTime;
	}
	
	function get():Date {
		return myTime;
	}
	
	function forward(minutes:Number):Boolean {
		var newTime = myTime.getTime() + minutes * 60 * 1000;
		if (newTime > alarm.getTime())
			return false;
		this._parent.wait(true);
		this.set(new Date(newTime));
		this._parent.wait(false);
		return true;
	}
	
	function getDigit(num:Number, pos:Number):Number {
		if (pos == 1)
			return Math.floor(num/10);
		else if (pos == 2)
		{
			var tens:Number = Math.floor(num/10);
			return num - 10 * tens;
		}
		return -1;
	}
}