﻿import flash.geom.ColorTransform;
import flash.geom.Transform;
import caurina.transitions.Tweener;

class Clock extends MovieClip {

	public var centre:MovieClip;
	public var myTime:Date;
	public var alarm:Date;
	
	function Clock() {
		centre = this["centre"];
	}
	
	function set(newTime:Date):Void {
		myTime = newTime;
		var hours = myTime.getHours(); /* currents hour represent like an integer between 0 and 23*/
		var minutes = myTime.getMinutes(); /* currents minute represent like an integer between 0 and 59*/
		centre.hourHand._rotation = (hours*30) + (minutes/2); /* There are 12 hours on the clock, so if a circle has 360 degrees, 360 divide by 12, means that the angle correspondig for each hour is hours*30. The angle between every two consecutive hours is 30. We will add to the rotation the angle correspondig for the minutes passed from current hour that is (minutes*30)/60, that means minutes/2*/
		centre.minuteHand._rotation = 6 * minutes; /* There are 60 minutes on the clock, so if a circle has 360 degrees, 360 divide by 60, means that the angle correspondig for each minute is minutes*6.*/
	}
	
	function setAlarm(alarmTime:Date):Void {
		alarm = alarmTime;
	}
	
	function get():Date {
		return myTime;
	}
	
	function finished():Void {
		this._parent._parent._parent.wait(false);
	}
	
	function forward(minutes:Number):Boolean {
		var newTime = myTime.getTime() + minutes * 60 * 1000;
		if (newTime > alarm.getTime())
			return false;
		myTime.setTime(newTime);
		this._parent.wait(true);
		Tweener.addTween(centre.hourHand, {_rotation:centre.hourHand._rotation+minutes/2, time:minutes*0.01, transition:"easeInOutSine", onComplete:finished});
		Tweener.addTween(centre.minuteHand, {_rotation:centre.minuteHand._rotation+6*minutes, time:minutes*0.01, transition:"easeInOutSine"});
		return true;
	}
}