﻿

package {

import flash.display.Sprite;

import flash.display.Shape;

import flash.events.MouseEvent;
 
public class Star extends Sprite {
	
	public var varySize:Boolean = false; //True iff sizes will vary.
	public var varyColour:Boolean = false;
	public var varyShape:Boolean = false;
	public var varyLocation:Boolean = false;
	
	//Sizes.
	private var small:int = 10;
	private var medium:int = 25;
	private var large:int = 40;
	
	//Colours.
	private var col1:uint = 0x000000;
	private var col2:uint = 0x0000cc;
	private var col3:uint = 0x00cc00;
	private var col4:uint = 0xcc0000;
	
	//Box in which stars appear.
	private var boxWidth:int = 430;
	private var boxHeight:int = 360;
	
	//If there is either to be moons or stars, then need a probability of star.
	private var probStar:Number = 0.4;

	//If there are to be many colours then we need a probability of getting a black one.
	private var probCol:Number = 0.4;
	
	//This variable is true iff a black star has appeared. 
	public var blackStar:Boolean = true;
	
	//Shape in which star or disc is to be drawn.
	private var shape:Shape = new Shape();
	
	//Constructor.
	function Star() {

		this.addChild(shape);
		newShape();
	}
	
	//Create a new shape.
	public function newShape() {
		
		//Set the blackStar variable to true as default.
		blackStar = true;
		
		//Get rid of old shape.
		shape.graphics.clear();
		
		/* There's a problem when varyColour=varyShape=true because black stars don't come up regularly
		enough. Therefore change probabilities in this case. */
		var p:Number = probCol;
		var q:Number = probStar;
		if (varyColour && varyShape) {
			p *= 1.5;
			q *= 1.5;
		}
		
		//If necessary, make size random.
		var size:int = medium;
		if (varySize) {
			var s = Math.random();
			if (s<1/3) size = small; else if (s>2/3) size = large;
		}
		
		
		
		//Give a random colour perhaps.
		var col:uint = col1;
		if (varyColour) {
			var t:Number = Math.random();
			blackStar = false;
			if ( p<t && t<(1+2*p)/3) col = col2;
			else if ( (1+2*p)/3<t && t<(2+p)/3 ) col = col3;
			else if ( (2+p)/3<t && t<1 ) col = col4;
			else blackStar = true;
		}

		
		//Draw the new star, or possibly moon.
		if (varyShape && Math.random() > q) {
			blackStar = false;
			drawMoon(col,size);
		}
		else drawStar(col,size);
		
		
		//Make location random if necessary.
		if (varyLocation) randomLocation();
		
	}
	
	//Draw a star.
	private function drawStar(col:uint,rad:int) {
		
		var theta:Number = 2*Math.PI/5;
		
		shape.graphics.beginFill(col,1);
		shape.graphics.moveTo(rad,0);
		for (var i:int = 1; i!=6; i++) {
			shape.graphics.lineTo(2.5*rad*Math.cos((i-0.5)*theta),2.5*rad*Math.sin((i-0.5)*theta));
			shape.graphics.lineTo(rad*Math.cos(i*theta),rad*Math.sin(i*theta));
		}
		shape.graphics.endFill();
	}
	
	//Draw a moon.
	private function drawMoon(col:uint,rad:int) {
		
		var theta:Number = Math.PI/100;
		
		//shape.graphics.lineStyle(1,0x000000,1);
		
		shape.graphics.beginFill(col,1);
		shape.graphics.moveTo(0,-rad);
		for (var i:int = -49; i!=51; i++) {
			shape.graphics.lineTo(rad*Math.cos(i*theta),rad*Math.sin(i*theta));
		}
		
		var phi:Number = Math.PI/4;
		var Rad:Number = rad/Math.sin(phi);
		var X:Number = rad/Math.tan(phi);
		var psi:Number = phi/50;
		
		for (var j:int = 49; j!=-51; j--) {
			shape.graphics.lineTo(Rad*Math.cos(j*psi)-X,Rad*Math.sin(j*psi));
		}
		shape.graphics.endFill();
			/*
					shape.graphics.moveTo(100, 100); 
        shape.graphics.curveTo(30, 150, 100, 200);    
        shape.graphics.curveTo(50, 150, 100, 100);
		*/
	}
	
	//Move the shape to a random location.
	private function randomLocation() {
		
		var usableWidth:Number = boxWidth-2*2.5*large;
		var usableHeight:Number = boxHeight-2*2.5*large;
		
		shape.x = -0.5*usableWidth + Math.random()*usableWidth;
		shape.y = -0.5*usableHeight + Math.random()*usableHeight;
		
	}
	
}

}
/*
package {
    import flash.display.Sprite;
    import flash.events.*;

    public class SpriteExample extends Sprite {
        private var size:uint    = 100;
        private var bgColor:uint = 0xFFCC00;

        public function SpriteExample() {
            var child:Sprite = new Sprite();
            child.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            child.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            draw(child);
            addChild(child);
        }

        private function mouseDownHandler(event:MouseEvent):void {
            trace("mouseDownHandler");
            var sprite:Sprite = Sprite(event.target);
            sprite.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            sprite.startDrag();
        }

        private function mouseUpHandler(event:MouseEvent):void {
            trace("mouseUpHandler");
            var sprite:Sprite = Sprite(event.target);
            sprite.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            sprite.stopDrag();
        }

        private function mouseMoveHandler(event:MouseEvent):void {
            trace("mouseMoveHandler");
            event.updateAfterEvent();
        }

        private function draw(sprite:Sprite):void {
            sprite.graphics.beginFill(bgColor);
            sprite.graphics.drawRect(0, 0, size, size);
            sprite.graphics.endFill();
        }
    }
}

*/