﻿//Programming note: the input BUTTONS serve no purpose. I have even replaced their co-ordinates with X and Y
//so I could just as well draw in red disks. (Or different colour for inputs perhaps?)
						
class Icon extends MovieClip {
	
	//Index of icon: each icon assigned a unique integer.
	var index:Number = null;
	
	//Number of inputs & outputs. Either 0,1,2.
	var n_inputs:Number = 2;
	var n_outputs:Number = 1;
	
	//Now we want to know if each input is on, off, or non-existent.
	var input1:Boolean = null;
	var input2:Boolean = null;
	var output1:Boolean = null;
	var output2:Boolean = null;

	//Which other icon connects to input1 or 2? connectToInput1[0] is index of icon and connectToInput1[1] is 
	//either 1 or 2 depending on output connector.
	var connectToInput1:Array = null;
	var connectToInput2:Array = null;
	
	//Which other icons connected from output1 or 2? Similar to connectToInput, but this time we have a double 
	//array because there can be lots of outputs so connectFromOutput1[i] is the ith output icon, and have
	//variables connectFromOutput1[i][0] and connectFromOutput1[i][1] same as connectFromInput1 definition.
	var connectFromOutput1:Array = null;
	var connectFromOutput2:Array = null;
	
	var disabled:Boolean = false; //True iff disabled.
	
	//Only used in the Gate class.
	var type:String;
	
	function Icon(s:Number,t:Number) {
		//Adjust number of inputs or outputs depending on constructor. Need this for inheritance. 
		n_inputs = s;
		n_outputs = t;
		
		//Initialise connecting arrays.
		connectToInput1 = new Array();
		connectToInput2 = new Array();
		connectFromOutput1 = new Array();
		connectFromOutput2 = new Array();
		
		//Moving the icon around.
		iconControls();
		
		//Attach connectors.
		connectors();
		
		//Attach twisters.
		twisters();
		
		//Attach annihilators.
		var a = this.attachMovie("Annihilator","annihilator",this.getNextHighestDepth());
		a._y = -25; 
		annihilatorControl();
	}
	
	
	private function iconControls():Void {
		
		//Make empty square to drag the thing around.
		var m = this.createEmptyMovieClip("dragger",this.getNextHighestDepth());
		m.lineStyle(1,0x000000,0);
		m.moveTo(-15,-15);
		m.beginFill(0x000000,0);
		m.lineTo(-15,15); m.lineTo(15,15); m.lineTo(15,-15); m.lineTo(-15,-15);
		m.endFill();
		
		m.onPress = function() { if (!this._parent.disabled) this._parent.startDrag(); }
		m.onRelease = m.onReleaseOutside = function () { if (!this._parent.disabled) this._parent.stopAndFix(); }
		
	}
	
	//Stops icon and fixes it in a particular spot.
	private function stopAndFix():Void {
		this.stopDrag();
		this._x = Math.round(this._x/20)*20;
		this._y = Math.round(this._y/20)*20;
		
		if (this._x>540) this._x = 540;
		else if (this._x<20) this._x = 20; 
		if (this._y>380) this._y = 380;
		else if (this._y<20) this._y = 20;
		
		//trace(this._parent["wires"]);
		this._parent["wires"].rewire();
	}
	
	//Attach the connectors.
	private function connectors():Void {
		
		//I am creating X and Y variables for the connector buttons which record the real position
		//of the buttons, accounting for rotation.
		if (n_inputs==2) {
			var a = this.attachMovie("connector_btn","input_btn1",this.getNextHighestDepth());
			a._x = a.X = -20; a._y = a.Y = -20; a.enabled = false;
			var b = this.attachMovie("connector_btn","input_btn2",this.getNextHighestDepth());
			b._x = b.X = -20; b._y = b.Y = 20; b.enabled = false;
		} else if (n_inputs==1) {
			var a = this.attachMovie("connector_btn","input_btn1",this.getNextHighestDepth());
			a._x = a.X = -20; a._y = a.Y = 0; a.enabled = false;
		}
		if (n_outputs==2) {
			var a = this.attachMovie("connector_btn","output_btn1",this.getNextHighestDepth());
			a._x = a.X = 20; a._y = a.Y = -20;
			var b = this.attachMovie("connector_btn","output_btn2",this.getNextHighestDepth());
			b._x = b.X = 20; b._y = b.Y = 20;
		} else if (n_outputs==1) {
			var a = this.attachMovie("connector_btn","output_btn1",this.getNextHighestDepth());
			a._x = a.X = 20; a._y = a.Y = 0;
		}
	}
	
	//Attach the twisters.
	private function twisters():Void {
		var NE = this.attachMovie("twist_btn","twist_btnNE",this.getNextHighestDepth());
		NE._x = 25; NE._y = -25;
		var NW = this.attachMovie("twist_btn","twist_btnNW",this.getNextHighestDepth());
		NW._x = -25; NW._y = -25; NW._rotation = -90;
		var SW = this.attachMovie("twist_btn","twist_btnSW",this.getNextHighestDepth());
		SW._x = -25; SW._y = 25; SW._rotation = 180;
		var SE = this.attachMovie("twist_btn","twist_btnSE",this.getNextHighestDepth());
		SE._x = 25; SE._y = 25; SE._rotation = -270;
		
		if (disabled) NE._visible = NW._visible = SW._visible = SE._visible = false;
		
		NE.onPress = NW.onPress = SE.onPress = SW.onPress = function() {
			this._visible = false;
			
			this._parent._rotation -= 90;
			this._parent.rotateConnectors();
			
			
			//trace("x = "+tp["input_btn1"]._x);
			//trace("X = "+tp["input_btn1"].X);
			//trace("y = "+tp["input_btn1"]._y);
			//trace("Y = "+tp["input_btn1"].Y);
		}
		NE.onReleaseOutside = NW.onReleaseOutside = SE.onReleaseOutside = SW.onReleaseOutside =function() {
			this._visible = true;
			this._parent._parent["wires"].rewire();
		}
	}
	
	//Adjust the X and Y values of the connectors.
	function rotateConnectors() {
		
		var tp = this;
		var q = this._rotation*Math.PI/180;
		
		//Change X and Y values.
		for (var i:Number = 1; i!=3; i++) {
			tp["input_btn"+i].X = Math.round(Math.cos(q)*tp["input_btn"+i]._x-Math.sin(q)*tp["input_btn"+i]._y);
			tp["input_btn"+i].Y = Math.round(Math.sin(q)*tp["input_btn"+i]._x+Math.cos(q)*tp["input_btn"+i]._y);
			tp["output_btn"+i].X = Math.round(Math.cos(q)*tp["output_btn"+i]._x-Math.sin(q)*tp["output_btn"+i]._y);
			tp["output_btn"+i].Y = Math.round(Math.sin(q)*tp["output_btn"+i]._x+Math.cos(q)*tp["output_btn"+i]._y);
		}
	}
	
	
	//This function depends on the particular icon. The default function (which will work 
	//for the led gate and the split, follows:
	function changeState() {
		if (input1) gotoAndStop(2); else gotoAndStop(1);
		if (n_outputs==2) output1=output2=input1;
	}
	
	
	function annihilatorControl() {
		this["annihilator"].onPress = function() {
			
			var tp = this._parent;
			var icons = this._parent._parent.icons;
			var w = this._parent._parent["wires"];
			
			tp.disabled= true;
			
			//trace("wirecount = "+w.wireCount);
			
			//Delete all wires that lead into it.
			for (var i:Number = 0; i!=w.wireCount; i++) {
				//trace("start = "+w["wire"+i].startCode[0]);
				//trace("end = "+w["wire"+i].endCode[0]);
				if (w["wire"+i].startCode[0]==tp.index || w["wire"+i].endCode[0] == tp.index)
				w["wire"+i].removeMovieClip();
			}
			
			//Change connections of all devices that lead into inputs a=1 and a=2.
			for (var a:Number = 1; a != 3; a++) {
			
				//Break if there are no inputs.
				if ( tp.n_inputs==0 || (tp.n_inputs==1 && a==2) ) break;
				var I = (a==1) ? tp.connectToInput1[0] : tp.connectToInput2[0];
				var J = (a==1) ? tp.connectToInput1[1] : tp.connectToInput2[1];
				
				var K:Number = null;
			
			//trace("I = "+I);
			//trace("a = "+a);
			
				if (J==1 && I!=undefined && I!=null) {
					//trace("before = "+icons[I].connectFromOutput1);
					for (var i:Number = 0; i!=icons[I].connectFromOutput1.length; i++) {
						if (icons[I].connectFromOutput1[i][0] == tp.index) K = i;
						//trace("K = "+K);
					}
					icons[I].connectFromOutput1.splice(K,1);
					//trace("after = "+icons[I].connectFromOutput1);
				} else if (J==2 && I!=undefined && I!=null) {
					for (var i:Number = 0; i!=icons[I].connectFromOutput2.length; i++) 
						if (icons[I].connectFromOutput2[i][0] == tp.index) K = i;
					icons[I].connectFromOutput2.splice(K,1);	
				}
			
			
			}
			//trace("next length = "+tp.connectFromOutput1.length);
			
			//Change connections of all devices into which icon feeds.
			if (tp.connectFromOutput1.length > 0) {
				//trace("before = "+tp.connectFromOutput1);
				for (var i:Number=0; i!=tp.connectFromOutput1.length; i++) {
					if (tp.connectFromOutput1[i][1]==1) {
						icons[tp.connectFromOutput1[i][0]].connectToInput1.splice(0,2);
						icons[tp.connectFromOutput1[i][0]].input1 = null;
					}
					else {
						icons[tp.connectFromOutput1[i][0]].connectToInput2.splice(0,2);
						icons[tp.connectFromOutput1[i][0]].input2 = null;
					}
				}
				//trace("after = "+tp.connectFromOutput1);
			}
			//trace("final length = "+tp.connectFromOutput2.length);
			if (tp.connectFromOutput2.length > 0) {
				for (var i:Number=0; i!=tp.connectFromOutput2.length; i++) {
					if (tp.connectFromOutput2[i][1]==1) icons[tp.connectFromOutput2[i][0]].connectToInput1.splice(0,2);
					else icons[tp.connectFromOutput2[i][0]].connectToInput2.splice(0,2);
				}
			}
			
			//Make all circuits black.
			w.neutralise();
			
			
			
			this._parent.removeMovieClip();
			
			//Relight those still with power.
			w.electrify();
				
			//trace("Do we make it here?");
		}
	}
	
	//Only used in Gate.
	function toggleType() {}
}
