﻿
class Gate extends Icon {

	public var type:String = "AND";
	private var my_fmt:TextFormat;
	
	function Gate() {
		super(2,1);
		
		//Initialise the text format.
		my_fmt = new TextFormat(); 
		my_fmt.font = "Font 1";
		
		//Text displaying type of gate.
		textBox();
		
		//Box that enables switching of type.
		attachSwitch();
		
		
		//trace("input1 = "+input1);
		//trace("input2 = "+input2);
	}
	
	//Text box for gate.
	private function textBox():Void {
		
		var t = this.createTextField("my_txt", this.getNextHighestDepth(),0,0,40,20); 
		t.selectable = false;
		t.autosize = true;
		changeText();	
	}
	
	private function changeText():Void {
		var t = this["my_txt"];
		t.text = type;
		my_fmt.size = (t.length == 4) ? 8 : 9;
		t.embedFonts = true;
		t.setTextFormat(my_fmt); 
		
		t._x = -t.textWidth/2 -5 ;
		t._y = -t.textHeight/2-1.5;	
		if (t.length ==4) {t._y = t._y-0.5; t._x = t._x+0.5;}
	}
	
	//Change type of box.
	private function toggleType():Void {
		switch (type) {
			case "AND" :
				type = "OR"; 
				break;
			case "OR" : 
				type = "XOR";
				break;
			case "XOR" : 
				type = "NAND";
				break;
			case "NAND" : 
				type = "NOR";
				break;
			case "NOR" :
				type = "XNOR";
				break;
			case "XNOR" :
				type = "AND";
				break;
		}
		changeText();
		var m = (this._currentframe  % 6) + 1;
		this.gotoAndStop(m);
	}
	
	//Button that allows switching of type.
	private function attachSwitch():Void {
		var b = this.attachMovie("switch_btn","switch_btn",this.getNextHighestDepth());
		b._x = -10; b._y = -8;
		b.onPress = function() { 
			this._parent.toggleType(); 
			this._parent._parent["wires"].electrify();
		}
	}
	
	//Override changeState of the icon function.
	function changeState() {
		
		
		
		//Must have null output if not both inputs are true or false.
		if (input1==null || input2==null) {
			output1=null;
			return;
		}
		
		
		switch (type) {
			case "AND" :
				output1 = (input1 && input2) ? true : false; 
				break;
			case "OR" : 
				output1 = (input1 || input2) ? true : false;
				break;
			case "XOR" : 
				output1 = ( (input1 && !input2) || (!input1 && input2) ) ? true : false;
				break;
			case "NAND" : 
				output1 = (input1 && input2) ? false : true;
				break;
			case "NOR" :
				output1 = (!input1 && !input2) ? true : false;
				break;
			case "XNOR" :
				output1 = ( (input1 && input2) || (!input1 && !input2) ) ? true : false;
				break;
		}
		
		
		//Change colour of input wires and output wire of icon.
		if (input1) this["inputLine1"].gotoAndStop(2); else this["inputLine1"].gotoAndStop(1);
		if (input2) this["inputLine2"].gotoAndStop(2); else this["inputLine2"].gotoAndStop(1);
		if (output1) this["outputLine"].gotoAndStop(2); else this["outputLine"].gotoAndStop(1);
		
	}
	
	
}

