﻿class Triangle extends MovieClip {
	private var vertices:Array = null; //The vertices of the triangle.
	private var angle:Number = null; //The initial angle of rotation of the selected vertex.
	private var rotatorOn:Boolean = false; //If this is on then the polygon starts rotating.
	var blobs:Array;
	var index:Number;
	var secondVert:Boolean; // if checking sides - for matching only one vert
	private var intervalID:Number = null; //For shrinking of triangles.
	
	function Triangle() {
		vertices = new Array(3);
		polyControls(); //Control the poly.
	}
	private function attachBlobs():Void {
		blobs = new Array();
		for (var i:Number = 0 ; i<3; i++) {
			var bob = attachMovie("blob","blob"+i,_parent.depth++);
			bob._alpha=70;
			bob._visible = false;
			bob._x = vertices[i][0];
			bob._y = vertices[i][1];
			blobs[i] = bob;
		}
	}

	private function polyControls() {
		this.onPress = pressControl;
		this.onRelease = releaseControl;
		this.onReleaseOutside = releaseControl;
		this.onMouseMove = mouseMoveControl;
	}
	
	//The polygon is pressed.
	private function pressControl() {
		_parent.depth++;
		this.swapDepths(_parent.depth);
		//Different control depending on whether pressed near vertex or not.
		var b:Number = nearVertex(_level0._xmouse,_level0._ymouse);
		//Either near vertex of not near vertex.
		if (b != -1) {
			angle = Math.atan2(vertices[b][1],vertices[b][0]); //What is initial angle of vertex b.
			rotatorOn = true; //Turn the rotator on!
		} 
		else {
			this.startDrag();
		}
	}
	//Determine if the polygon press is near a vertex. Returns vertex number.
	private function nearVertex(xx:Number,yy:Number):Number {
		var vertex:Number = -1;
		var vert:Array = new Array;
		for (var i:Number=0; i<3; i++) {
			vert[i] = {x:blobs[i]._x, y:blobs[i]._y};
			localToGlobal(vert[i]);
			if ( squareSep(vert[i].x,vert[i].y,xx,yy) < 100 ) {
				vertex = i;
			}
		}
		return vertex;
	}
	//Square of separation between (a,b) and (c,d).
	private function squareSep(a,b,c,d:Number):Number {
		return (a-c)*(a-c)+(b-d)*(b-d);
	}
	
	//Release of the polygon pressing.
	private function releaseControl() {
		//Destroy polygon if outside boundary.
		var condition:Boolean = (this._x>510 || this._x<0 || this._y>360 || this._y<0)
		if (condition) {
			shrinker();
		}
		this.stopDrag(); //Stop dragging!
		rotatorOn = false; //Stop the mouse rotating.
		//Test if sides pair with another polygon. Relocate if necessary.
		//Pass it the index of the current polygon.
		if (!condition) {
			sideCheck(index);
		}
}
	private function shrinker() {
		intervalID = setInterval(this,"shrink",10);
	}
	private function shrink() {
		this._xscale -= 5;
		this._yscale -= 5;
		if (this._xscale < 10) {
			clearInterval(intervalID);
			_parent.trias[index] = null;
			this.removeMovieClip();
		}
	}
	//Test if two sides meet up.
	private function sideCheck(nn:Number):Void {
		//Go through each polygon.
		for (var i:Number = 0; i < _parent.trias.length; i++) {
			//Miss out selected polygon and those that have been deleted.
			if ((i!=nn) && (_parent.trias[nn] != null)) {
				//Compare two triangles.
				sides(i,nn);
			}
		}
	}
	//Compares two polygons. If sides meet, moves latter on to former.
	//Returns true if they meet.
	function sides(m:Number,n:Number):Boolean {
		var vert_m:Array = new Array;
		for (var i:Number=0; i<3; i++) {
			vert_m[i] = {x:_parent.trias[m].blobs[i]._x, y:_parent.trias[m].blobs[i]._y};
			_parent.trias[m].localToGlobal(vert_m[i]);
		}
		var vert_n:Array = new Array;
		for (var i:Number=0; i<3; i++) {
			vert_n[i] = {x:blobs[i]._x, y:blobs[i]._y};
			localToGlobal(vert_n[i]);
		}
		
			for (var i:Number = 0; i<3; i++) {
			//Vertex i and vertex i+1 (second vertex may be 0).
			var I:Number = (i+1) % 3;
			//Need to calculate the location of the vertices.
			var a:Number = vert_n[i].x; //trace("a: "+a);
			var b:Number = vert_n[i].y; //trace("b: "+b);
			var e:Number = vert_n[I].x; //trace("e: "+e);
			var f:Number = vert_n[I].y; //trace("f: "+f);
			//polys[n].vertices.length
			for (var j:Number = 0; j< 3; j++) {
				var J:Number = (j+1) % 3;
				//Need to calculate the location of the vertices.
				var c:Number = vert_m[j].x; //trace("c: "+c);
				var d:Number = vert_m[j].y; //trace("d: "+d);
				var g:Number = vert_m[J].x; //trace("g: "+g);
				var h:Number = vert_m[J].y; //trace("h: "+h);
				//Now compare.
				var bool:Boolean = compare(a,b,g,h,e,f,c,d);
				//trace("THE RESULT IS " + bool);
				//Adjust if sides pair up.
				if (bool) {
					//Move the (c,d) and (g,h) polygon.
					var newAngle:Number = Math.atan2(a-e,b-f);
					var oldAngle:Number = Math.atan2(g-c,h-d);
					var changeAngle:Number = newAngle - oldAngle;
					this._rotation += 180*changeAngle/Math.PI;
					//find a, b after rotation
					for (var ii:Number=0; ii<3; ii++) {
						vert_n[ii] = {x:blobs[ii]._x, y:blobs[ii]._y};
						//trace("vert_n[i] = "+vert_n[i].x+", "+vert_n[i].y);
						localToGlobal(vert_n[ii]);
						//trace("global n: "+vert_n[i].x+", "+vert_n[i].y);
					}
					if (secondVert) {
						e = vert_n[I].x;
						f = vert_n[I].y;
						this._x += c-e;
						this._y += d-f;
					}
					else {
						a = vert_n[i].x;
						b = vert_n[i].y;
						this._x += g-a;
						this._y += h-b;
					}
					return bool;
				}
			}
		}
		return false;
	}
	private function compare(a,b,g,h,e,f,c,d:Number):Boolean {
		var epsilon:Number = 40;
		secondVert = false;
		if ( ((a-g)*(a-g)+(b-h)*(b-h) < epsilon) && 
			 ((e-c)*(e-c)+(f-d)*(f-d) < epsilon) ) return true;
		else {
			var angle1:Number = Math.atan2(a-e,b-f);
			var angle2:Number = Math.atan2(g-c,h-d);
			var diff:Number = Math.abs(angle1-angle2);
			var eps:Number = Math.PI/20;
			if ((diff<eps) && ((a-g)*(a-g)+(b-h)*(b-h) < epsilon)) {
				return true;
			}
			else if ((diff<eps) && ((e-c)*(e-c)+(f-d)*(f-d) < epsilon)) {
				secondVert = true;
				return true;
			}
			else return false;
		}
	}
	//Rotate the poly.
	private function mouseMoveControl() {
		//Change symbol if near vertex.
		var b:Number = nearVertex(_level0._xmouse,_level0._ymouse);
		//Show white blobs if near vertex.
		if (b!=-1) this["blob"+b]._visible = true;
		else {
			for (var i:Number = 0; i!=vertices.length; i++)
				this["blob"+i]._visible = false;
		}
		
		//Only operate if specified by rotatorOn.
		if (rotatorOn) {
			//Calculate angle of cursor.
			var cursor=Math.atan2(_parent._ymouse-this._y,_parent._xmouse-this._x);
			//Alter rotation of polygon accordingly.
			this._rotation = 180*(cursor-angle)/Math.PI;
			updateAfterEvent();
		}
	}
	/*function onRollOver() {
		trace("-- on roll --")
		var b:Number = nearVertex(_level0._xmouse,_level0._ymouse);
		//Show white blobs if near vertex.
		if (b!=-1) this["blob"+b]._visible = true;
		else {
			for (var i:Number = 0; i!=vertices.length; i++)
				this["blob"+i]._visible = false;
		}
	}*/
}