﻿
class PolygonInterface extends MovieClip {
	
	//Array storing the polygons.
	private var polys:Array;
	
	//The square of the distance between two vertices.
	private var epsilon:Number = 40;
	
	//Keep track of the current highest depth.
	private var max_depth:Number = 0;
	
	//Ridiculous existence array.
	private var exists:Array;
	
	//For shrinking of triangles.
	private var intervalID:Number = null;
	
	//Constructor
	function PolygonInterface() {
		
		this["triangle_btn"].onPress = triangle_btn_pressed;
		this["square_btn"].onPress = square_btn_pressed;
		this["pentagon_btn"].onPress = pentagon_btn_pressed;
		this["hexagon_btn"].onPress = hexagon_btn_pressed;
		this["septagon_btn"].onPress = septagon_btn_pressed;
		this["octagon_btn"].onPress = octagon_btn_pressed;
		this["nonagon_btn"].onPress = nonagon_btn_pressed;
		this["decagon_btn"].onPress = decagon_btn_pressed;
		this["elfgon_btn"].onPress = elfgon_btn_pressed;
		this["dozengon_btn"].onPress = dozengon_btn_pressed;
		
		this["clear_btn"].onPress = clearAll;
		
		init();
	}
	
	private function clearAll():Void {
		this._parent.init();
	}
	
	//Initialisation.
	private function init():Void {
		
		//Delete old stuff.
		if ( polys.length > 0 ) {
			for (var i:Number = 0; i!= polys.length; i++) 
				this["poly"+i].removeMovieClip();
		}
		
		trace("here = "+exists[0]);
		
		delete polys;
		delete exists;
		
		//Initialise the polygons.
		polys = new Array();
		exists = new Array();
		
		trace("here = "+exists[0]);
		
	}
	
	//Control of the triangle button.
	private function triangle_btn_pressed():Void {
		this._parent.newPoly(3);
	}
	private function square_btn_pressed():Void {
		this._parent.newPoly(4);
	}
	private function pentagon_btn_pressed():Void {
		this._parent.newPoly(5);
	}
	private function hexagon_btn_pressed():Void {
		this._parent.newPoly(6);
	}
	private function septagon_btn_pressed():Void {
		this._parent.newPoly(7);
	}
	private function octagon_btn_pressed():Void {
		this._parent.newPoly(8);
	}
	private function nonagon_btn_pressed():Void {
		this._parent.newPoly(9);
	}
	private function decagon_btn_pressed():Void {
		this._parent.newPoly(10);
	}
	private function elfgon_btn_pressed():Void {
		this._parent.newPoly(11);
	}
	private function dozengon_btn_pressed():Void {
		this._parent.newPoly(12);
	}
	
	//Make a new polygon!
	private function newPoly(sides:Number):Void {
		
		//Side length.
		var s:Number = 30;
		
		//Fundamental angles.
		var t:Number = Math.PI*2/sides;
		
		//Distance from centre to vertex.
		var d:Number = s/(2* Math.sin(t/2));
		
		var vertices = new Array();
		
		for (var i:Number = 0; i!= sides; i++) {
			var v = [d*Math.cos(i*t),d*Math.sin(i*t)];
			vertices.push(v);
		}
		
		var colors:Array;
		if (sides==3) colors = [0xcc0000, 0xffffff];
		else if (sides==4) colors = [0x330099, 0xffffff];
		else if (sides==5) colors = [0xff9900, 0xffffff];
		else if (sides==6)  colors = [0x009933, 0xffffff];
		else if (sides==7) colors = [0xcc0099, 0xffffff];
		else if (sides==8)  colors = [0x6699cc, 0xffffff];
		else if (sides==9) colors = [0x996600, 0xffffff];
		else if (sides==10) colors = [0x99ff66, 0xffffff];
		else if (sides==11) colors = [0xffcc99, 0xffffff];
		else if (sides==12)  colors = [0xffcc00, 0xffffff];
		
		//Attach a new polygon.
		var poly = Polygon(attachMovie("Polygon","poly"+polys.length,
			this.getNextHighestDepth(),{_x:200,_y:200,vertices:vertices,colors:colors}));
		max_depth = poly.getDepth();
		
		//Add it to polys array.
		polys.push(poly);
		exists.push(true);
		//trace(exists);
		
		poly._rotation += polys.length * 37;
		
		//This polygon functionality overrides the Polygon class functionality.
		poly.onPress = pressControl;
		poly.onRelease = releaseControl;
		poly.onReleaseOutside = releaseControl;
	}
	
	//Polygon pressed.
	private function pressControl():Void {
		//Operate the polygons own release control (in Polygon class).
		this.pressControl();
		//trace("depth1 ="+this.getDepth());
		this._parent.max_depth++;
		//trace(this);
		this.swapDepths(this._parent.max_depth);
		//trace("depth2 ="+this.getDepth());
	}
	
	//Controls when polygon is released.
	private function releaseControl():Void {
		
		//Destroy polygon if outside boundary.
		if (this._x>360 || this._x<40 || this._y>360 || this._y<40) {
			var index:Number;
			if (this._name.substr(5,1) != "") index = Number(this._name.substr(4,2));
			else index = Number(this._name.substr(4,1));
			this._parent.exists[index] = false;
			//trace("here we go ="+this._name.substr(4,1));	
			//trace("exists = "+exists);
			//trace("this is = "+this._name);
			this._parent.shrinker(index);
			//this.removeMovieClip();
		}
		
		
		//Operate the polygons own release control (in Polygon class).
		this.releaseControl();
		
		//Test if sides pair with another polygon. Relocate if necessary.
		//Pass it the index of the current polygon.
		if (this._name.substr(5,1) != "")  
			this._parent.sideCheck(+this._name.substr(4,2));
		else this._parent.sideCheck(+this._name.substr(4,1));
	}
	
	private function shrinker(index:Number) {
		intervalID = setInterval(this,"shrink",10,index);
	}
	
	private function shrink(i:Number) {
		//trace("i = "+i);
		polys[i]._xscale -= 5;
		polys[i]._yscale -= 5;
		if (polys[i]._xscale < 10) {
			clearInterval(intervalID);
			polys[i].removeMovieClip();
		}
	}
	
	//Test if two sides meet up.
	private function sideCheck(n:Number):Void {
		//trace("n="+n);
		//Go through each polygon.
		for (var i:Number = 0; i != polys.length; i++) {
			//Miss out selected polygon and those that have been deleted.
			if (i!=n && exists[i]) {
				//Compare two polygons.
				sides(i,n);
			}
		}
	}
	
	//Compares two polygons. If sides meet, moves latter on to former.
	//Returns true iff they meet.
	private function sides(m,n:Number):Boolean {
		for (var i:Number = 0; i!= polys[m].vertices.length; i++) {
			//Vertex i and vertex i+1 (second vertex may be 0).
			var I:Number = (i+1) % polys[m].vertices.length;
			//Need to calculate the location of the vertices.
			var theta:Number = Math.PI*polys[m]._rotation/180;
			var co:Number = Math.cos(theta);
			var si:Number = Math.sin(theta);
			var a:Number = polys[m]._x+co*polys[m].vertices[i][0]-si*polys[m].vertices[i][1];
			var b:Number = polys[m]._y+si*polys[m].vertices[i][0]+co*polys[m].vertices[i][1];
			var e:Number = polys[m]._x+co*polys[m].vertices[I][0]-si*polys[m].vertices[I][1];
			var f:Number = polys[m]._y+si*polys[m].vertices[I][0]+co*polys[m].vertices[I][1];
			//polys[n].vertices.length
			for (var j:Number = 0; j!= polys[n].vertices.length; j++) {
				var J:Number = (j+1) % polys[n].vertices.length;
				//Need to calculate the location of the vertices.
				var phi:Number = Math.PI*polys[n]._rotation/180;
				var oc:Number = Math.cos(phi);
				var is:Number = Math.sin(phi);
				var c:Number = polys[n]._x+oc*polys[n].vertices[j][0]-is*polys[n].vertices[j][1];
				var d:Number = polys[n]._y+is*polys[n].vertices[j][0]+oc*polys[n].vertices[j][1];
				var g:Number = polys[n]._x+oc*polys[n].vertices[J][0]-is*polys[n].vertices[J][1];
				var h:Number = polys[n]._y+is*polys[n].vertices[J][0]+oc*polys[n].vertices[J][1];
				
				
				//Now compare.
				//var bool:Boolean = compare(a,b,c,d,e,f,g,h);
				var bool:Boolean = compare(a,b,g,h,e,f,c,d);
				
				//trace("THE RESULT IS " + bool);
				
				//Adjust if sides pair up.
				if (bool) {
					
					//Move the (c,d) and (g,h) polygon. Simplify algebra.
					var u2:Number = polys[n].vertices[j][0];
					var v2:Number = polys[n].vertices[j][1];
					var u1:Number = polys[n].vertices[J][0];
					var v1:Number = polys[n].vertices[J][1];
					
					var newAngle:Number = Math.atan2(f-b,e-a);
					var oldAngle:Number = Math.atan2(v2-v1,u2-u1);
					var changeAngle:Number = newAngle - oldAngle;
					
					polys[n]._rotation = 180*changeAngle/Math.PI;
					
					var psi:Number = Math.PI*polys[n]._rotation/180;
					var cos:Number = Math.cos(psi);
					var sin:Number = Math.sin(psi);
					
					var temp:Number = cos*u1-sin*v1; 
					v1 = sin*u1+cos*v1;
					u1 = temp;
					
					polys[n]._x = a-u1;
					polys[n]._y = b-v1;
					
					
					
					//End now.
					return bool;
				}
			}
		}
		return false;
	}
	
	//Compares the four vertices, (a,b) and (c,d), (e,f) and (g,h).
	private function compare(a,b,c,d,e,f,g,h:Number):Boolean {
		/*
		trace("a = "+a);
		trace("b = "+b);
		trace("c = "+c);
		trace("d = "+d);
		trace("e = "+e);
		trace("f = "+f);
		trace("g = "+g);
		trace("h = "+h);
		*/
	 	if ( ((a-c)*(a-c)+(b-d)*(b-d) < epsilon) && 
			 ((e-g)*(e-g)+(f-h)*(f-h) < epsilon) ) return true;
		else return false;
	}
}