﻿
class Polygon extends MovieClip {

	//The vertices of the polygon.
	private var vertices:Array = null;
	
	//The initial angle of rotation of the selected vertex.
	private var angle:Number = null;
	
	//If this is on then the polygon starts rotating.
	private var rotatorOn:Boolean = false;
		
	//Constructor.
	function Polygon() {
		init();
	}
	
	//Initialise the polygon.
	private function init() {
		
		//Create empty movieclip to hold the polygon.
		this["poly"].removeMovieClip();
		this.createEmptyMovieClip("poly",this.getNextHighestDepth());
		
		//Initialise the polygons.
		initVertices();
		
		//Draw the polygon.
		drawPoly();
		
		//Control the poly.
		polyControls();
		
		//Attach one blob per vertex.
		attachBlobs();
	}
	
	private function attachBlobs():Void {
		for (var i:Number = 0 ; i!= vertices.length; i++) {
			var bob = attachMovie("blob","blob"+i,this.getNextHighestDepth());
			bob._alpha=70;
			bob._visible = false;
			bob._x = vertices[i][0];
			bob._y = vertices[i][1];
		}
	}
	
	
	//Initialise vertices. If not specified then default is triangle.
	private function initVertices() {
		if (vertices == null) {
			vertices = new Array(3);
			vertices[0] = [-30,0];
			vertices[1] = [15,Math.sqrt(3)*15];
			vertices[2] = [15,-Math.sqrt(3)*15];	
		}
	}
	
	//Input different colours.
	private var colors:Array = [0xcc0000, 0xffffff];
	
	//Draw the polyon.
	private function drawPoly() {
		 var fillType:String = "linear";
		 var alphas:Array = [100, 100];
		 var ratios:Array = [0, 255];
		 var matrix:Object = {matrixType:"box", x:-50, y:-50, w:150, h:100, r:(60/180)*Math.PI};
		this["poly"].lineStyle(2, 0x000000, 100);
		this["poly"].beginGradientFill(fillType, colors, alphas, ratios, matrix);
		this["poly"].moveTo(vertices[0][0],vertices[0][1]);
		for (var i:Number = 0; i!=vertices.length; i++) 
			this["poly"].lineTo(vertices[i][0],vertices[i][1]);
	    this["poly"].lineTo(vertices[0][0],vertices[0][1]);
		this["poly"].endFill();
	}
	
	//Control of the polygon, startdrag etc.
	private function polyControls() {
		this.onPress = pressControl;
		this.onRelease = releaseControl;
		this.onReleaseOutside = releaseControl;
		this.onMouseMove = mouseMoveControl;
	
	}
	
	//The polygon is pressed.
	private function pressControl() {
		//Different control depending on whether pressed near vertex or not.
		var b:Number = nearVertex(_level0._xmouse,_level0._ymouse);
		
		//Either near vertex of not near vertex.
		if (b != -1) {
			//What is initial angle of vertex b.
			angle = Math.atan2(vertices[b][1],vertices[b][0]);
			
			//Turn the rotator on!
			rotatorOn = true;
			
			
		} else {
			this.startDrag();
		}
		//trace("hello");
	}
	
	//Determine if the polygon press is near a vertex. Returns vertex number.
	private function nearVertex(x:Number,y:Number):Number {
		//trace("nearVertex");
		var vertex:Number = -1;
		for (var i:Number=0; i!= vertices.length; i++) {
			//Calculate position of vertex.
			var c:Number = Math.cos(Math.PI*this._rotation/180);
			var s:Number = Math.sin(Math.PI*this._rotation/180);
			var ver1:Number = this._x+c*vertices[i][0]-s*vertices[i][1];
			var ver2:Number = this._y+s*vertices[i][0]+c*vertices[i][1];
			if ( squareSep(ver1,ver2,x,y) < 150 ) vertex = i;
		}
		//if (bool) trace("jhj");
		return vertex;
	}
		
	//Square of separation between (a,b) and (c,d).
	private function squareSep(a,b,c,d:Number):Number {
		return (a-c)*(a-c)+(b-d)*(b-d);
	}
	
	//Release of the polygon pressing.
	private function releaseControl() {
		//Stop dragging!
    	this.stopDrag();
		//Hide the arrows.
		this._parent._parent["arrows"]._visible = false;
		//Give us the cursor back!
		Mouse.show();
		//Stop the mouse rotating.
		rotatorOn = false;
		
	}
	
	//Rotate the poly.
	private function mouseMoveControl() {
		//Change symbol if near vertex.
		var b:Number = nearVertex(_level0._xmouse,_level0._ymouse);
		
		//Show white blobs if near vertex.
		if (b!=-1) this["blob"+b]._visible = true;
		else {
			for (var i:Number = 0; i!=vertices.length; i++)
				this["blob"+i]._visible = false;
		}
		
		
		//Only operate if specified by rotatorOn.
		if (rotatorOn) {
			//Calculate angle of cursor.
			var cursor=Math.atan2(_level0._ymouse-this._y,_level0._xmouse-this._x);
			//Alter rotation of polygon accordingly.
			this._rotation = 180*(cursor-angle)/Math.PI;
			
			
			updateAfterEvent();
		}
	}
	

	
	
	
}
	