﻿
class Wires extends MovieClip {
	
	//Count the wires.
	var wireCount:Number = 0;
	
	var start_x:Number = null; //The point from which the connecting line extends.
	var start_y:Number = null;

	var mouseListener:Object; //For mouse move.
	
	//The index of the currently selected icon. 
	var selectedIcon:Array = null;
	
	//Records which inputs have been considered already. done[i][1] for input 1 in icon i and done[i][2] for input 2.
	var done:Array;
	
	function Wires() {
		
		selectedIcon = new Array(2);
		
		//Mouse moves and draw line if necessary.
		mouseListener = new Object();
		mouseControl();
		
		//This consists of the temporary line only.
		this.createEmptyMovieClip("leadLine",this.getNextHighestDepth());
		
		done = new Array(300);
		for (var i:Number = 0; i!=300; i++) done[i] = [0,0,0];
	}
	
	//Control of mouse.
	private function mouseControl():Void {
		
		var m = this;
		
		mouseListener.onMouseMove = function() {
			if (m.start_x != null) {
				m["leadLine"].clear();
				m["leadLine"].lineStyle(2,0xff0000,80);
    			m["leadLine"].moveTo(m.start_x,m.start_y);
				m["leadLine"].lineTo(_level0._xmouse,_level0._ymouse);
    			updateAfterEvent();
			}
		}
		mouseListener.onMouseUp = function() {
			
			//Only do anything if we are currently drawing a line.
			if (m.start_x != null) {
			
				var p = Math.round(m._xmouse/20)*20;
				var q = Math.round(m._ymouse/20)*20;
				//trace(p);
				//trace(q);
				m.checkCounters(m.start_x,m.start_y,p,q);
			
				//Reset this thing.
				//m.selectedIcon = null;
				
				//Reset start_x and start_y.
				m.start_x = m.start_y = null;
			
				//Clear the red line.
				m["leadLine"].clear();
			}
		}
		Mouse.addListener(mouseListener);
	}
	
	//Check if the mouse has landed at a position of a connector. Landing pos p,q.
	//The wire starts from s,t.
	function checkCounters(s:Number,t:Number,p:Number,q:Number):Boolean {

		//trace(selectedIcon);
		//trace("s = " + s + " t = " + t + " p = " + p + " q = " + q);
		var tp = this._parent;
		var I:Number = null; //The successful index.
		var J:Number = null; //Input button either 1 or 2.
		
		//Check to see if have landed on a red spot.
		for (var i:Number = 0; i!=tp.icons.length; i++) { 
			//var temp3 = tp.icons[i]._x;+tp.icons[i]["input_btn1"]._x
			//var temp4 = tp.icons[i]._y+tp.icons[i]["input_btn1"]._y
			//trace("i3 =  "+temp3);
			//trace("i4 =  "+temp4);
			
			
			if( p==tp.icons[i]._x+tp.icons[i]["input_btn1"].X && q==tp.icons[i]._y+tp.icons[i]["input_btn1"].Y ){
				I=i; J=1; break;
			}
			if( p==tp.icons[i]._x+tp.icons[i]["input_btn2"].X && q==tp.icons[i]._y+tp.icons[i]["input_btn2"].Y ){
				I=i; J=2; break;
			}   
			
			//trace(tp.icons[i].connectToInput1);
		}
		
		//Return false if have missed, or if icon[I] already has an input, or if have hit self.
		if (I==null || (J==1 & tp.icons[I].connectToInput1.length>0) || 
		   (J==2 & tp.icons[I].connectToInput2.length>0) || I==selectedIcon[0] ) return false;
		else {
			//Update state of input icon.
			if (J==1) tp.icons[I].connectToInput1 = selectedIcon;
			else if (J==2) tp.icons[I].connectToInput2 = selectedIcon;
			
			//Update state of output icon.
			if (selectedIcon[1]==1) tp.icons[selectedIcon[0]].connectFromOutput1.push([I,J]);
			else if (selectedIcon[1]==2) tp.icons[selectedIcon[0]].connectFromOutput2.push([I,J]);
	
			
			//trace("connectors = "+tp.icons[selectedIcon[0]].connectFromOutput1);
			
			//Change alpha of icons so that they are more visible.
			tp.icons[selectedIcon[0]]._alpha = 100;
			tp.icons[I]._alpha = 100;
			
			Wire(attachMovie("Wire","wire"+wireCount,this.getNextHighestDepth(),
			{_x:s,_y:t,finish_x:p-s,finish_y:q-t,startCode:selectedIcon,endCode:[I,J]}));
			wireCount++;
			
			//Now run electricity through the thing.
			electrify();
			
			//Small problem. Need to change the state of a Connector even if there's no electricity. Hence 
			//include the lines:
			tp.icons[I].changeState(); tp.icons[selectedIcon[0]].changeState();
		}
	}
	
	//Call this function when I need to redraw all the wires.
	function rewire() {
		var tp = this._parent;
		for (var i:Number = 0; i!=wireCount; i++) {
			//Only do anything if wire hasn't been deleted.
			if (this["wire"+i]._name != undefined) {
				var m = this["wire"+i];
				var a = this["wire"+i].startCode[0];
				var b = this["wire"+i].startCode[1];
				var c = this["wire"+i].endCode[0];
				var d = this["wire"+i].endCode[1];
			
				m._x = tp.icons[a]["output_btn"+b].X+tp.icons[a]._x;
				m._y = tp.icons[a]["output_btn"+b].Y+tp.icons[a]._y;
				m.finish_x = tp.icons[c]["input_btn"+d].X+tp.icons[c]._x-m._x;
				m.finish_y = tp.icons[c]["input_btn"+d].Y+tp.icons[c]._y-m._y;
			
				m.drawWire();
			}
		}	
	}
	
	//Put electricity through everything.
	function electrify() {
		
		//Idea is to go through the icons and change electricity type, if appropriate.
		//Start with power points. Then move on to all things connected to power points. Then all things
		//connected to those things connected to power points, and so forth.
		
		//So we need a function that changes the state of all things connected to it.
		
		var tp = this._parent;
		
		//Apply recursive procedure to each of the power blocks.
		for (var i:Number = 0; i!=tp.icons.length; i++) {
			if (tp.icons[i]._name.substr(0,3) == "pow") {
				
				//Reset the done array for each power pack. This reduces contradictions in flip flop circuits.
				for (var j:Number = 0; j!= tp.icons.length; j++) done[j] = [0,0,0];
				
				electrifyRecursively(tp.icons[i]); 
				
				}
		}
		
		//trace("make it to here?");
		
		//Now change colour of wires.
		electrifyWires();
	}
	
	
	
	//Given an icon, change state of all other icons which are outputs of this icon. Then do this recursively.
	function electrifyRecursively(ic:Icon) {
		var tp = this._parent;
		
		//If a circuit feeds into itself then we may get a contradiction. We can make the solution to that be that 
		//if either input1 or input2 has already been dealt with, then we do not return to it again. This makes sure each
		//wire is handled once and only once. Hence I create the array done.
		
		//If a circuit feeds into itself then we get an infinite loop. I have a problem in that I'm getting infinite loops
		//of nulls so that nothing lights up. I'll make it so that we go twice round the loop; the first time with null
		//and the second time with false.
			
		//trace("ic = " + ic);
		//trace("ic.n_outputs = " + ic.n_outputs);
		
		//Change the output connections.
		for (var k:Number = 1; k != ic.n_outputs+1 && ic.n_outputs>0; k++) {
			
			//Change state of all neighbours to output k.
			var L = (k==1) ? ic.connectFromOutput1.length : ic.connectFromOutput2.length;
			//trace("ic.connectFromOutput1.length = " + ic.connectFromOutput1.length);
			//trace("L = " + L);
			for (var i:Number = 0; i!=L; i++) {
				
				//Some variables dpending on whether k is 1 or 2.
				var I = (k==1) ? ic.connectFromOutput1[i][0] : ic.connectFromOutput1[i][0];
				var J = (k==1) ? ic.connectFromOutput1[i][1] : ic.connectFromOutput1[i][1];
				var out = (k==1) ? ic.output1 : ic.output2;
				
				/*
				trace("k = "+k);
				trace("I = "+I);
				trace("J = "+J);
				trace("out = "+out);
				trace("tp.icons[I].input1 = "+tp.icons[I].input1);
				trace("tp.icons[I].input2 = "+tp.icons[I].input2);
				trace("done[I][J] = "+done[I][J]);
				*/
				
				//This thing being set to 30 means that flip flops do not crash, but do not work either.
				if (done[I][J] <30) {
					if (J==1) tp.icons[I].input1 = (out==null) ? null : out;
					else if (J==2) tp.icons[I].input2 = (out==null) ? null : out;
					tp.icons[I].changeState();	
					done[I][J]++;
					electrifyRecursively(tp.icons[I]);			
				}
			}
		}
		
	}
	
	
	//Check through wires and change colour if necessary. Part of electrify function.
	function electrifyWires() {
		var tp = this._parent;
		for (var i:Number = 0; i!=wireCount; i++){
			if (this["wire"+i]._name != undefined) {
				var m = this["wire"+i];
				var a = this["wire"+i].startCode[0];
				var b = this["wire"+i].startCode[1];
		
				//If input is on then turn to yellow else turn to black.
				if ( (b==1 && tp.icons[a].output1) || (b==2 && tp.icons[a].output2) )
					m.colour = 0xff9900;
				else if ( (b==1 && !tp.icons[a].output1) || (b==2 && !tp.icons[a].output2) )	
					m.colour = 0x000000;
			}
		}
		
		rewire();
	}
	
	//Reset all states to neutral.
	function neutralise() {
		var icons = this._parent.icons;
		for (var i:Number = 0; i!=icons.length; i++) {
			if (icons[i]._name.substr(0,3) != "pow") {
				icons[i].input1=icons[i].input2=icons[i].output1=icons[i].output2=false;
				
				//Make sure inputs without a connection are set to null.
				if ( !(icons[i].connectToInput1>0) ) { icons[i].input1 = icons[i].output1=icons[i].output2 = null; }
				if ( !(icons[i].connectToInput2>0) ) { icons[i].input2 = icons[i].output1=icons[i].output2 = null; }
				
				if (icons[i]._name.substr(0,3) == "spl" || icons[i]._name.substr(0,3) == "bul")  
					icons[i].gotoAndStop(1);		
			}
			
			icons[i].changeState();
		}
		for (var i:Number = 0; i!=icons.length; i++) {
			this["wire"+i].colour = 0x000000;
			this["wire"+i].drawWire();
		}
		
	}
	
}