﻿
class CircuitBoard extends MovieClip {
	
	var intervalID:Number = null; //For scrolling control panel.
	var panelUp:Boolean = true; //True iff panel on display.
	
	var bPanel:Boolean = false; //True iff panel should appear.
	var bConfig:Boolean = true; //True iff should read the config file.
	var bSave:Boolean = true; //Save button visible?
	
	var icons:Array; //Array of icons.
	
	var config:Config;
	
	//redundant i think:
	//var intID:Number;
	
	function CircuitBoard() {
		
		//Attach background.
		this.attachMovie("background","background",this.getNextHighestDepth(),{_alpha:50});
		
		//Draw grid on top of background.
		drawGrid();
		
		//NRICH logo.
		this.attachMovie("logo","logo",this.getNextHighestDepth(),{_x:235,_y:310,_alpha:80});
		
		
		//Make panel appear.
		if (bPanel) {
		
			//Create the panel.
			createPanel();
		
			//Mask the panel.
			maskPanel();
		} 
		
		//What happens when icon buttons are pressed.
		icons = new Array();
		iconsPressed();
		
		
		//Create movieclip in which lines can lie.
		Wires(this.attachMovie("Wires","wires",this.getNextHighestDepth()));
		
		//redundant?
		//intID = setInterval(this, "startConfig", 500);
		
		//Call the config file.
		if (bConfig) {	
			var config = new Config();
			if (config.icons.length>0) setup(config.icons);
		}
		
		
		//Save button.
		this["save_btn"]._x += (bSave) ? 0 : 400;
		if (bSave) {
			this["save_btn"].swapDepths(this.getNextHighestDepth());
			this["save_btn"].onPress = function() { this._parent.save(); }
		}
		
	}
	
	//don't think i need this function:
	/*
	function startConfig() {
		//trace(this);
		//Call the config file.
		if (bConfig) {	
			//trace("er");
			var config = new Config();
			setup(config.icons);
		}
		clearInterval(intID);
	}
	*/
	
	//Set up circuit. This function only gets called
	function setup(a:Array) {
		
		//First create the icons.
		for (var i:Number = 0; i!= a.length; i++) 
			newIcon(a[i].type,a[i].x,a[i].y,a[i].rotation,a[i].gateType,false);
		
		//Now create the connections.
		for (var i:Number = 0; i!= a.length; i++) {
			
			//Only do something if not null.
			for (var j:Number = 1; j!=3; j++) {
				
				var inp = (j==1) ? a[i].input1 : a[i].input2;
				
				if (inp != null && inp.length > 0) {
					//Update input icon.
					if (j==1) this.icons[i].connectToInput1 = inp;
					else if (j==2) this.icons[i].connectToInput2 = inp;
					
					//Update output icon.
					if (inp[1]==1) this.icons[inp[0]].connectFromOutput1.push([i,j]);
					else if (inp[1]==2) this.icons[inp[0]].connectFromOutput2.push([i,j]);
				
					//Add a wire.
					var w = this["wires"];
					var IN = (j==1) ? icons[i]["inputButton1"] : icons[i]["inputButton2"];
					var OUT = icons[inp[0]]["outputButton"+inp[1]];
				
					Wire(w.attachMovie("Wire","wire"+w.wireCount,w.getNextHighestDepth(),
					{_x:OUT.X,_y:OUT.Y,finish_x:IN.X,finish_y:IN.Y,startCode:inp,endCode:[i,j]}));
					w.wireCount++;
				}
			}
			
			//trace("a["+i+"] = "+a[i].connectFromOutput1)
			
		}
		
			
			
		//Now run electricity through the thing.
		this["wires"].electrify();
			
		
		
		
	}
	
	//Draw background grid.
	private function drawGrid():Void {
		this.createEmptyMovieClip("grid",this.getNextHighestDepth());
		this["grid"].lineStyle(1,0xffffff,100);
		for (var i:Number = 0; i != 29; i++) {
			this["grid"].moveTo(20*i,0);this["grid"].lineTo(20*i,400);
			if (i<21) {
				this["grid"].moveTo(0,20*i); this["grid"].lineTo(560,20*i);
			}
		}
	}
	
	//Create the panel.
	private function createPanel():Void {
		this.attachMovie("Panel","Panel",this.getNextHighestDepth(),{_x:0,_y:0,_alpha:100});
		
		//Panel button.
		var m = this["Panel"]["pane_btn"];
		m.onPress = function() { this._parent._parent.scroll();} 
		
	}
	
	//Operates scrolling.
	function scroll() {
		if (intervalID == null) intervalID = setInterval(this, "action", 10);
	}
	
	//Action of scrolling.
	function action() {
		this["Panel"]._y = (panelUp) ? this["Panel"]._y-20 : this["Panel"]._y+20;
		
		if ( (panelUp && this["Panel"]._y<-380) || (!panelUp && this["Panel"]._y>0) ) {
			this["Panel"]._y = (panelUp) ? -380 : 0;
			panelUp = (panelUp) ? false : true;
			clearInterval(intervalID);
			intervalID = null;
		}
					
		updateAfterEvent();
	}
	
	//Mask the panel.
	private function maskPanel():Void {
		var m = this.createEmptyMovieClip("mask",this.getNextHighestDepth());
		m.lineStyle(1,0x000000,100);
		m.moveTo(0,0);
		m.beginFill(0x000000,100);
		m.lineTo(0,420); m.lineTo(560,420); m.lineTo(560,0); m.lineTo(0,0);
		m.endFill();
		this["Panel"].setMask(m);
	}
	
	//What happens when icon buttons pressed.
	private function iconsPressed():Void {
		var m:MovieClip;
		this["Panel"]["Power_btn"].onPress = 
		this["Panel"]["Gate_btn"].onPress = 
		this["Panel"]["Split_btn"].onPress = 
		this["Panel"]["Not_btn"].onPress = 
		this["Panel"]["Bulb_btn"].onPress =
		this["Panel"]["Connect_btn"].onPress =
		//this["Panel"]["Cross_btn"].onPress =
		function() { var tpp=this._parent._parent; tpp.newIcon(this._name,tpp._xmouse,tpp._ymouse,0,"AND",true); }
	}
	
	//Control of new icon.
	private function newIcon(s:String,X:Number,Y:Number,R:Number,t:String,drag:Boolean):Void {
		
		//trace("s = "+s);
		var m:Icon;
		var d:Number = this.getNextHighestDepth();
		if (s=="Power_btn") m = Power(attachMovie("Power","power"+icons.length,d)); 
		else if (s=="Gate_btn") m = Gate(attachMovie("Gate","gate"+icons.length,d));
		else if (s=="Split_btn") m = Split(attachMovie("Split","split"+icons.length,d)); 
		else if (s=="Not_btn") m = Not(attachMovie("Not","not"+icons.length,d)); 
		else if (s=="Bulb_btn") m = Bulb(attachMovie("Bulb","bulb"+icons.length,d)); 
		else if (s=="Connect_btn") { m = Connector(attachMovie("Connector","connector"+icons.length,d)); }
		//else if (s=="Cross_btn") { m = Cross(attachMovie("Cross","cross"+icons.length,d)); }
		m._x = X; m._y = Y;
		//trace(" second x mouse ="+_xmouse);
		if (drag) m.startDrag();
		m.index = icons.length;
		if (s!="Cross_btn" && drag) m._alpha = 60;
		icons.push(m); //Add a new icon to the list.
		
		//Adjust type of gate.
		if (s=="Gate_btn") m.type = t;
		m.toggleType(); m.toggleType(); m.toggleType(); m.toggleType(); m.toggleType(); m.toggleType();
		
		//Adjust rotation so that connectors are attached to properly.
		m._rotation = R;
		m.rotateConnectors();
			
				
		//Not very neat, but have to adjust X co-ordinate if s==connector.
		if (s=="Connect_btn") m["input_btn1"].X = m["output_btn1"].X = 0;
				
		
		//Need something to happen when connectors are pressed.
		m["output_btn1"].onPress = m["output_btn2"].onPress =
		function() {
			if (!m.disabled) {
				var N = Number(this._name.substr(10,1)); //trace("N = " + this._name.substr(10,1));
				this._parent._parent["wires"].selectedIcon = [this._parent.index,N];
			
				//Find the starting points and remember rotation. Can probably shorten this code using X and Y.	   
				this._parent._parent["wires"].start_x = this._parent._x + this.X;
				this._parent._parent["wires"].start_y = this._parent._y + this.Y;
			}
		}
		
	}
	
	

	//Press the save button to save.
	function save() {
		var s:String = "";
		
		//Have deleted some icons. Need to account for these deleted icons by giving everyone new labels.
		var A:Array = new Array(icons.length);
		var I:Number = 0;
		for (var i:Number = 0; i!=icons.length; i++) {
			if (icons[i]._name == undefined) {
				A[i] = null;
			} else {
				A[i] = I;
				I++;
			}
		}
		
		trace("A is "+A);
		
		for (var i:Number = 0; i!=icons.length; i++) {
			
			if (icons[i]._name != undefined) {
			
				var ic:String;
			
				if (icons[i]._name.substr(0,2) == "bu") ic = "\"Bulb_btn\"";
				else if (icons[i]._name.substr(0,2) == "po") ic = "\"Power_btn\"";
				else if (icons[i]._name.substr(0,2) == "co") ic = "\"Connect_btn\"";
				else if (icons[i]._name.substr(0,2) == "ga") ic = "\"Gate_btn\"";
				else if (icons[i]._name.substr(0,2) == "sp") ic = "\"Split_btn\"";
				else if (icons[i]._name.substr(0,2) == "no") ic = "\"Not_btn\"";
			
				s += "        icons["+A[i]+"] = new Object(); \n"
				s += "        icons["+A[i]+"].x = "+icons[i]._x+"; \n";
				s += "        icons["+A[i]+"].y = "+icons[i]._y+"; \n";
				s += "        icons["+A[i]+"].rotation = "+icons[i]._rotation+"; \n";
				s += "        icons["+A[i]+"].type = "+ic+"; \n";
				if (ic != "\"Gate_btn\"")
					 s += "        icons["+A[i]+"].gateType = null; \n";
				else s += "        icons["+A[i]+"].gateType = \""+icons[i].type+"\"; \n";
				if (icons[i].connectToInput1.length ==0)  
					 s += "        icons["+A[i]+"].input1 = null; \n";
				else s += "        icons["+A[i]+"].input1 = ["+A[icons[i].connectToInput1[0]]+","+icons[i].connectToInput1[1]+"]; \n";	
				if (icons[i].connectToInput2.length ==0)  
					 s += "        icons["+A[i]+"].input2 = null; \n";
				else s += "        icons["+A[i]+"].input2 = ["+A[icons[i].connectToInput2[0]]+","+icons[i].connectToInput2[1]+"]; \n";	
				
				
				/*
				
				//Extra stuff used for debugging. Remove this later:
				s += "        icons["+I+"].IN1 = "+icons[i].input1+"; \n";
				s += "        icons["+I+"].IN2 = "+icons[i].input2+"; \n";
				s += "        icons["+I+"].OUT1 = "+icons[i].output1+"; \n";
				s += "        icons["+I+"].OUT2 = "+icons[i].output2+"; \n";
	
				s += "        icons["+I+"].connectFromOutput1 = ["+icons[i].connectFromOutput1+"]; \n";
				s += "        icons["+I+"].connectFromOutput2 = ["+icons[i].connectFromOutput2+"]; \n";
				//end of extra stuff.
				
				*/
				
				s += "\n";
			}
		}
		//DO NOT DELETE THIS TRACE OUTPUT; IT GENERATES THE CONFIG DATA.
		trace(s);
	}
	
}