﻿class Board extends MovieClip {
	var i:Number;
	var j:Number;
	var where:Number;
	var board:Array; //0-24
	var counters:Array;
	var winner:Number;
	var line:MovieClip;
	var threeInRow:Array;
	var t0:Number;
	var t1:Number;
	var counter:MovieClip;
	var counterAdded:Number;
	function Board() {
		board = new Array;
		counters = new Array;
		for (var ii:Number = 0; ii<25; ii++) {
			board[ii] = 0;
		}
		threeInRow = new Array;
	}
	function addCounter(red:Boolean, number:Number) {
		_parent.depth++;
		where = number+12;
		if (board[where] == 0) {
			if (red) {
				counter = this.attachMovie("RedCounter", "rc"+_parent.depth, _parent.depth, {colour:true});
				board[where] = 1;
			}
			else {
				counter = this.attachMovie("BlueCounter", "bc"+_parent.depth, _parent.depth, {colour:false});
				board[where] = 2;
			}
			counter._alpha = 0;
			i = Math.floor(where/5);
			j = where - 5*i;
			//trace("(i,j) = ("+i+","+j+")");
			counter._x = j*70+10;
			counter._y = i*70+10;
			counters.push(counter);
			if (onEnterFrame == null) {
				trace("animate counter");
				t0 = getTimer();
				t1 = t0 + 5000; // 5000
				onEnterFrame = animateCounter;
			}
		}
		else {
			_parent.box.text = "Space is occupied!";
			trace("space occupied")
			counterAdded = -1;
		}
	}
	function animateCounter() {
		_parent.box.text = "Please, wait...";
		var sign:MovieClip;
		if (_parent.sign == 1) sign = _parent.plus;
		else sign = _parent.minus;
		var t:Number = getTimer();
		var progress:Number = (t-t0)/(t1-t0);
		//trace("progress: "+progress);
		if (progress <= 0.4) {
			counter._alpha = 100*(2.5*progress);
		}
		else if (progress <= 1) {
			_parent.diceNeg._alpha = 100*5/3*(1-progress);
			_parent.dicePos._alpha = 100*5/3*(1-progress);
			sign._alpha = 100*5/3*(1-progress);
		}
		else {
			onEnterFrame = null;
			counter._alpha = 100;
			_parent.diceNeg._alpha = 100;
			_parent.dicePos._alpha = 100;
			sign._alpha = 100;
			winner = checkWinners();
			trace("vyhral nekdo? "+winner);
			counterAdded = winner;
			_parent.endPlace(counter.colour);
		}
	}
	function removeCounters() {
		for (var ii:Number = 0; ii<counters.length; ii++) {
			trace(counters[ii]);
			counters[ii].removeMovieClip();
		}
		for (var ii:Number = 0; ii<25; ii++) {
			board[ii] = 0;
		}
		line.removeMovieClip();
	}
	// goes through all threes in a row - but it's dull :-( 
	function checkWinners():Number {
		//horizontal
		for (var k:Number = 0; k<5; k++) {
			for (var l:Number = 0; l<3; l++) {
				if ((board[5*k+l] != 0) && (board[5*k+l] == board[5*k+l+1])  
					&& (board[5*k+l] == board[5*k+l+2])) {
					threeInRow = [5*k+l,5*k+l+2];
					return board[5*k+l];
				}
			}
		}
		//vertical
		for (var l:Number = 0; l<5; l++) {
			for (var k:Number = 0; k<3; k++) {
				if ((board[5*k+l] != 0) && (board[5*k+l] == board[5*(k+1)+l])  
					&& (board[5*k+l] == board[5*(k+2)+l])) {
					threeInRow = [5*k+l,5*(k+2)+l];
					return board[5*k+l];
				}
			}
		}
		//diagonal
		for (var k:Number = 0; k<3; k++) {
			for (var l:Number = 0; l<3-k; l++) {
				if ((board[5*(k+l)+l] != 0) && (board[5*(k+l)+l] == board[5*(k+l+1)+l+1])  
					&& (board[5*(k+l)+l] == board[5*(k+l+2)+l+2])) {
					threeInRow = [5*(k+l)+l,5*(k+l+2)+l+2];
					return board[5*(k+l)+l];
				}
			}
		}
		for (var l:Number = 1; l<3; l++) {
			for (var k:Number = 0; k<3-l; k++) {
				if ((board[5*k+(l+k)] != 0) && (board[5*k+(l+k)] == board[5*(k+1)+(l+k)+1])  
					&& (board[5*k+(l+k)] == board[5*(k+2)+(l+k)+2])) {
					threeInRow = [5*k+(l+k),5*(k+2)+(l+k)+2];
					return board[5*k+(l+k)];
				}
			}
		}
		for (var k:Number = 2; k<5; k++) {
			for (var l:Number = 0; l<k-1; l++) {
				if ((board[5*(k-l)+l] != 0) && (board[5*(k-l)+l] == board[5*(k-l-1)+l+1])  
					&& (board[5*(k-l)+l] == board[5*(k-l-2)+l+2])) {
					threeInRow = [5*(k-l)+l,5*(k-l-2)+l+2];
					return board[5*(k-l)+l];
				}
			}
		}
		for (var l:Number = 1; l<3; l++) {
			for (var k:Number = 5-l; k<5; k++) {
				if ((board[5*k+l] != 0) && (board[5*k+l] == board[5*(k-1)+l+1])  
					&& (board[5*k+l] == board[5*(k-2)+l+2])) {
					threeInRow = [5*k+l,5*(k-2)+l+2];
					return board[5*k+l];
				}
			}
		}
		return 0;
	}
	function drawLine(n:Number) {
		_parent.depth++;
		line = createEmptyMovieClip("line", _parent.depth);
		trace("draw line");
		line.lineStyle(8, 0x33CC00);
		var from:Number = threeInRow[0];
		var to:Number = threeInRow[1];
		i = Math.floor(from/5);
		j = from - 5*i;
		trace("from: "+i+", "+j);
		line.moveTo(j*70+35,i*70+35);
		i = Math.floor(to/5);
		j = to - 5*i;
		trace("to: "+i+", "+j);
		line.lineTo(j*70+35,i*70+35);
	}
}