﻿import flash.filters.BevelFilter;

class Counter extends MovieClip {
	
	var radius:Number = 8; //Radius of disc.
	
	var numberSquares:Number;
	var squareSize:Number;
	
	var n:Number = 50; //These three variables used for hopping.
	var I:Number = 0;
	var intervalID:Number = null;
	
	var pos:Array; //(i,j) = (pos[0],pos[1]) of the counter.
	
	//Two modes. True, and the counter just gets dragged around. False, then arrows appear to make it hop.
	var moveMode:Boolean = true;
	
	//Constructor.
	function Counter(p,q:Number) {
		
		//Draw counter.
		drawCounter();
		
		//What happens when press counter.
		counterControls();
	}
	
	//Draw the counter.
	function drawCounter() {
		this.createEmptyMovieClip("Narrow",this.getNextHighestDepth());
		this.createEmptyMovieClip("Earrow",this.getNextHighestDepth());
		this.createEmptyMovieClip("Sarrow",this.getNextHighestDepth());
		this.createEmptyMovieClip("Warrow",this.getNextHighestDepth());
		this.createEmptyMovieClip("spot",this.getNextHighestDepth());
		
		this["Narrow"].lineStyle(0,0x006633,0);
		drawArrow(this["Narrow"],0,-1);
		this["Earrow"].lineStyle(0,0x006633,0);
		drawArrow(this["Earrow"],1,0);
		this["Sarrow"].lineStyle(0,0x006633,0);
		drawArrow(this["Sarrow"],0,1);
		this["Warrow"].lineStyle(0,0x006633,0);
		drawArrow(this["Warrow"],-1,0);
		
		resetAlpha(0,0,0,0);
		
		this["spot"].lineStyle(0,0x000000,0);
		drawCircle(this["spot"],0,0,radius);
		
		// Creates a variable with info about the Filter settings
    	var myBevelFilter = new BevelFilter (5,45,0xffffff,1,0x000000,1,5,5,1,3,"inner",false);
		this["spot"].filters = [myBevelFilter];		
	}
	
	//Draw a circle centre (x,y) radius r.
	function drawCircle(mc:MovieClip, x:Number, y:Number, r:Number):Void {
 	   mc.moveTo(x+r, y);
	   mc.beginFill(0x666666,100);
       mc.curveTo(r+x, Math.tan(Math.PI/8)*r+y, Math.sin(Math.PI/4)*r+x, 
       Math.sin(Math.PI/4)*r+y);
       mc.curveTo(Math.tan(Math.PI/8)*r+x, r+y, x, r+y);
       mc.curveTo(-Math.tan(Math.PI/8)*r+x, r+y, -Math.sin(Math.PI/4)*r+x, 
       Math.sin(Math.PI/4)*r+y);
       mc.curveTo(-r+x, Math.tan(Math.PI/8)*r+y, -r+x, y);
       mc.curveTo(-r+x, -Math.tan(Math.PI/8)*r+y, -Math.sin(Math.PI/4)*r+x, 
       -Math.sin(Math.PI/4)*r+y);
       mc.curveTo(-Math.tan(Math.PI/8)*r+x, -r+y, x, -r+y);
       mc.curveTo(Math.tan(Math.PI/8)*r+x, -r+y, Math.sin(Math.PI/4)*r+x, 
       -Math.sin(Math.PI/4)*r+y);
       mc.curveTo(r+x, -Math.tan(Math.PI/8)*r+y, r+x, y);
	   this["picture"].endFill();
    }
	
	//Draw an arrow from (0,0) pointing in (a,b) direction. In our case (a,b) is a unit vector
	//so perpendicular vector is (-b,a).
	function drawArrow(mc:MovieClip,a:Number,b:Number):Void {
		var L:Number = radius*0.6;
		mc.moveTo(-b*L,a*L);
		mc.beginFill(0x006633,100);
		mc.lineTo(-b*L+a*L*2,a*L+b*L*2);
		mc.lineTo(-b*L*1.5+a*L*2,a*L*1.5+b*L*2);
		mc.lineTo(a*L*3,b*L*3);
		mc.lineTo(b*L*1.5+a*L*2,-a*L*1.5+b*L*2);
		mc.lineTo(b*L+a*L*2,-a*L+b*L*2);
		mc.lineTo(b*L,-a*L);
		mc.lineTo(-b*L,a*L);
		mc.endFill();
	}
	
	
	//Jump to new position (a,b). d is for deleteCounter 
	function jump(a,b,d:Number) {
		I=0;
		if (intervalID == null) intervalID = setInterval(this, "moveCounter", 4,this._x,this._y,a,b,d);
	}
	
	//Move the counter.
	function moveCounter(x,y,a,b,d:Number) {

		this._x = (a-x)*f(I)/(2*n*n) + x;
		this._y = (b-y)*f(I)/(2*n*n) + y;
		
		this._xscale = this._yscale = 100 + g(I);
		
		if (I==n && d!=null) this._parent["soldier"+d].removeMovieClip();
		
		if (I==2*n) {
			clearInterval(intervalID);
			intervalID = null;
			this._x = a;
			this._y = b;
		}
		updateAfterEvent();
		I++;
	}
	
	//function f, for varying speed of hop.
	function f(i:Number):Number {
		if (i<=n) return i*i;
		else return -(2*n-i)*(2*n-i)+2*n*n;
	}
	
	//function g, for varying _scale of hop.
	function g(i:Number):Number {
		return 100*(1 - (i-n)*(i-n)/(n*n));
	}
	
	//Control of counter.
	function counterControls() {
		this.onPress = function() {
			this["tipper"].hide(300);
			//if (moveMode) this.startDrag(); 
			//else { resetAlpha(0,0,0,0); jumpControl(); } 
			if (!moveMode) { resetAlpha(0,0,0,0); jumpControl(); }
		}
		//Don't need to do anything now if not in moveMode
		//this.onRelease = function() { if (moveMode) control(); }
		//this.onReleaseOutside = function() { if (moveMode) control(); else resetAlpha(0); }
		this.onRollOver = function() {
			if (moveMode && pos[0]==numberSquares-1 && pos[1]==numberSquares-1) {
				this["tipper"].text = "Place your soldiers below the black line.";
				this["tipper"].show(500,true);
			}
			if (!moveMode && !(pos[0]==numberSquares-1 && pos[1]==numberSquares-1)) {
				//Make arrows visible that are useable.
				var tp = this._parent;
				var N,E,S,W:Number;
				N = (tp.occupied[pos[0]][pos[1]-1] && !tp.occupied[pos[0]][pos[1]-2]) ? 30 : null;
				if (pos[0]+2<numberSquares) {
					E = (tp.occupied[pos[0]+1][pos[1]] && !tp.occupied[pos[0]+2][pos[1]]) ? 30 : null;
				}
				if (pos[1]+2<numberSquares) {
					S = (tp.occupied[pos[0]][pos[1]+1] && !tp.occupied[pos[0]][pos[1]+2]) ? 30 : null;
				}
				if (pos[0]-2>-1) {
					W = (tp.occupied[pos[0]-1][pos[1]] && !tp.occupied[pos[0]-2][pos[1]]) ? 30 : null;
				}
				resetAlpha(N,E,S,W);
			}
		}
		this.onMouseMove = function() {
			if (!moveMode && !(pos[0]==numberSquares-1 && pos[1]==numberSquares-1) && 
			(this["Narrow"]._alpha+this["Earrow"]._alpha+this["Sarrow"]._alpha+this["Warrow"]._alpha > 25) ) {
					if (_xmouse < -(radius-3) && this["Warrow"]._alpha>25 ) {
						resetAlpha(null,null,null,30); this["Warrow"]._alpha = 80; 
					} else if (_xmouse > (radius-3) && this["Earrow"]._alpha>25 ) {
						resetAlpha(null,30,null,null); this["Earrow"]._alpha = 80;
					} else if (_ymouse < -(radius-3) && this["Narrow"]._alpha>25) {
						resetAlpha(30,null,null,null); this["Narrow"]._alpha = 80;
					} else if (_ymouse > (radius-3) && this["Sarrow"]._alpha>25) {
						resetAlpha(null,null,30,null); this["Sarrow"]._alpha = 80;
					} else {
						if (this["Narrow"]._alpha>75) resetAlpha(30,null,null,null);
						if (this["Earrow"]._alpha>75) resetAlpha(null,30,null,null);
						if (this["Sarrow"]._alpha>75) resetAlpha(null,null,30,null);
						if (this["Warrow"]._alpha>75) resetAlpha(null,null,null,30);
					}
			}
		}
		this.onRollOut = function() { resetAlpha(0,0,0,0); }
	}
	
	//When release counter.
	function control() {
		
		var tp = this._parent;
		
		this.stopDrag();
		//Calculate nearest square.
		var p:Number = Math.floor(this._x/squareSize);
		var q:Number = Math.floor(this._y/squareSize);
		
		if (tp.occupied[p][q] || p>numberSquares-1 || p<0 || q>numberSquares-1 || q<0) {
			//Return to where you were.
			trace("outside");
			tp.occupied[pos[0]][pos[1]] = false;
			this.removeMovieClip();
			this._x = (pos[0]+0.5)*squareSize;
			this._y = (pos[1]+0.5)*squareSize;
		} else {
			this._x = (p+0.5)*squareSize;
			this._y = (q+0.5)*squareSize;
			
			//Change occupied squares.
			tp.occupied[p][q] = true;
			if (pos[0]==numberSquares-1 && pos[1]==numberSquares-1) tp.newSoldier(numberSquares-1,numberSquares-1);
			else tp.occupied[pos[0]][pos[1]] = false;
			pos = [p,q];
			
		}
	}
	
	//Determine whether we are able to jump.
	function jumpControl() {
		//Work out destination square.
		var tp = this._parent;
		var p,q,r,s:Number; // (p,q) destination spot. (r,s) the spot in between.
		p = r = pos[0]; q = s = pos[1];
		
		//trace(_xmouse);
		//trace(this._x);
		
		if (_xmouse < -(radius-3)) {p = pos[0]-2; r = pos[0]-1;}
		if (_xmouse > (radius-3)) {p = pos[0]+2; r = pos[0]+1;}
		if (_ymouse < -(radius-3)){q = pos[1]-2; s = pos[1]-1;}
		if (_ymouse > (radius-3)) {q = pos[1]+2; s = pos[1]+1;}
		
		if ( p>-1 && p<numberSquares && q>-1 && q<numberSquares && !tp.occupied[p][q]
			&& tp.occupied[r][s] && !(pos[0]==numberSquares-1 && pos[1]==numberSquares-1) ) {
			
			var u = (p+0.5)*squareSize;
			var v = (q+0.5)*squareSize;
			
			
			var deleteCounter:Number = null;
			//Search for the leapfrogged counter and remove it.
			for (var i:Number = 0; i!=tp.tag; i++) {
				if (tp["soldier"+i].pos[0]==r && tp["soldier"+i].pos[1]==s) 
					deleteCounter = i; 
			}
			
			if (tp["soldier"+deleteCounter].getDepth() > this.getDepth() )
				this.swapDepths(tp["soldier"+deleteCounter]);
			
			jump(u,v,deleteCounter)
			
			tp.occupied[pos[0]][pos[1]] = false;
			tp.occupied[r][s] = false;
			tp.occupied[p][q] = true;
			pos = [p,q];
			
			resetAlpha(0,0,0,0);
			
			//Now possibly display you win sign.
			if (p==7 && q<7) {
				
				var skipit:Boolean = false;
				if (q==6 && tp.target == null) tp.target = "A";
				else if (q==5 && tp.target=="A") tp.target = "B";
				else if (q==4 && tp.target=="B") tp.target = "C";
				else if (q==3 && tp.target=="C") tp.target = "D";
				else if (q==2 && tp.target=="D") tp.target = "E";
				else skipit = true; //Skip loop if none of these.
				
				if (!skipit) {
					this._parent["success"]._visible = true;
					this._parent["success"].gotoAndPlay(1);
				}
			}
		}
	
	}
	
	function resetAlpha(N,E,S,W:Number) {
		this["tipper"].hide(300);
		if (N!=null) this["Narrow"]._alpha = N;
		if (E!=null) this["Earrow"]._alpha = E;
		if (S!=null) this["Sarrow"]._alpha = S;
		if (W!=null) this["Warrow"]._alpha = W;
	}
}