﻿import Counter;

class Board extends MovieClip {
	
	var squareSize:Number = 30;
	var numberSquares:Number = 15;	
	var tag:Number = 0; //Keep track of the number of soldiers inserted.	
	var attack:Boolean = false; //True iff we are in attacking mode.
	var occupied:Array; //Is square (i,j) occupied?
	var target:String = null;//The target square that gets hit.
	
	//Constructor.
	function Board() {
		
		//Initialise occupied array.
		occupied = new Array(numberSquares);
		for (var i:Number = 0; i!=numberSquares; i++) {
			occupied[i] = new Array(numberSquares);	
		}
		
		this["success"]._visible = false;
		
		drawGrid();
		buttons();
		
		this.attachMovie("instructions1","i1",this.getNextHighestDepth(),{_x:15,_y:290,_alpha:70});
		this.attachMovie("instructions2","i2",this.getNextHighestDepth(),{_x:15,_y:290,_alpha:70});
		
		//Need new control for when press square of grid when not in attack mode.
		gridPressControls();
	
		initialise(true);
		
	}
	
	//Initialise. animate=true iff want pick up animation to appear
	function initialise(animate:Boolean) {
		
		//Visibility of buttons.
		this["soldiers_btn"]._visible = false;
		this["attack_btn"]._visible = true;
		//trace(this["soldiers_btn"].getDepth());
		
		this["i1"]._visible = false;
		this["i2"]._visible = false;
		
		//Make all squares above line off limits.
		for (var i:Number = 0; i!=numberSquares; i++) 
			for (var j:Number = 0; j!=numberSquares; j++) 
				occupied[i][j] = (j<7) ? true : false;
		occupied[numberSquares][numberSquares] = true;
		
		//Remove all soldiers.
		for (var i:Number = 0; i!=tag; i++) 
			this["soldier"+i].removeMovieClip();
		
		tag = 0;
		attack = false;
		target = null;
		
		//newSoldier(numberSquares-1,numberSquares-1);
		
	}
	
	//This function activated once soliders are in place.
	function finalise() {
		
		//Change visible button.
		this["attack_btn"]._visible = false;
		this["soldiers_btn"]._visible = true;
			
		//Change state of army.
		attack = true;
		for (var i:Number = 0; i!=tag; i++) this["soldier"+i].moveMode = false; 
				
		for (var i:Number = 0; i!=numberSquares; i++)  	
			for (var j:Number = 0; j!=numberSquares; j++)
				if (j<7) occupied[i][j] = false;		
	}
	
	//Bring in a new soldier at position p,q .
	function newSoldier(p,q:Number) {
		var s = Counter(this.attachMovie("Counter","soldier"+tag,this.getNextHighestDepth(),{
		_x:(p+1/2)*squareSize,_y:(q+1/2)*squareSize,pos:[p,q],
		numberSquares:numberSquares,squareSize:squareSize}));
		occupied[p][q] = true;
		tag++;
	}
	
	
	
	//Draw the grid.
	function drawGrid() {
		this.createEmptyMovieClip("grid",-16385);
		this["grid"].lineStyle(1,0xcccccc,100);
		for (var i:Number = 0; i!=numberSquares+1; i++) {
			this["grid"].moveTo(i*squareSize,0); this["grid"].lineTo(i*squareSize,numberSquares*squareSize);
			this["grid"].moveTo(0,i*squareSize); this["grid"].lineTo(numberSquares*squareSize,i*squareSize);
		}
		
		//Draw the heavy line in.
		this["grid"].lineStyle(3,0x000000,100);
		this["grid"].moveTo(0,7*squareSize); this["grid"].lineTo(numberSquares*squareSize,7*squareSize);
	}
	
	//Bring in the buttons.
	function buttons() {
		
		this["attack_btn"].onPress = function() { this._parent.finalise(); }
		
		this["soldiers_btn"].onPress = function() { this._parent.initialise(true);}
		
		this["demoA"].onPress = function() {
			var tp = this._parent;
			tp.initialise(false);
			tp.newSoldier(7,7);
			tp.newSoldier(7,8);
			tp.finalise();
			tp["i1"]._visible = true;
		}
		this["demoB"].onPress = function() { 
			var tp = this._parent;
			tp.initialise(false);
			tp.newSoldier(7,7);
			tp.newSoldier(7,8);
			tp.newSoldier(8,7);
			tp.newSoldier(9,7);
			tp.finalise();
			tp["i2"]._visible = true;
		}
	}
	
	function gridPressControls() {
		var t = this;
		this.onMouseDown = function() {
			//Only do anything in not-attack mode.
			if (!t.attack) {
				//Locate square that is being pressed.
				var p = Math.floor(_xmouse/t.squareSize);
				var q = Math.floor(_ymouse/t.squareSize);
				
				
				//Only do anything if in grid.
				if ( p>-1 && p<15 && q>6 && q<15 && !(p<4 && q>12) ) {
					trace("p = " + p + " and q = "+q);
				    if (t.occupied[p][q]) {
						for (var i:Number = 0; i!=t.tag+1; i++) {
							if (t["soldier"+i].pos[0]==p && t["soldier"+i].pos[1]==q)	
								t["soldier"+i].removeMovieClip();
						}
						t.occupied[p][q] = false;
					} else {
						t.newSoldier(p,q);
						t.occupied[p][q] = true;
					}
				}
			}
		}
		
	}
	
	
	
}