﻿/**
	The Snapper class allows you to define snapping behaviour. The idea is that:
	   the centre of any object will snap to the centre of the snapper;
	   and the object will snap to that point if its centre lands anywhere on the snapper.

	How to use this class: 
 	1) Draw a MovieClip on the stage where you want things to snap.
	2) Draw it as big as the snap area.
	3) Attach it to this Snapper class in the usual way (Library > Properties > AS2.0 Class).
	4) Give it an instance name and tell the object about it.
	   In the example there's a line in the .fla actions that says:
	   greenDisc.snapper = snapper;
	5) In the objects onRelease function you can find out whether you are in the snap area by
	   calling snapper.inside(). This either returns a reference to the Snapper or null if you missed.
	6) Call the snap() function on the Snapper to do the snap.
	   
	   ObjectToDrag.as has some example code:
	   
	   	function onRelease():Void {
		this.stopDrag();
		if (snapper.inside(this)) {
			snapper.snap(this);
		}
		else {
			reset()
		}
	}

*/
	
class Snapper extends MovieClip {
	var cx:Number;
	var cy:Number;
	var snapperBounds:Object;
	function Snapper() {
		var snapperBounds:Object = this.getBounds(_parent);
		cx = (snapperBounds.xMin+snapperBounds.xMax)/2;
		cy = (snapperBounds.yMin+snapperBounds.yMax)/2;
		//this._visible = false;
	}
	function inside(ob:Object):Boolean { 
		var bounds:Object = MovieClip(ob).getBounds(ob._parent);
		var xx:Number = (bounds.xMin+bounds.xMax)/2;
		var yy:Number = (bounds.yMin+bounds.yMax)/2;
		return this.hitTest(xx, yy, true);
	}
	function snap(ob:Object) {
		var bounds:Object = MovieClip(ob).getBounds(ob);
		var dx:Number = (bounds.xMin+bounds.xMax)/2;
		var dy:Number = (bounds.yMin+bounds.yMax)/2;
		ob._x = cx - dx;
		ob._y = cy - dy;
	}
}