﻿import Board;
import flash.filters.BitmapFilter;
import it.sephiroth.tooltip;
import caurina.transitions.Tweener;

class LabCounter extends MovieClip {
	var _index:Number;
	//var indexField:TextField;
	var _row:Number;
	var _col:Number;
	var board:Board;
	var tt:tooltip;
	var _chosen:Boolean = false;
	var active:Boolean = true;
	static var tweening:Boolean = false;

	function LabCounter() {
		tt = _root.tooltip;
		_alpha = 30;
	}
	
	function get chosen():Boolean {
		return _chosen;
	}
	function set chosen(b:Boolean):Void {
		_chosen = b;
		_alpha = b ? 100 : 30;
	}
	
	function get index():Number {
		return _index;
	}
	function set index(n:Number):Void {
		_index = n;
		TextField(this["value"]).text = "" + Math.pow(2,_index);
	}
		
	
	function get row():Number {
		return _row;
	}
	
	function set row(r:Number):Void {
		//trace("set r="+r);
		_row = r;
		_y = board.rowy(r)-_height/2;
	}
	
	function get col():Number {
		return _col;
	}
	
	function set col(c:Number):Void {
		_col = c;
		_x = board.colx(c)-_width/2;
	}
	
	function onRollOver():Void {
		if(active)
			_alpha = 80;
	}
	function onRollOut():Void {
		if(active)
			_alpha = _chosen ? 100 : 30;
	}
	
	/*
	function onPress():Void {
		this.startDrag();
	}
	*/
	
	function onRelease():Void {
		if(!active) return;
		chosen = !chosen;
		board.labelChanged(this);
	}
}