﻿import Board;
import flash.filters.BitmapFilter;
import it.sephiroth.tooltip;
import caurina.transitions.Tweener;

class Counter extends MovieClip {
	var _index:Number;
	//var indexField:TextField;
	var _row:Number;
	var _col:Number;
	var board:Board;
	var tt:tooltip;
	var indexField:TextField;
	var twoField:TextField;
	var plusField:TextField;
	var id:Number;
	var readyToGo:Boolean = false;
	static var tweening:Number = 0;

	function Counter() {
		//board = Board(_parent);
		//indexField = ;
		tt = _root.tooltip;
		twoField = TextField(this["twoField"]);
		indexField = TextField(this["indexField"]);
		plusField = TextField(this["plus"]);
		plusField._visible = false;
		hideValue();
	}
	
	function get index():Number {
		return _index;
	}
	function set index(n:Number):Void {
		_index = n;
		TextField(this["indexField"]).text = "" + _index;
	}
	
	function set textColor(c:Number):Void {
		twoField.textColor = c;
		indexField.textColor = c;
	}
	
	function showValue():Void {
		this["equals"]._visible = true;
		this["value"]._visible = true;
		this["value"].text = "" + Math.pow(2,index);
		plusField._visible = true;
	}
	
	function hideValue():Void {
		this["equals"]._visible = false;
		this["value"]._visible = false;
		plusField._visible = false;
	}
	
	function set valueVisible(v:Boolean):Void {
		twoField._visible = v;
		indexField._visible = v;
	}
	
	function get valueVisible():Boolean {
		return twoField._visible;
	}
	
	function get row():Number {
		return _row;
	}
	
	function set row(r:Number):Void {
		//trace("set r="+r);
		_row = r;
		_y = board.rowy(r)-_height/2;
	}
	
	function get col():Number {
		return _col;
	}
	
	function set col(c:Number):Void {
		_col = c;
		_x = board.colx(c)-_height/2;
	}
	
	/*
	function onRollOver():Void {
		if(row == 0 || col == 0) {
			tt.text = ""+Math.pow(2,index);
			tt.show(100);
		}
	}
	function onRollOut():Void {
		tt.hide(0);
	}
	*/
	/*
	function onPress():Void {
		this.startDrag();
	}
	*/
	
	function startMove():Void {
		if(tweening > 0) return;
		if(finalCheck()) return;
		if(row > 0) {
			var newx:Number = board.colx(col+1) - _height/2;
			var newy:Number = board.rowy(row-1) - _height/2;
			//trace(_x + ":" + newx + "   " + _y + ":" + newy);
			tweening++;
			Tweener.addTween(this, {_x:newx, _y:newy, time:0.5, transition:"linear", onComplete:finishDiagonal});
			trace("diagonal");
		}
	}
	
	function onRelease():Void {
		if(readyToGo) 
			board.animateResult(board, id);
		else
			startMove();
		/*
		if(tweening > 0) return;
		if(row > 0) {
			if(finalCheck()) return;
			var newx:Number = board.colx(col+1) - _height/2;
			var newy:Number = board.rowy(row-1) - _height/2;
			//trace(_x + ":" + newx + "   " + _y + ":" + newy);
			tweening++;
			Tweener.addTween(this, {_x:newx, _y:newy, time:0.5, transition:"easeOutCubic", onComplete:finishDiagonal});
			trace("diagonal");
		}
		else {
			trace("Run off");
			board.animateResult(board, index);
		}
		*/
	}
	
	function finishDiagonal():Void {
		tweening--;
		if(!board.diagonalMove(row--,col++))
			startMove();
		else finalCheck();
	}
	
	function leftMove(erase:Counter):Void {
		//++col;
		var newx:Number = board.colx(col+1) - _height/2;
		tweening++;
		var eraser:Function = function():Void {
			tweening--;
			erase.remove();
			finishLeftMove();
		}
		Tweener.addTween(this, {_x:newx, time:0.5, transition:"easeOutCubic", onComplete:eraser});
		//board.leftMove(row,col++);
	}
	function finishLeftMove():Void {
		index++;
		if(!board.leftMove(row, col++))
			finalCheck();
	}
	
	function remove():Void {
		tweening++;
		Tweener.addTween(this, {_alpha:0, time:0.5, transition:"easeInOutCubic", onComplete:finishRemove});
		//_visible = false;
		//this.removeMovieClip();
	}
	function finishRemove():Void {
		_visible = false;
		tweening--;
		finalCheck();
	}
	
	function finalCheck():Boolean {
		trace("Check: tweening="+tweening);
		if(tweening == 0) 
			return board.finalCheck();
		else
			return false;
	}
	
	function set discVisibility(b:Boolean):Void {
		this["disc"]._visible = b;
	}
}