﻿import Counter;
import Counters;
import mx.controls.NumericStepper;
import mx.core.UIComponent;
import mx.controls.Button;
import mx.utils.Delegate;
import caurina.transitions.Tweener;


class Board extends UIComponent {
	
	var squares:Number = 8;
	var squareSize:Number = 31;
	var aStepper:TextField;
	var bStepper:TextField;
	var answer:TextField;
	var areg:TextField;
	var breg:TextField;
	var counters:Counters;
	var rowLabels:Array;
	var colLabels:Array;
	var grid:Array;
	var coloff:Number = 0.2;
	var instructions:MovieClip;
	var instructions2:MovieClip;
	var instructions3:MovieClip;
	var equals:MovieClip;
	var another:Button;
	
	function Board() {
		areg = this["areg"];
		breg = this["breg"];
		areg._visible = breg._visible = false;
		aStepper = this["aStepper"];
		bStepper = this["bStepper"];
		answer = this["answer"];
		another = this["another"];
		equals = this["equals"];
		equals._visible = false;
		drawGrid();
		drawLabels();
		counters = new Counters();
		doLater(this, "gotoSetup");
	}
	
	function drawGrid():Void {
		this.lineStyle(1,0,100);
		for(var i:Number=1; i <= squares*2; i++) {
			var greyOut = (i <= squares) ? 0x553333 :0;
			this.lineStyle(1,0,100);
			for(var j:Number = 1; j <= squares; j++) {
				if((i+j)>squares) {
					if((i+j) % 2 == 0) {
						drawSquare(0xaaaaaa-greyOut, i, j);
					}
					else {
						drawSquare(0xffffff-greyOut, i, j);
					}
				}
			}
		}
	}
	
	function drawSquare(rgb:Number, i:Number, j:Number):Void {
		var x0:Number = (i-coloff)*squareSize;
		var x1:Number = x0+squareSize;
		var y0:Number = j*squareSize;
		var y1:Number = y0+squareSize;
		moveTo(x0, y0);
		lineStyle(1,0,100);
		beginFill(rgb, 100);
		lineTo(x0, y1);
		lineTo(x1, y1);
		lineTo(x1, y0);
		lineTo(x0, y0);
		endFill();
	}
	
	function drawLabels():Void {
		colLabels = [];
		for(var i=0; i < squares; i++) {
			var label:LabCounter = LabCounter(attachMovie("LabCounter", "lcol"+i, 300+i, {index:i, col:i, row:-1, chosen:false, board:this}));
			attachMovie("Counter", "labrow"+i, 350+i, {index:i, col:i, row:-2, discVisibility:false, textColor:0xffffff, board:this});
			colLabels[i] = label;
		}
		rowLabels = [];
		for(var j=0; j < squares; j++) {
			var label:LabCounter = LabCounter(attachMovie("LabCounter", "lrow"+j, 400+j, {index:j, col:-1, row:j, chosen:false, board:this}));
			attachMovie("Counter", "labcol"+i, 370+j, {index:j, col:-2, row:j, discVisibility:false, textColor:0xffffff, board:this});
			rowLabels[j] = label;
		}
		calculateRegs();
	}
	
	function resetLabels():Void {
		for(var i:Number = 0; i < rowLabels.length; i++) {
			var label:LabCounter = rowLabels[i];
			label.chosen = false;
			label._visible = true;
			label.active = true;
		}
		for(var j:Number = 0; j < colLabels.length; j++) {
			var label:LabCounter = colLabels[j];
			label.chosen = false;
			label._visible = true;
			label.active = true;
		}
		calculateRegs();
	}
	
	function set labelEnabled(b:Boolean):Void {
		for(var i:Number = 0; i < rowLabels.length; i++) {
			var label:LabCounter = rowLabels[i];
			label.active = b;
		}
		for(var j:Number = 0; j < colLabels.length; j++) {
			var label:LabCounter = colLabels[j];
			label.active = b;
		}
	}
	
	function set labelVisibility(b:Boolean):Void {
		for(var i:Number = 0; i < rowLabels.length; i++) {
			var label:LabCounter = rowLabels[i];
			label._visible = true;
			//label.active = b;
		}
		for(var j:Number = 0; j < colLabels.length; j++) {
			var label:LabCounter = colLabels[j];
			label._visible = true;
			//label.active = b;
		}
	}
	
	function gotoSetup():Void {
		resetLabels();
		another.visible = false;
		answer.text = "?";
		equals._visible = false;
		another.onRelease = function() {
			_parent.gotoSetup();
		}
		if(instructions == null)
			instructions = attachMovie("SetupInstructions", "instructions", 700, {_y:rowy(6.5), _x:colx(6.5)});
		else
			instructions._visible = true;
		instructions3._visible = false;
		trace("calc :" + instructions["calcButton"]);
		instructions["calcButton"].onRelease = function() {
			_parent._parent.placeCounters(null);
		}
	}
		
	function placeCounters(evt:Object):Void {
		//trace("changed");
		//var u:Number = Number(areg.text);
		//var v:Number = Number(breg.text);
		if(instructions2 == null)
			instructions2 = attachMovie("Instructions2", "instructions2", 800, {_y:340, _x:50});
		trace("instructions2 on");
		instructions2._visible = true;
		instructions._visible = false;
		grid = [];
		for(var i:Number = 0; i < squares*2; i++) {
			grid[i] = [];
			for(var j:Number = 0; j < squares; j++) {
				grid[i][j] = [];
			}
		}
		counters.removeAll();
		labelEnabled = false;
		var c:Counter;
		var lasti:Number;
		var lastj:Number;
		var delay:Number = 0;
		for(var i:Number = 0; i <= squares; i++) {
			if(rowLabels[i].chosen) for(var j:Number = 0; j <= squares; j++) {
				lasti=i;
				if(colLabels[j].chosen) {
					lastj=j;
					c = Counter(attachMovie("Counter", "a"+i*squares+j, 100+squares*i+j, {row:-1, col:j, index:i+j, valueVisible:false, id:counters.length, board:this}));
					counters.push(c);
					Tweener.addTween(c, {row:i, time:1, delay:(delay++)/10, transition:"easeInOutCubic", onComplete:Delegate.create(this, finalCheck)});
					//counters.push(c);
					//c.id = counters.length-1;
					grid[j][i].push(c);
				}
			}
		}
		if(counters.length == 0) {
			answer.text = "0";
			another._visible = true;
			labelVisibility = false;
		}
		else {
			trace("delay = " + delay);
			Tweener.addTween(this, {labelVisibility:false, delay:1.1+delay/10, /*(2+lasti+lastj*0.1)/2,*/ time:0, transition:"linear"});
			//Tweener.addTween(instructions2, {_visible:true, delay:1.1+delay/10, /*(2+lasti+lastj*0.1)/2,*/ time:0, transition:"linear"});
		}
	}
	
	function hideLabels():Void {
		labelVisibility = false;
	}
	
	function get calculating():Boolean {
		return rowLabels[0]._visible;
	}
	
	function set calculating(b:Boolean):Void {
		if(b) {
			gotoSetup();
		}
		else {
			for(var i=0; i < rowLabels.length; i++) {
				rowLabels[i]._visible = false;
			}
			for(var j=0; j < rowLabels.length; j++) {
				colLabels[j]._visible = false;
			}
		}
	}
	
	function calculateRegs():Object {
		var u:Number = 0;
		var v:Number = 0;
		for(var i:Number = 0; i < squares; i++) {
			var r:LabCounter = LabCounter(rowLabels[i]);
			var c:LabCounter = LabCounter(colLabels[i]);
			if(r.chosen) u += Math.pow(2,i);
			if(c.chosen) v += Math.pow(2,i);
		}
		aStepper.text = areg.text = ""+u;
		bStepper.text = breg.text = ""+v;
		return {areg:u, breg:v};
	}
	
	function labelChanged(label:LabCounter):Void {
		
		calculateRegs();
	}

	function rowy(r:Number):Number {
		return (squares - r + 0.5)*squareSize + 1;
	}
	
	function yrow(y:Number):Number {
		return  Math.floor(squares + 0.5 - (y-1)/squareSize);
	}
	
	function colx(c:Number):Number {
		return (2*squares - c + 0.5 - coloff)*squareSize + 1;
	}
	
	function xcol(x:Number):Number {
		return  Math.floor(2*squares + 0.5 -coloff - (x-1)/squareSize);
	}
	
	function diagonalMove(r:Number, c:Number):Boolean {
		//trace(grid[c][r].length + " --> " + grid[c+1][r-1].length);
		var g:Array = grid[c+1][r-1];
		g.push(grid[c][r].pop());
		//trace(grid[c+1][r-1].length);
		if(g.length == 2) {
			trace("Move Left");
			Counter(g[0]).leftMove(g[1]);
			return true;
			//Counter(g[1]).remove();
		}
		return false;
		//trace("row = "+r+" col = "+c + " count = "+count);
	}
	
	function leftMove(r:Number, c:Number):Boolean {
		//trace(grid[c][r].length + " --> " + grid[c+1][r].length);
		var g:Array = grid[c+1][r];
		g.push(grid[c][r][0]);
		trace(grid[c+1][r].length);
		grid[c][r]=[];
		if(g.length == 2) {
			//trace("Move Left");
			Counter(g[0]).leftMove(g[1]);
			return true;
			//Counter(g[1]).remove();
		}
		return false;
	}
	
	function finalCheck():Boolean {
		trace("boo");
		//var starters:Array = [];
		trace("cl="+counters.length);
		if(Counter.tweening)
			return;
		for(var i:Number=0; i < counters.length; i++) {
			trace(i+" counters["+i+"] v=" + counters[i]._visible + " r="+counters[i].row);
			if(counters[i]._visible && Math.round(counters[i].row) != 0) {
				//starters.push(counters[i]);
				//trace(i+" counters["+i+"] v=" + counters[i]._visible + " r="+counters[i].row);
				return false;
			}
		}
		trace("instructions2 off");
		instructions2._visible = false;
		if(instructions3 == null)
			instructions3 = attachMovie("Instructions3", "instructions3", 803, {_y:340, _x:50});
		instructions3._visible = true;
		//counters.sortOn("index");
		for(i=0; i < counters.length; i++) {
			var c:Counter = counters[i];
			if(c._visible) {
				c.readyToGo = true;
				//animateResult(this, i);
				//return true;
			}
		}
		return true;
	}
	
	function animateResult(self:Board, cref:Number):Void {
		
		var c:Counter = self.counters[cref];
		
		c.showValue();
		c.valueVisible = true;
		
		var completion:Function = function() {
			if(self.answer.text == "?") self.answer.text = "0";
			self.answer.text = "" + (Number(self.answer.text) + Math.pow(2,c.index));
			c._visible = false;
			c.hideValue();
			for(var i:Number = 0; i < self.counters.length; i++) {
				var c2:Counter = self.counters[i];
				if(c2._visible) {
					return;
				}
			}
			trace("Really Done");
			self.equals._visible = true;
			self.another._visible = true;
		}
		
		Tweener.addTween(c, {_x:answer._x + 20, _y:answer._y-30, time:2, transition:"easeOutCubic", onComplete:completion});
	
	}
}