﻿import caurina.transitions.Tweener;

class Pad extends MovieClip {
	var _face:Face;
	var face0:Face;
	var black:Face;
	var id:Number;
    var type:String = "middle";
	var isButton:Boolean = false;
	var label:TextField;
	static var allPads:Array;
	
	static var tweenQ:Number = 0;
	
	function setup(colour:String, id:Number, kind:String, actionObject:Object, action:Function):Void {
		if(allPads==null) allPads = [];
		allPads.push(this);
		_face = face0 = Face(_root.attachMovie(colour, "Face" + id, id + 200, {_x:_x, _y:_y, actionObject:actionObject, action:action, kind:kind})); 
		if(kind != "middle") {
			black = Face(_root.attachMovie("BlackFace", "BlackFace" + id, id + 400, {_x:_x, _y:_y, kind:kind}));
			black._visible = false;
		}
		this.id = id;
		this.type = kind;
		NetState.squares[id] = this;
	}

	function get face():Face {
		return _face;
	}
	
	function set face(f:Face):Void {
		_face = f;
		
		if(NetState.blackened()) {
			_face._x = _x;
			_face._y = _y;
		}
		
		/* comment out for instantaneous transition */
		else 
			Tweener.addTween(_face, {_x:_x, _y:_y, time:1, delay:0, transition:"Linear"});
	}
	
	function reset():Void {
		face = face0;
	}
		
}
